/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.cloud.flow;

import com.ibm.vis.engine.internal.grammar.layout.cloud.Alignable;
import com.ibm.vis.engine.internal.grammar.layout.cloud.CloudAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.cloud.flow.ShapeFlow;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Rect;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FlowLayoutAlgorithm
implements CloudAlgorithm,
Alignable {
    private static final double THRESHOLD_FOR_SPACE_OVERRUN = 1.0E-5;
    private static final double THRESHOLD_FOR_SPACE_LEFT = 0.01;
    private String align = "middle";
    private String valign = "middle";
    private boolean bAlignBaseLine = false;

    @Override
    public void layoutShapes(List<Shape> list, Rect rect, Insets insets) {
        this.scaleShapesToBounds(list, rect);
        ShapeFlow shapeFlow = this.doLayout(list, 0.0, 1.0, 1.0, rect, insets);
        if (shapeFlow == null) {
            list.removeAll(list);
            return;
        }
        this.align = this.align == null ? "middle" : this.align;
        this.valign = this.valign == null ? "middle" : this.valign;
        shapeFlow.alignRows(this.align, this.valign);
        if (this.bAlignBaseLine) {
            shapeFlow.alignBaseLine(this.valign);
        }
        List<Rect> list2 = shapeFlow.getAllBounds();
        int n = 0;
        for (Shape shape : list) {
            if (shape == null) continue;
            Rect rect2 = list2.get(n++);
            Rect rect3 = shape.getBounds();
            shape.affine(1.0, rect2.getX() - rect3.getX(), 1.0, rect2.getY() - rect3.getY(), false);
        }
    }

    private void scaleShapesToBounds(List<Shape> list, Rect rect) {
        double d;
        double d2 = 0.0;
        for (Shape shape : list) {
            d = shape.getBounds().getHeight();
            if (!(d > d2)) continue;
            d2 = d;
        }
        for (Shape shape : list) {
            d = rect.getHeight() / d2;
            shape.scale(d, d);
        }
    }

    private ShapeFlow doLayout(List<Shape> list, double d, double d2, double d3, Rect rect, Insets insets) {
        double d4 = (d + d2) / 2.0;
        ShapeFlow shapeFlow = this.layout(list, d4 / d3, rect, insets);
        if (shapeFlow == null) {
            if (d2 - d <= 1.0E-5) {
                return shapeFlow;
            }
            d3 = d4;
            return this.doLayout(list, d, d4, d3, rect, insets);
        }
        if (shapeFlow.canAddAnotherRow()) {
            if (d2 - d <= 0.01) {
                return shapeFlow;
            }
            d3 = d4;
            return this.doLayout(list, d4, d2, d3, rect, insets);
        }
        return shapeFlow;
    }

    private ShapeFlow layout(List<Shape> list, double d, Rect rect, Insets insets) {
        ShapeFlow shapeFlow = new ShapeFlow(rect, insets);
        for (Shape shape : list) {
            if (shape == null) continue;
            shape.scale(d, d);
        }
        for (Shape shape : list) {
            if (shape == null || shapeFlow.addShape(shape)) continue;
            return null;
        }
        return shapeFlow;
    }

    @Override
    public void setHorizontalAlignment(String string) {
        this.align = string;
    }

    @Override
    public void setVerticalAlignment(String string) {
        this.valign = string;
    }

    @Override
    public void alignBaseLine(boolean bl) {
        this.bAlignBaseLine = bl;
    }

    @Override
    public boolean isAlignable() {
        return true;
    }
}

