/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.cloud.flow;

import com.ibm.vis.engine.internal.grammar.layout.cloud.flow.RowItem;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FlowRow {
    private double x;
    private double y;
    private double allowableWidth;
    private double allowableHeight;
    private double currentX;
    private double rowHeight;
    private List<RowItem> rowItems;
    private double maxDescent;
    private Insets padding;
    private double rowWidth;
    private Object currentAlign;

    FlowRow(double d, double d2, double d3, double d4, Insets insets) {
        this.x = d;
        this.y = d2;
        this.currentX = d;
        this.allowableWidth = d3;
        this.allowableHeight = d4;
        this.padding = insets;
        this.rowItems = new ArrayList<RowItem>();
    }

    final boolean addShape(Shape shape) {
        double d = shape.getBounds().getWidth() + this.padding.left + this.padding.right;
        double d2 = shape.getBounds().getHeight() + this.padding.top + this.padding.bottom;
        if (this.x + this.allowableWidth >= this.currentX + d && this.allowableHeight >= d2) {
            Text text;
            double d3;
            Rect rect = new Rect(this.currentX + this.padding.left, this.y + this.padding.top, shape.getBounds().getWidth(), shape.getBounds().getHeight());
            if (this.rowHeight < d2) {
                this.rowHeight = d2;
            }
            this.currentX += d;
            this.rowWidth += d;
            this.rowItems.add(new RowItem(rect, shape));
            if (shape instanceof Text && (d3 = (text = (Text)shape).getFont().getDescent()) > this.maxDescent) {
                this.maxDescent = d3;
            }
            return true;
        }
        return false;
    }

    final double getMaxDescent() {
        return this.maxDescent;
    }

    final double getRowHeight() {
        return this.rowHeight;
    }

    final double getY() {
        return this.y;
    }

    final List<RowItem> getRowItems() {
        return this.rowItems;
    }

    final void alignAllRowBounds(String string, String string2) {
        for (RowItem rowItem : this.rowItems) {
            Rect rect = rowItem.getBounds();
            rect.setY(this.y);
            if ("middle".equals(this.currentAlign)) {
                rect.setX(rect.getX() - (this.allowableWidth - this.rowWidth) / 2.0);
            } else if ("end".equals(this.currentAlign)) {
                rect.setX(rect.getX() - (this.allowableWidth - this.rowWidth));
            }
            double d = this.rowHeight - rect.getHeight();
            double d2 = this.allowableWidth - this.rowWidth;
            if ("middle".equals(string)) {
                d2 /= 2.0;
            }
            if ("middle".equals(string2)) {
                d /= 2.0;
            }
            if (!"start".equals(string)) {
                rect.setX(rect.getX() + d2);
            }
            if ("start".equals(string2)) continue;
            rect.setY(rect.getY() + d);
        }
        this.currentAlign = string;
    }

    final void adjustForDescent(String string) {
        for (RowItem rowItem : this.rowItems) {
            Rect rect = rowItem.getBounds();
            Shape shape = rowItem.getShape();
            if (!(shape instanceof Text)) {
                return;
            }
            Text text = (Text)shape;
            double d = this.rowHeight - rect.getHeight();
            if ("middle".equals(string)) {
                d /= 2.0;
            }
            if (!"end".equals(string)) {
                rect.setY(rect.getY() + d);
            }
            rect.setY(rect.getY() - (this.maxDescent - text.getFont().getDescent()));
        }
    }

    public Object getX() {
        return this.x;
    }

    public Object getRowWidth() {
        return this.rowWidth;
    }
}

