/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.cloud.flow;

import com.ibm.vis.engine.internal.grammar.layout.cloud.flow.FlowRow;
import com.ibm.vis.engine.internal.grammar.layout.cloud.flow.RowItem;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ShapeFlow {
    private FlowRow currentRow;
    private Rect bounds;
    private List<FlowRow> rows;
    private Insets padding;

    ShapeFlow(Rect rect, Insets insets) {
        this.bounds = rect;
        this.padding = insets;
        this.rows = new ArrayList<FlowRow>();
    }

    final boolean canAddAnotherRow() {
        if (this.currentRow != null) {
            return this.currentRow.getY() + this.currentRow.getRowHeight() < this.bounds.getY() + this.bounds.getHeight();
        }
        return this.bounds.getHeight() > 0.0;
    }

    final boolean addShape(Shape shape) {
        FlowRow flowRow = this.getCurrentRow();
        if (!flowRow.addShape(shape)) {
            flowRow = this.makeNewRow(flowRow);
            boolean bl = flowRow.addShape(shape);
            return bl;
        }
        return true;
    }

    private final FlowRow addRow(double d, double d2, double d3, double d4) {
        FlowRow flowRow = new FlowRow(d, d2, d3, d4, this.padding);
        this.rows.add(flowRow);
        return flowRow;
    }

    private final FlowRow makeNewRow(FlowRow flowRow) {
        if (flowRow == null) {
            this.currentRow = this.addRow(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
            return this.currentRow;
        }
        this.currentRow = this.addRow(this.bounds.getX(), flowRow.getY() + flowRow.getRowHeight(), this.bounds.getWidth(), this.bounds.getY() + this.bounds.getHeight() - (flowRow.getY() + flowRow.getRowHeight()));
        return this.currentRow;
    }

    final FlowRow getCurrentRow() {
        if (this.currentRow == null) {
            this.currentRow = this.addRow(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
        }
        return this.currentRow;
    }

    final List<Rect> getAllBounds() {
        ArrayList<Rect> arrayList = new ArrayList<Rect>();
        for (FlowRow flowRow : this.rows) {
            for (RowItem rowItem : flowRow.getRowItems()) {
                arrayList.add(rowItem.getBounds());
            }
        }
        return arrayList;
    }

    final void alignRows(String string, String string2) {
        for (FlowRow flowRow : this.rows) {
            flowRow.alignAllRowBounds(string, string2);
        }
    }

    final void alignBaseLine(String string) {
        for (FlowRow flowRow : this.rows) {
            flowRow.adjustForDescent(string);
        }
    }
}

