/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.cloud.spiral;

import com.ibm.vis.engine.internal.grammar.layout.cloud.spiral.Spiral;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Point;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class RectangularSpiral
extends Spiral {
    private int count = 2;
    private Point p = new Point(0.0, 0.0);

    public RectangularSpiral(Point point) {
        super(point);
        assert (point != null);
    }

    @Override
    protected Point nextPoint() {
        int n = this.count++;
        double d = 0.0;
        double d2 = 0.0;
        if (n >= 0) {
            int n2 = (int)Math.floor(Math.sqrt((double)n + 0.25) - 0.5);
            int n3 = n2 * (n2 + 1);
            int n4 = ((n2 & 1) << 1) - 1;
            int n5 = n4 * (n2 + 1 >> 1);
            d += (double)n5;
            d2 += (double)n5;
            int n6 = n3 + (n2 + 1);
            if (n < n6) {
                d -= (double)(n4 * (n - n3 + 1));
            } else {
                d -= (double)(n4 * (n2 + 1));
                d2 -= (double)(n4 * (n - n6 + 1));
            }
        }
        this.p.setX(Math.round(this.origin.getX() + 5.0 * d));
        this.p.setY(Math.round(this.origin.getY() + 10.0 * d2));
        return this.p;
    }
}

