/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.cloud.spiral;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.grammar.layout.cloud.CloudAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.cloud.spiral.PlacedText;
import com.ibm.vis.engine.internal.grammar.layout.cloud.spiral.RectangularSpiral;
import com.ibm.vis.engine.internal.grammar.layout.cloud.spiral.RoundSpiral;
import com.ibm.vis.engine.internal.grammar.layout.cloud.spiral.Spiral;
import com.ibm.vis.engine.internal.grammar.layout.cloud.spiral.SpiralOrientationScheme;
import com.ibm.vis.engine.internal.grammar.layout.cloud.spiral.SpiralType;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.DoubleHashMap;
import com.ibm.vis.engine.internal.nativeImpl.TextRaster;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.engine.internal.util.TextApproxHeightComparator;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SpiralLayoutAlgorithm
implements CloudAlgorithm {
    private Number[] orientations = new Number[]{0};
    private SpiralOrientationScheme orientationScheme = SpiralOrientationScheme.roundRobin;
    private SpiralType spiralType = SpiralType.rectangular;
    private boolean fitAll = true;
    private static final int INFLATION_MARGIN = 2;
    private static final double MIN_MAGNIFICATION_FACTOR = 1.1;
    private final DoubleHashMap<Affine> rotationTransformsCache = new DoubleHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutShapes(List<Shape> list, Rect rect, Insets insets) {
        List<Text> list2 = SpiralLayoutAlgorithm.prepareShapesForSpiralLayout(list);
        SpiralLayoutAlgorithm.sortDescendingByHeight(list2);
        Dim dim = rect.getExtent();
        TextRaster textRaster = new TextRaster(new Dim(Math.floor(dim.getWidth()), Math.floor(dim.getHeight())));
        try {
            Rect rect2 = new Rect(0.0, 0.0, textRaster.getSize().getWidth(), textRaster.getSize().getHeight());
            ArrayList<PlacedText> arrayList = new ArrayList<PlacedText>();
            Point point = new Point(0.0, 0.0);
            int n = 0;
            for (Shape shape : list2) {
                Number[] numberArray = this.getAnglesForWord(n);
                SpiralLayoutAlgorithm.checkForTextShape(shape);
                Text text = (Text)shape;
                Rect rect3 = text.getBounds();
                Rect rect4 = SpiralLayoutAlgorithm.inflateBounds(rect3);
                boolean bl = false;
                for (Number number : numberArray) {
                    double d = number.doubleValue();
                    double d2 = MathUtil.r3(d * Math.PI / 180.0).doubleValue();
                    Rect rect5 = this.computeTextRasterBounds(rect4, d2);
                    Dim dim2 = rect5.getExtent();
                    TextRaster textRaster2 = new TextRaster(dim2);
                    Point point2 = SpiralLayoutAlgorithm.getAnchor(text, d);
                    point2.setX(point2.getX() + 2.0);
                    point2.setY(point2.getY() + 2.0);
                    textRaster2.placeText(text, point2, d2, SpiralLayoutAlgorithm.getTextBorder(text, point2));
                    Spiral spiral = this.makeSpiral(rect2, n);
                    Point point3 = spiral.nextPoint();
                    while (true) {
                        Object object;
                        if (SpiralLayoutAlgorithm.isSpiralOutOfBounds(point3, rect2)) {
                            if (!this.fitAll) break;
                            textRaster = SpiralLayoutAlgorithm.magnifySprite(textRaster, arrayList, spiral, list2.size());
                            object = textRaster.getSize();
                            rect2.setWidth(((Dim)object).getWidth());
                            rect2.setHeight(((Dim)object).getHeight());
                        }
                        if (!rect2.containsPt(point3.getX(), point3.getY())) {
                            point3 = spiral.nextPoint();
                            continue;
                        }
                        rect5.transform(1.0, Math.round(point3.getX() - rect5.getX()), 1.0, Math.round(point3.getY() - rect5.getY()));
                        if (!rect2.containsRect(rect5)) {
                            point3 = spiral.nextPoint();
                            continue;
                        }
                        if (!textRaster2.collidesWith(textRaster, rect5)) {
                            object = SpiralLayoutAlgorithm.getAnchor(text, d);
                            ((Point)object).setX(point3.getX() + ((Point)object).getX() + 2.0);
                            ((Point)object).setY(point3.getY() + ((Point)object).getY() + 2.0);
                            shape.affine(1.0, ((Point)object).getX() - rect3.getX(), 1.0, ((Point)object).getY() - text.getPreciseAscent() - rect3.getY(), true);
                            point.setX(rect5.getX());
                            point.setY(rect5.getY());
                            textRaster.placeTextRaster(textRaster2, point);
                            Rect rect6 = SpiralLayoutAlgorithm.getTextBorder(text, (Point)object);
                            PlacedText placedText = new PlacedText(text, (Point)object, d2, rect6);
                            arrayList.add(placedText);
                            bl = true;
                            ++n;
                            textRaster2.dispose();
                            break;
                        }
                        point3 = spiral.nextPoint();
                    }
                    if (bl) break;
                }
                if (bl) continue;
                if (!this.fitAll) {
                    Rect rect7 = shape.getBounds();
                    shape.affine(1.0, rect7.getX() - 1000.0, 1.0, rect7.getY() - 1000.0, true);
                    continue;
                }
                throw new EngineException("Spiral layout requested that all shapes fit, but they cannot fit", ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
            }
            if (this.fitAll) {
                SpiralLayoutAlgorithm.scaleToFit(list2, dim, textRaster.getSize());
            }
            this.rotateAll(arrayList);
        }
        finally {
            textRaster.dispose();
        }
    }

    private static void scaleToFit(List<Text> list, Dim dim, Dim dim2) {
        int n;
        if (!dim.equals(dim2) && (n = list.size()) > 0) {
            Dim dim3 = dim2;
            double d = Math.max(dim3.getWidth() / dim.getWidth(), dim3.getHeight() / dim.getHeight());
            SpiralLayoutAlgorithm.scaleAll(list, 1.0 / d);
        }
    }

    private void rotateAll(List<PlacedText> list) {
        for (PlacedText placedText : list) {
            double d = placedText.getAngle();
            if (d == 0.0) continue;
            this.rotateText(placedText.getText(), d);
        }
    }

    private static void scaleAll(List<Text> list, double d) {
        for (Text text : list) {
            text.affine(d, 0.0, d, 0.0, true);
        }
    }

    private static TextRaster magnifySprite(TextRaster textRaster, List<PlacedText> list, Spiral spiral, int n) {
        Dim dim = textRaster.getSize();
        double d = (double)(n - list.size()) / (double)n;
        double d2 = Math.max(1.1, 1.0 + d * Math.min(d, d * 1.5));
        Dim dim2 = new Dim(Math.round(dim.getWidth() * d2), Math.round(dim.getHeight() * d2));
        TextRaster textRaster2 = new TextRaster(dim2);
        double d3 = Math.round((dim2.getWidth() - dim.getWidth()) / 2.0);
        double d4 = Math.round((dim2.getHeight() - dim.getHeight()) / 2.0);
        spiral.translateOrigin(d3, d4);
        textRaster2.placeTextRaster(textRaster, new Point(d3, d4));
        for (PlacedText placedText : list) {
            placedText.getText().affine(1.0, d3, 1.0, d4, true);
            placedText.translate(d3, d4);
        }
        textRaster.dispose();
        return textRaster2;
    }

    private static void checkForTextShape(Shape shape) {
        if (!(shape instanceof Text)) {
            throw new EngineException("A spiral layout is not supported by shapes other than text shapes", ErrorCode.ENGINE_UNSUPPORTED_OPERATION, null);
        }
    }

    private static List<Text> prepareShapesForSpiralLayout(List<Shape> list) {
        ArrayList<Text> arrayList = new ArrayList<Text>();
        for (Shape shape : list) {
            SpiralLayoutAlgorithm.checkForTextShape(shape);
            Text text = (Text)shape;
            text.align = "start";
            text.valign = "end";
            text.setNeedsPreciseHeight(true);
            arrayList.add(text);
        }
        return arrayList;
    }

    private Number[] getAnglesForWord(int n) {
        if (SpiralOrientationScheme.roundRobin.equals((Object)this.orientationScheme)) {
            return new Number[]{this.orientations[n % this.orientations.length].doubleValue()};
        }
        return this.orientations;
    }

    private Spiral makeSpiral(Rect rect, int n) {
        Point point = SpiralLayoutAlgorithm.getOriginForSpiral(rect, n);
        Spiral spiral = SpiralType.round.equals((Object)this.spiralType) ? new RoundSpiral(point) : new RectangularSpiral(point);
        return spiral;
    }

    protected static Point getOriginForSpiral(Rect rect, int n) {
        int n2 = 1;
        n2 = rect.getWidth() > rect.getHeight() ? (int)Math.ceil(rect.getWidth() / rect.getHeight()) : (int)Math.ceil(rect.getHeight() / rect.getWidth());
        double d = MathUtil.r3(1.0 / (double)(n2 + 1)).doubleValue();
        double d2 = 0.4;
        double d3 = 0.4;
        if (rect.getWidth() > rect.getHeight()) {
            d2 = (double)(n % n2 + 1) * d;
        } else if (rect.getWidth() < rect.getHeight()) {
            d3 = (double)(n % n2 + 1) * d;
        }
        Point point = new Point(Math.round(rect.getX() + d2 * rect.getWidth()), Math.round(rect.getY() + d3 * rect.getHeight()));
        return point;
    }

    private void rotateText(Text text, double d) {
        Affine affine = this.makeRotationTransform(d);
        double d2 = text.getBounds().getX();
        double d3 = text.getPreciseAscent() + text.getBounds().getY();
        Affine affine2 = new Affine(1.0, 0.0, d2, 0.0, 1.0, d3);
        Affine affine3 = affine2.multiply(affine);
        affine3 = affine3.multiply(new Affine(1.0, 0.0, -d2, 0.0, 1.0, -d3));
        text.setTransform(affine3);
    }

    private static Point getAnchor(Text text, double d) {
        if (d < 0.0 && d >= -90.0) {
            d = -d;
            double d2 = text.getPreciseAscent();
            double d3 = text.getBounds().getWidth();
            double d4 = Math.PI * d / 180.0;
            double d5 = Math.cos(d4);
            double d6 = Math.sin(d4);
            double d7 = d2 * d6;
            double d8 = d3 * d6 + d2 * d5;
            return new Point(Math.round(d7), Math.round(d8));
        }
        if (d > 0.0 && d <= 90.0) {
            double d9 = text.getPreciseAscent();
            double d10 = text.getPreciseDescent();
            double d11 = Math.PI * d / 180.0;
            double d12 = Math.cos(d11);
            double d13 = d10 * Math.cos(1.5707963267948966 - d11);
            double d14 = d9 * d12;
            return new Point(Math.round(d13), Math.round(d14));
        }
        return new Point(0.0, Math.round(text.getPreciseAscent()));
    }

    private Affine makeRotationTransform(double d) {
        Affine affine = this.rotationTransformsCache.get(d);
        if (affine == null) {
            affine = Affine.makeRotation(d, 0.0, 0.0);
            this.rotationTransformsCache.put(d, affine);
        }
        return affine;
    }

    private static void sortDescendingByHeight(List<Text> list) {
        BasicFactory.sortList(list, new TextApproxHeightComparator());
    }

    private static boolean isSpiralOutOfBounds(Point point, Rect rect) {
        if (point.getX() >= rect.getX() && point.getX() <= rect.getX() + rect.getWidth()) {
            return false;
        }
        return !(point.getY() >= rect.getY()) || !(point.getY() <= rect.getY() + rect.getHeight());
    }

    public void setOrientations(Number[] numberArray) {
        if (numberArray != null) {
            for (Number number : numberArray) {
                if (!(number.doubleValue() > 90.0) && !(number.doubleValue() < -90.0)) continue;
                throw new EngineException("Invalid orientation " + number + ". Orientation angle has to be specified between +90 and -90, both inclusive", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
            }
            this.orientations = numberArray;
        }
    }

    public void setOrientationScheme(String string) {
        this.orientationScheme = SpiralOrientationScheme.sequential.name().equals(string) ? SpiralOrientationScheme.sequential : SpiralOrientationScheme.roundRobin;
    }

    public void setSpiralType(String string) {
        this.spiralType = SpiralType.round.name().equals(string) ? SpiralType.round : SpiralType.rectangular;
    }

    public void setFitAll(Boolean bl) {
        this.fitAll = bl;
    }

    private Rect computeTextRasterBounds(Rect rect, double d) {
        Rect rect2 = rect;
        if (d != 0.0) {
            rect2 = Shape.transformBounds(rect2, this.makeRotationTransform(d)).getBounds();
        }
        double d2 = Math.floor(rect2.getX());
        double d3 = Math.floor(rect2.getY());
        double d4 = Math.ceil(rect2.getWidth());
        double d5 = Math.ceil(rect2.getHeight());
        return new Rect(d2, d3, d4, d5);
    }

    private static Rect getTextBorder(Text text, Point point) {
        double d = Math.floor(point.getX());
        double d2 = Math.floor(point.getY());
        double d3 = Math.ceil(text.getPreciseHeight());
        double d4 = Math.ceil(text.getWidth());
        return new Rect(d -= 1.0, d2 -= (double)(1L + Math.round(text.getPreciseAscent())), d4 + 1.0, d3 + 1.0);
    }

    private static Rect inflateBounds(Rect rect) {
        return new Rect(rect.getX() - 2.0, rect.getY() - 2.0, rect.getWidth() + 4.0, rect.getHeight() + 4.0);
    }

    @Override
    public boolean isAlignable() {
        return false;
    }
}

