/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.layout.Layout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.SharedLayoutInfo;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.FieldRefSpec;
import com.ibm.vis.spec.internal.LayoutSpec;
import com.ibm.vis.spec.internal.PositionOverrideSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class AbstractGraphLayout
extends Layout {
    public static final String ORIENTATION_TOP_TO_BOTTOM = "top-to-bottom";
    public static final String ORIENTATION_BOTTOM_TO_TOP = "bottom-to-top";
    public static final String ORIENTATION_LEFT_TO_RIGHT = "left-to-right";
    public static final String ORIENTATION_RIGHT_TO_LEFT = "right-to-left";
    protected final String idField;
    private final String fromField;
    private final String toField;
    private final String sizeField;
    private final String nodeOrderField;
    private Dim preferredSize = null;
    private boolean nodesCached = false;
    protected Node[] nodes;
    protected Link[] links;
    private PositionOverrideSpec[] positionOverride;

    public AbstractGraphLayout(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
        LayoutSpec layoutSpec = layoutAdapter.getSpec();
        this.idField = layoutSpec.id == null ? null : layoutSpec.id.$ref;
        this.fromField = layoutSpec.from == null ? null : layoutSpec.from.$ref;
        this.toField = layoutSpec.to == null ? null : layoutSpec.to.$ref;
        this.sizeField = layoutSpec.size == null ? null : ((FieldRefSpec)layoutSpec.size).$ref;
        this.nodeOrderField = layoutSpec.order == null ? null : layoutSpec.order.$ref;
        this.positionOverride = layoutSpec.positionOverride == null ? new PositionOverrideSpec[0] : layoutSpec.positionOverride;
        this.nodes = null;
        this.links = null;
    }

    @Override
    public void prepareForNewRows(int n) {
        this.nodes = null;
        this.links = null;
        this.nodesCached = false;
        this.preferredSize = null;
    }

    @Override
    public String getDefaultOrientation() {
        return this.directedAlgorithm() ? ORIENTATION_TOP_TO_BOTTOM : null;
    }

    public final int getNodesCount() {
        return this.nodes.length;
    }

    public final int getLinksCount() {
        return this.links.length;
    }

    public final Node[] getNodes() {
        return this.nodes;
    }

    public final Link[] getLinks() {
        return this.links;
    }

    protected final Dim getPrefSize() {
        return this.preferredSize;
    }

    protected final void setPrefSize(Dim dim) {
        this.preferredSize = dim;
    }

    @Override
    public final List<Shape> makeElementShapes(int n, Dim dim) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        if (n == 0 && !this.isNodeLayerDefined()) {
            return arrayList;
        }
        if (dim.getWidth() <= 0.0 || dim.getHeight() <= 0.0) {
            throw new EngineException("Unable to layout graph within the area: " + dim.getWidth() + " x " + dim.getHeight(), ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
        }
        Rect rect = this.getPaddedBounds(dim);
        Dim dim2 = rect.getExtent();
        this.nodesCached = this.getPrefSize() != null && this.nodes != null && this.nodes.length == n && this.getPrefSize().getHeight() <= dim2.getHeight() && this.getPrefSize().getWidth() <= dim2.getWidth();
        this.adapter.getSharedLayoutInfo().setPaddedBounds(rect);
        if (dim2.getWidth() <= 0.0 || dim2.getHeight() <= 0.0) {
            throw new EngineException("Unable to layout graph due to excessive padding.", ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
        }
        if (this.adapter.hasListeners()) {
            this.adapter.logInfo("Graph layout starting", null, null);
        }
        this.makeNodesAndLinks(n);
        if (this.adapter.hasListeners()) {
            this.adapter.logInfo("Graph layout built nodes", "nodeCount", this.nodes.length);
            this.adapter.logInfo("Graph layout built links", "linkCount", this.links.length);
        }
        if (n == 1 && !this.isNodeLayerDefined()) {
            if (!this.nodes[0].isDummy() && !this.nodes[0].isNodePruned()) {
                Range[] rangeArray = new Range[1];
                int[] nArray = new int[1];
                HashMap<Number, Integer> hashMap = new HashMap<Number, Integer>();
                double d = (rect.getX() + rect.getWidth() / 2.0) / dim.getWidth();
                double d2 = 1.0 - (rect.getY() + rect.getHeight() / 2.0) / dim.getHeight();
                arrayList.add(this.adapter.makeItemAtSimpleCoordinates(new double[]{d2, d}, 0, this.needsAestheticsPreApplied()));
                rangeArray[0] = new Range(0.0, 1.0);
                nArray[0] = 1;
                hashMap.put(this.nodes[0].getId(), this.nodes[0].getLayer());
                this.adapter.getSharedLayoutInfo().setLayerInfo(rangeArray, nArray, hashMap);
            }
            return arrayList;
        }
        this.setShapesToNodes(dim2);
        this.positionNodesManually();
        this.layoutNodes(dim2);
        this.finishSetup(dim, arrayList, dim2, rect);
        return arrayList;
    }

    public void setupLayersForSizing(int n, Dim dim) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        if (n == 0 && !this.isNodeLayerDefined()) {
            return;
        }
        if (dim.getWidth() <= 0.0 || dim.getHeight() <= 0.0) {
            throw new EngineException("Unable to layout graph within the area: " + dim.getWidth() + " x " + dim.getHeight(), ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
        }
        Rect rect = this.getPaddedBounds(dim);
        Dim dim2 = rect.getExtent();
        this.nodesCached = this.getPrefSize() != null && this.nodes != null && this.nodes.length == n && this.getPrefSize().getHeight() <= dim2.getHeight() && this.getPrefSize().getWidth() <= dim2.getWidth();
        this.adapter.getSharedLayoutInfo().setPaddedBounds(rect);
        if (dim2.getWidth() <= 0.0 || dim2.getHeight() <= 0.0) {
            throw new EngineException("Unable to layout graph due to excessive padding.", ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
        }
        if (this.adapter.hasListeners()) {
            this.adapter.logInfo("Graph layout starting", null, null);
        }
        this.makeNodesAndLinks(n);
        if (this.adapter.hasListeners()) {
            this.adapter.logInfo("Graph layout built nodes", "nodeCount", this.nodes.length);
            this.adapter.logInfo("Graph layout built links", "linkCount", this.links.length);
        }
        if (n == 1 && !this.isNodeLayerDefined()) {
            if (!this.nodes[0].isDummy() && !this.nodes[0].isNodePruned()) {
                Range[] rangeArray = new Range[1];
                int[] nArray = new int[1];
                HashMap<Number, Integer> hashMap = new HashMap<Number, Integer>();
                double d = (rect.getX() + rect.getWidth() / 2.0) / dim.getWidth();
                double d2 = 1.0 - (rect.getY() + rect.getHeight() / 2.0) / dim.getHeight();
                arrayList.add(this.adapter.makeItemAtSimpleCoordinates(new double[]{d2, d}, 0, this.needsAestheticsPreApplied()));
                rangeArray[0] = new Range(0.0, 1.0);
                nArray[0] = 1;
                hashMap.put(this.nodes[0].getId(), this.nodes[0].getLayer());
                this.adapter.getSharedLayoutInfo().setLayerInfo(rangeArray, nArray, hashMap);
            }
            return;
        }
        this.setShapesToNodes(dim2);
        this.positionNodesManually();
        this.setupNodeLayering(dim);
        this.finishSetup(dim, arrayList, dim2, rect);
    }

    private void finishSetup(Dim dim, ArrayList<Shape> arrayList, Dim dim2, Rect rect) {
        this.restoreLinkData();
        this.placeInExtent(dim2);
        for (Node object : this.nodes) {
            if (object.isDummy() || object.isNodePruned() || object.positionSpecified()) continue;
            Shape shape = object.getShape();
            this.applyBoundedAffineTransform(shape, 1.0, object.getX(), 1.0, object.getY(), rect, object);
            arrayList.add(shape);
        }
        for (PositionOverrideSpec positionOverrideSpec : this.positionOverride) {
            int n = positionOverrideSpec.node.intValue();
            Node node = null;
            for (int i = 0; node == null && i < this.nodes.length; ++i) {
                if (this.nodes[i].getRow() != n) continue;
                node = this.nodes[i];
            }
            if (node == null) continue;
            node.moveToSpecifiedPosition();
            Shape shape = node.getShape();
            this.applyBoundedAffineTransform(shape, 1.0, node.getX(), 1.0, node.getY(), Rect.makeRectFromDim(dim), node);
            arrayList.add(shape);
        }
    }

    protected boolean isNodeLayerDefined() {
        return false;
    }

    protected void restoreLinkData() {
    }

    protected void setShapesToNodes(Dim dim) {
        if (this.nodesCached) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i].isDummy()) continue;
                this.nodes[i].setWidth(this.nodes[i].getShape().getBounds().getExtent().getWidth() / dim.getWidth());
                this.nodes[i].setHeight(this.nodes[i].getShape().getBounds().getExtent().getHeight() / dim.getHeight());
            }
        } else {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i].isDummy()) continue;
                Shape shape = this.adapter.makeItemAtSimpleCoordinates(new double[]{this.nodes[i].getY(), this.nodes[i].getX()}, this.nodes[i].getRow(), this.needsAestheticsPreApplied());
                this.nodes[i].setShape(shape);
                this.nodes[i].setWidth(shape.getBounds().getExtent().getWidth() / dim.getWidth());
                this.nodes[i].setHeight(shape.getBounds().getExtent().getHeight() / dim.getHeight());
            }
        }
    }

    protected void applyBoundedAffineTransform(Shape shape, double d, double d2, double d3, double d4, Rect rect, Node node) {
        Rect rect2 = shape.getBounds();
        double d5 = rect.getX() + d2 * rect.getWidth() - rect2.getX() - rect2.getWidth() / 2.0;
        double d6 = rect.getY() + (1.0 - d4) * rect.getHeight() - rect2.getY() - rect2.getHeight() / 2.0;
        shape.affine(d, d5, d3, d6, false);
    }

    protected final boolean linksWeighted() {
        return this.sizeField != null;
    }

    public void positionNodesManually() {
        SharedLayoutInfo sharedLayoutInfo = this.adapter.getSharedLayoutInfo();
        for (PositionOverrideSpec positionOverrideSpec : this.positionOverride) {
            int n = positionOverrideSpec.node.intValue();
            if (n < 0 || n >= this.nodes.length) continue;
            Node node = this.nodes[n];
            sharedLayoutInfo.setManuallyPositioned(n);
            node.specifyPosition(positionOverrideSpec.x.doubleValue(), positionOverrideSpec.y.doubleValue());
        }
    }

    protected abstract void layoutNodes(Dim var1);

    protected abstract void setupNodeLayering(Dim var1);

    protected void makeNodesAndLinks(int n) {
        Object[] objectArray;
        HashMap<Number, Node> hashMap = new HashMap<Number, Node>();
        if (this.nodesCached) {
            for (int i = 0; i < this.nodes.length; ++i) {
                hashMap.put(this.nodes[i].getId(), this.nodes[i]);
                objectArray = new ArrayList[]{new ArrayList(), new ArrayList()};
                this.nodes[i].setInfo(objectArray);
            }
        } else {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            this.nodes = this.makeNodes(n, arrayList, hashMap);
        }
        double[] dArray = this.adapter.getAllFieldValuesAsNumeric(this.fromField);
        objectArray = this.adapter.getAllFieldValuesAsNumeric(this.toField);
        this.links = this.makeLinks(dArray, (double[])objectArray, hashMap);
    }

    private Link[] makeLinks(double[] dArray, double[] dArray2, HashMap<Number, Node> hashMap) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        if (dArray != null && dArray2 != null) {
            for (int i = 0; i < dArray.length; ++i) {
                this.createLink(i, dArray, dArray2, hashMap, arrayList);
            }
            this.reorderLinks(arrayList);
            this.populateNodeLinkInfo();
        }
        return arrayList.toArray(new Link[arrayList.size()]);
    }

    protected void reorderLinks(ArrayList<Link> arrayList) {
    }

    protected void populateNodeLinkInfo() {
        for (Node node : this.nodes) {
            ArrayList[] arrayListArray = (ArrayList[])node.getInfo();
            node.setOutLink(arrayListArray[0].toArray(new Link[arrayListArray[0].size()]));
            node.inLink = arrayListArray[1].toArray(new Link[arrayListArray[1].size()]);
            node.setInfo(null);
        }
    }

    protected Link createLink(int n, double[] dArray, double[] dArray2, HashMap<Number, Node> hashMap, ArrayList<Link> arrayList) {
        double d = 1.0;
        if (this.sizeField != null && (Double.isNaN(d = this.adapter.getFieldNumericValue(this.sizeField, n)) || !(d > 0.0))) {
            return null;
        }
        Node node = hashMap.get(dArray[n]);
        Node node2 = hashMap.get(dArray2[n]);
        if (node != null && node2 != null && node != node2) {
            Link link = new Link(node, node2);
            link.setRow(n);
            link.setWeight(d);
            if (this.adapter.isLinkPruned(dArray[n], dArray2[n])) {
                link.setLinkPruned(true);
            }
            ((ArrayList[])node.getInfo())[0].add(link);
            ((ArrayList[])node2.getInfo())[1].add(link);
            arrayList.add(link);
            return link;
        }
        if (node == null && this.adapter.hasListeners()) {
            this.adapter.logWarn("Could not find from node for link", "link #", n);
        }
        if (node2 == null && this.adapter.hasListeners()) {
            this.adapter.logWarn("Could not find to node for link", "link #", n);
        }
        return null;
    }

    private Node[] makeNodes(int n, List<Node> list, HashMap<Number, Node> hashMap) {
        for (int i = 0; i < n; ++i) {
            double d = this.adapter.getFieldNumericValue(this.idField, i);
            if (Double.isNaN(d)) continue;
            Node node = new Node(i);
            ArrayList[] arrayListArray = new ArrayList[]{new ArrayList(), new ArrayList()};
            node.setInfo(arrayListArray);
            node.setId(d);
            node.setOrientation(this.adapter.isSwapXY(), this.adapter.isReflectY());
            node.setOrder(this.nodeOrderField == null ? null : Double.valueOf(this.adapter.getFieldNumericValue(this.nodeOrderField, i)));
            hashMap.put(d, node);
            list.add(node);
            if (!this.adapter.isNodePruned(d)) continue;
            node.setNodePruned(true);
        }
        return list.toArray(new Node[list.size()]);
    }

    protected boolean directedAlgorithm() {
        return false;
    }

    protected void placeInExtent(Dim dim) {
        Range range = this.getAcrossRange(this.nodes);
        Range range2 = this.getDownRange(this.nodes);
        this.refitNodes(this.nodes, range, range2);
        Dim dim2 = this.adapter.getElementSize();
        double d = dim2.getWidth() / 2.0 / dim.getWidth();
        double d2 = dim2.getHeight() / 2.0 / dim.getHeight();
        Range range3 = new Range(d, 1.0 - d);
        Range range4 = new Range(d2, 1.0 - d2);
        SharedLayoutInfo sharedLayoutInfo = this.adapter.getSharedLayoutInfo();
        for (Link link : this.links) {
            Point[] pointArray = sharedLayoutInfo.getRoutingInfo(link.getFrom().getRow(), link.getTo().getRow());
            ArrayList<Point> arrayList = new ArrayList<Point>();
            for (Point point : pointArray) {
                double d3 = range3.fromZeroOne(range.toZeroOne(point.getX()));
                double d4 = range4.fromZeroOne(range2.toZeroOne(point.getY()));
                arrayList.add(new Point(d3, d4));
            }
            sharedLayoutInfo.addRoutingInfo(link.getFrom().getRow(), link.getTo().getRow(), arrayList, null);
        }
    }

    protected Range getDownRange(Node[] nodeArray) {
        Range range = null;
        for (Node node : this.nodes) {
            range = range == null ? new Range(node.getY(), node.getY()) : range.unionValue(node.getY());
        }
        return range;
    }

    protected Range getAcrossRange(Node[] nodeArray) {
        Range range = null;
        for (Node node : nodeArray) {
            range = range == null ? new Range(node.getX(), node.getX()) : range.unionValue(node.getX());
        }
        return range;
    }

    protected void refitNodes(Node[] nodeArray, Range range, Range range2) {
        for (Node node : nodeArray) {
            double d = node.getWidth() / 2.0;
            double d2 = node.getHeight() / 2.0;
            if (this.adapter.isSwapXY()) {
                double d3 = d2;
                d2 = d;
                d = d3;
            }
            Range range3 = new Range(d, 1.0 - d);
            Range range4 = new Range(d2, 1.0 - d2);
            node.setX(range3.fromZeroOne(range.toZeroOne(node.getX())));
            node.setY(range4.fromZeroOne(range2.toZeroOne(node.getY())));
        }
    }

    @Override
    public boolean needsAestheticsPreApplied() {
        return true;
    }

    @Override
    public boolean isGraph() {
        return true;
    }

    public void addDummyNodes(Node[] nodeArray) {
        if (nodeArray != null) {
            Node[] nodeArray2;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Node node : nodeArray2 = this.getNodes()) {
                arrayList.add(node);
            }
            for (Node node : nodeArray) {
                arrayList.add(node);
            }
            this.nodes = arrayList.toArray(new Node[arrayList.size()]);
        }
    }

    protected void checkForCycle(Node node) {
        HashSet<Node> hashSet = new HashSet<Node>();
        hashSet.add(node);
        this.visitChildren(node, hashSet);
    }

    protected void visitChildren(Node node, Set<Node> set) {
        List<Node> list = node.getChildren();
        for (Node node2 : list) {
            if (set.contains(node2)) {
                throw new EngineException("Cannot create a fishbone graph. Data is cyclic.", ErrorCode.DATA_INVALID, null);
            }
            set.add(node2);
            this.visitChildren(node2, set);
            set.remove(node2);
        }
    }
}

