/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.LinkLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAG;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAGNodePlacementAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class AdaptiveLayerVerticalPlacement
implements DAGNodePlacementAlgorithm {
    private final LayoutAdapter adapter;

    AdaptiveLayerVerticalPlacement(LayoutAdapter layoutAdapter) {
        this.adapter = layoutAdapter;
    }

    @Override
    public void layoutNodes(Node[][] nodeArray, Dim dim) {
        int n;
        double[] dArray = new double[nodeArray.length];
        int[] nArray = new int[nodeArray.length];
        double d = this.getNodeMinSize(nodeArray) / 2.0;
        double d2 = 0.0;
        for (n = 0; n < nodeArray.length; ++n) {
            nArray[n] = DAG.getMaxLevel(nodeArray[n]);
            double d3 = this.getIntraLayerLinkExtent(nArray[n], this.getHeightOfExtent(dim));
            double d4 = this.getNodeSize(nodeArray[n]);
            dArray[n] = Math.max(d, d3 + d4);
            d2 += dArray[n];
        }
        n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] / d2;
        }
        double[] dArray2 = this.createLayerCenters(dArray);
        Range[] rangeArray = new Range[nodeArray.length];
        HashMap<Number, Integer> hashMap = new HashMap<Number, Integer>();
        for (int i = 0; i < nodeArray.length; ++i) {
            rangeArray[i] = new Range(dArray2[i] - dArray[i] / 2.0, dArray2[i] + dArray[i] / 2.0);
            for (Node node : nodeArray[i]) {
                node.setY(dArray2[i]);
                hashMap.put(node.getId(), node.getLayer());
            }
        }
        this.adapter.getSharedLayoutInfo().setLayerInfo(rangeArray, nArray, hashMap);
    }

    private double[] createLayerCenters(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = d + dArray[i] / 2.0;
            d += dArray[i];
        }
        return dArray2;
    }

    private double getNodeSize(Node[] nodeArray) {
        double d = 0.0;
        for (Node node : nodeArray) {
            d = Math.max(d, this.getHeight(node));
        }
        return d;
    }

    private double getNodeMinSize(Node[][] nodeArray) {
        double d = 1.0;
        Node[][] nodeArray2 = nodeArray;
        int n = nodeArray2.length;
        for (int i = 0; i < n; ++i) {
            Node[] nodeArray3;
            for (Node node : nodeArray3 = nodeArray2[i]) {
                double d2 = this.getHeight(node);
                if (!(d2 > 1.0E-6)) continue;
                d = Math.min(d, d2);
            }
        }
        return d;
    }

    private double getIntraLayerLinkExtent(int n, double d) {
        double d2 = DAG.getStrokeWidthFromStyle(this.adapter.getLinkStyle());
        return LinkLayout.getGoodSpaceToFit(n, d, d2);
    }

    private double getHeightOfExtent(Dim dim) {
        return this.adapter.isSwapXY() ? dim.getWidth() : dim.getHeight();
    }

    private double getHeight(Node node) {
        return this.adapter.isSwapXY() ? node.getWidth() : node.getHeight();
    }
}

