/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAGLayerAssignmentAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.Graph;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class AssignLayerFromSpec
implements DAGLayerAssignmentAlgorithm {
    private final String layerField;
    private final LayoutAdapter adapter;

    public AssignLayerFromSpec(LayoutAdapter layoutAdapter) {
        this.adapter = layoutAdapter;
        this.layerField = layoutAdapter.getSpec().layer == null ? null : layoutAdapter.getSpec().layer.$ref;
    }

    @Override
    public int assignLayers(Graph graph) {
        double[] dArray = this.adapter.getAllFieldValuesAsNumeric(this.layerField);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : graph.nodes) {
            if (!node.isDummy()) {
                double d = dArray[node.getRow()];
                if (Double.isNaN(d)) continue;
                double d2 = Math.floor(d);
                node.setLayer((int)d2);
                arrayList.add(node);
                continue;
            }
            arrayList.add(node);
        }
        graph.nodes = arrayList.toArray(new Node[arrayList.size()]);
        graph.removeUnwantedLinks();
        graph.reverseLinksIfNeeded();
        return 1 + (int)Math.floor(this.adapter.getFieldRange(this.layerField).getMax());
    }
}

