/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.AttachmentPointsSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AttachmentPoint {
    public static final String ATTACH_CENTER = "center";
    public static final String ATTACH_CLOSEST = "closestPoint";
    private final LayoutAdapter adapter;
    private final boolean inPointCenter;
    private final boolean inPointClosestPoint;
    private final boolean outPointCenter;
    private final boolean outPointClosestPoint;
    private final String inPointValue;
    private final String inPointField;
    private final String outPointValue;
    private final String outPointField;

    public AttachmentPoint(LayoutAdapter layoutAdapter, Object object) {
        this.adapter = layoutAdapter;
        if (object == null) {
            this.inPointCenter = false;
            this.outPointCenter = false;
            this.inPointClosestPoint = true;
            this.outPointClosestPoint = true;
            this.inPointValue = null;
            this.inPointField = null;
            this.outPointValue = null;
            this.outPointField = null;
            return;
        }
        if (BasicFactory.isString(object)) {
            if (ATTACH_CENTER.equals(object)) {
                this.inPointCenter = true;
                this.outPointCenter = true;
                this.inPointClosestPoint = false;
                this.outPointClosestPoint = false;
                this.inPointValue = null;
                this.inPointField = null;
                this.outPointValue = null;
                this.outPointField = null;
                return;
            }
            if (ATTACH_CLOSEST.equals(object)) {
                this.inPointCenter = false;
                this.outPointCenter = false;
                this.inPointClosestPoint = true;
                this.outPointClosestPoint = true;
                this.inPointValue = null;
                this.inPointField = null;
                this.outPointValue = null;
                this.outPointField = null;
                return;
            }
            throw new SpecException("Illegal string value for attachmentPoint, only 'center' and 'closestPoint' allowed", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        AttachmentPointsSpec attachmentPointsSpec = (AttachmentPointsSpec)object;
        if (attachmentPointsSpec.inPoint == null) {
            this.inPointCenter = false;
            this.inPointClosestPoint = true;
            this.inPointValue = null;
            this.inPointField = null;
        } else {
            if (attachmentPointsSpec.inPoint.value == null && (attachmentPointsSpec.inPoint.field == null || attachmentPointsSpec.inPoint.field.$ref == null) || attachmentPointsSpec.inPoint.value != null && attachmentPointsSpec.inPoint.field != null) {
                throw new SpecException("attachmentPoint.inPoint must be defined with either a 'value' or a 'field' but not both", ErrorCode.SPEC_INVALID_VALUE, null);
            }
            if (attachmentPointsSpec.inPoint.value != null) {
                this.inPointCenter = false;
                this.inPointClosestPoint = false;
                this.inPointValue = attachmentPointsSpec.inPoint.value;
                this.inPointField = null;
            } else {
                if (!layoutAdapter.isField(attachmentPointsSpec.inPoint.field.$ref)) {
                    throw new SpecException("attachmentPoint.inPoint.field must be a field reference", ErrorCode.SPEC_INVALID_VALUE, null);
                }
                this.inPointCenter = false;
                this.inPointClosestPoint = false;
                this.inPointValue = null;
                this.inPointField = attachmentPointsSpec.inPoint.field.$ref;
            }
        }
        if (attachmentPointsSpec.outPoint == null) {
            this.outPointCenter = false;
            this.outPointClosestPoint = true;
            this.outPointValue = null;
            this.outPointField = null;
        } else {
            if (attachmentPointsSpec.outPoint.value == null && (attachmentPointsSpec.outPoint.field == null || attachmentPointsSpec.outPoint.field.$ref == null) || attachmentPointsSpec.outPoint.value != null && attachmentPointsSpec.outPoint.field != null) {
                throw new SpecException("attachmentPoint.outPoint must be defined with either a 'value' or a 'field' but not both", ErrorCode.SPEC_INVALID_VALUE, null);
            }
            if (attachmentPointsSpec.outPoint.value != null) {
                this.outPointCenter = false;
                this.outPointClosestPoint = false;
                this.outPointValue = attachmentPointsSpec.outPoint.value;
                this.outPointField = null;
            } else {
                if (!layoutAdapter.isField(attachmentPointsSpec.outPoint.field.$ref)) {
                    throw new SpecException("attachmentPoint.outPoint.field must be a field reference", ErrorCode.SPEC_INVALID_VALUE, null);
                }
                this.outPointCenter = false;
                this.outPointClosestPoint = false;
                this.outPointValue = null;
                this.outPointField = attachmentPointsSpec.outPoint.field.$ref;
            }
        }
    }

    public final boolean isInPointCenter() {
        return this.inPointCenter;
    }

    public final boolean isInPointClosestPoint() {
        return this.inPointClosestPoint;
    }

    public final boolean isInPointNamed() {
        return !this.inPointClosestPoint && !this.inPointCenter;
    }

    public String getInName(int n) {
        if (this.inPointCenter || this.inPointClosestPoint) {
            throw new EngineException("Illegal use of AttachmentPoint#getConnectionPointName, please contact the RAVE Team", ErrorCode.ENGINE_UNSUPPORTED_OPERATION, null);
        }
        if (this.inPointValue != null) {
            return this.inPointValue;
        }
        return this.adapter.getFieldStringValue(this.inPointField, n);
    }

    public final boolean isOutPointCenter() {
        return this.outPointCenter;
    }

    public final boolean isOutPointClosestPoint() {
        return this.outPointClosestPoint;
    }

    public final boolean isOutPointNamed() {
        return !this.outPointClosestPoint && !this.outPointCenter;
    }

    public String getOutName(int n) {
        if (this.outPointCenter || this.outPointClosestPoint) {
            throw new EngineException("Illegal use of AttachmentPoint#getConnectionPointName, please contact the RAVE Team", ErrorCode.ENGINE_UNSUPPORTED_OPERATION, null);
        }
        if (this.outPointValue != null) {
            return this.outPointValue;
        }
        return this.adapter.getFieldStringValue(this.outPointField, n);
    }
}

