/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAG;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAGNodePlacementAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class CenteredInLayer
implements DAGNodePlacementAlgorithm {
    private final LayoutAdapter adapter;

    CenteredInLayer(LayoutAdapter layoutAdapter) {
        this.adapter = layoutAdapter;
    }

    @Override
    public void layoutNodes(Node[][] nodeArray, Dim dim) {
        int[] nArray = new int[nodeArray.length];
        Range[] rangeArray = new Range[nodeArray.length];
        HashMap<Number, Integer> hashMap = new HashMap<Number, Integer>();
        for (int i = 0; i < nodeArray.length; ++i) {
            nArray[i] = DAG.getMaxLevel(nodeArray[i]);
            rangeArray[i] = new Range((double)i / (double)nodeArray.length, (double)(i + 1) / (double)nodeArray.length);
            for (Node node : nodeArray[i]) {
                node.setY(rangeArray[i].mid());
                hashMap.put(node.getId(), node.getLayer());
            }
        }
        this.adapter.getSharedLayoutInfo().setLayerInfo(rangeArray, nArray, hashMap);
    }
}

