/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.IntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Crossings {
    private final Node[] nodes;
    private final Link[] links;
    private final IntHashMap<Integer> rowToIndexMap;
    private final int[][] linkNodes;
    final int[] counts;
    int total;
    private HashMap<Link, Integer> linksToIndexMap;

    public Crossings(Node[] nodeArray, Link[] linkArray) {
        int n;
        this.nodes = nodeArray;
        this.links = linkArray;
        this.linksToIndexMap = new HashMap();
        for (n = 0; n < linkArray.length; ++n) {
            this.linksToIndexMap.put(linkArray[n], n);
        }
        this.rowToIndexMap = new IntHashMap();
        for (n = 0; n < this.nodes.length; ++n) {
            int n2 = Math.abs(this.nodes[n].getRow());
            this.rowToIndexMap.put(n2, n);
        }
        this.linkNodes = new int[linkArray.length][];
        this.total = 0;
        this.counts = new int[this.nodes.length];
        for (n = 0; n < this.links.length; ++n) {
            Link link = this.links[n];
            if (this.rowToIndexMap.get(Math.abs(link.getFrom().getRow())) == null || this.rowToIndexMap.get(Math.abs(link.getTo().getRow())) == null) continue;
            this.linkNodes[n] = new int[]{this.rowToIndexMap.get(Math.abs(link.getFrom().getRow())), this.rowToIndexMap.get(Math.abs(link.getTo().getRow()))};
        }
        this.calculateCounts();
    }

    void calculateCounts() {
        int n;
        this.total = 0;
        for (n = 0; n < this.counts.length; ++n) {
            this.counts[n] = 0;
        }
        for (n = 1; n < this.links.length; ++n) {
            for (int i = 0; i < n; ++i) {
                if (!this.links[n].intersects(this.links[i])) continue;
                ++this.total;
                this.counts[this.linkNodes[n][0]] = this.counts[this.linkNodes[n][0]] + 1;
                this.counts[this.linkNodes[n][1]] = this.counts[this.linkNodes[n][1]] + 1;
                this.counts[this.linkNodes[i][0]] = this.counts[this.linkNodes[i][0]] + 1;
                this.counts[this.linkNodes[i][1]] = this.counts[this.linkNodes[i][1]] + 1;
            }
        }
    }

    public boolean swap(int n, int n2, int n3) {
        if (this.counts[n] + this.counts[n2] <= n3) {
            return false;
        }
        Node node = this.nodes[n];
        Node node2 = this.nodes[n2];
        int n4 = this.countIntersectionsFor(node, node2, 1000000);
        node.swapWith(node2);
        int n5 = this.countIntersectionsFor(node, node2, n4 - n3);
        if (n4 - n5 > n3) {
            this.recalculateSwappedNodes(node, node2);
            return true;
        }
        node.swapWith(node2);
        return false;
    }

    private void recalculateSwappedNodes(Node node, Node node2) {
        List<Link> list = this.getListOfInvolvedLinks(node, node2);
        for (Link object : list) {
            if (object.getFrom() != node && object.getFrom() != node2) continue;
            int link = this.linksToIndexMap.get(object);
            this.counts[this.linkNodes[link][0]] = 0;
            this.counts[this.linkNodes[link][1]] = 0;
        }
        ArrayList arrayList = new ArrayList();
        for (Link link : list) {
            for (int i = 0; i < this.links.length; ++i) {
                Link link2 = this.links[i];
                if (link == link2 || Crossings.identityContains(arrayList, link2) || !link.intersects(link2)) continue;
                int n = this.linksToIndexMap.get(link);
                this.counts[this.linkNodes[n][0]] = this.counts[this.linkNodes[n][0]] + 1;
                this.counts[this.linkNodes[n][1]] = this.counts[this.linkNodes[n][1]] + 1;
            }
            arrayList.add(link);
        }
    }

    private List<Link> getListOfInvolvedLinks(Node node, Node node2) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        Link[] linkArray = node.getInLink();
        if (linkArray != null) {
            for (Link link : linkArray) {
                if (Crossings.identityContains(arrayList, link)) continue;
                arrayList.add(link);
            }
        }
        if ((linkArray = node.getOutLink()) != null) {
            for (Link link : linkArray) {
                if (Crossings.identityContains(arrayList, link)) continue;
                arrayList.add(link);
            }
        }
        if ((linkArray = node2.getInLink()) != null) {
            for (Link link : linkArray) {
                if (Crossings.identityContains(arrayList, link)) continue;
                arrayList.add(link);
            }
        }
        if ((linkArray = node2.getOutLink()) != null) {
            for (Link link : linkArray) {
                if (Crossings.identityContains(arrayList, link)) continue;
                arrayList.add(link);
            }
        }
        return arrayList;
    }

    private int countIntersectionsFor(Node node, Node node2, int n) {
        int n2 = 0;
        List<Link> list = this.getListOfInvolvedLinks(node, node2);
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : list) {
            for (int i = 0; i < this.links.length; ++i) {
                Link link2 = this.links[i];
                if (link == link2 || Crossings.identityContains(arrayList, link2) || !link.intersects(link2) || ++n2 < n) continue;
                return n;
            }
            arrayList.add(link);
        }
        return n2;
    }

    private static boolean identityContains(List<Link> list, Link link) {
        for (Link link2 : list) {
            if (link2 != link) continue;
            return true;
        }
        return false;
    }

    boolean swapNodes(Node node, Node node2) {
        return this.swap(this.rowToIndexMap.get(Math.abs(node.getRow())), this.rowToIndexMap.get(Math.abs(node2.getRow())), 0);
    }
}

