/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.extension.RAVEExtensionManager;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.AbstractGraphLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.AssignLayerFromSpec;
import com.ibm.vis.engine.internal.grammar.layout.graph.AttachmentPoint;
import com.ibm.vis.engine.internal.grammar.layout.graph.CycleRemovalAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAGCrossingReductionAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAGInLayerLinkHandling;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAGLayerAssignmentAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAGNodeInfoSameLayer;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAGNodePlacementAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.DefaultCycleRemovalAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.DefaultDAGCrossingReductionAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.DefaultDAGExtensions;
import com.ibm.vis.engine.internal.grammar.layout.graph.DefaultDAGNodeWrappingAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.Graph;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.LongestDistanceToTerminal;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.spec.internal.LayoutSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/graphLayoutsLayer")
public class DAG
extends AbstractGraphLayout {
    private static final int MAX_GAP_SIZE = 100;
    Node[][] layers;
    private int layerCount;
    private final CycleRemovalAlgorithm cycleRemovalAlgorithm;
    private DAGLayerAssignmentAlgorithm layerAssignmentAlgorithm;
    private final DAGCrossingReductionAlgorithm crossingReductionAlgorithm;
    private final DAGNodePlacementAlgorithm horizontalNodePlacementAlgorithm;
    private final DAGNodePlacementAlgorithm verticalNodePlacementAlgorithm;
    private boolean isAutosizing = false;

    public DAG(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
        String string;
        DefaultDAGExtensions.registerExtensions();
        LayoutSpec layoutSpec = layoutAdapter.getSpec();
        String string2 = layoutSpec.nodePlacement;
        this.horizontalNodePlacementAlgorithm = (DAGNodePlacementAlgorithm)RAVEExtensionManager.INSTANCE.newInstance(string2, layoutAdapter);
        String string3 = layoutSpec.layerPlacement;
        layoutAdapter.setCenteredLayerPlacement(string3.equals("centered"));
        this.verticalNodePlacementAlgorithm = (DAGNodePlacementAlgorithm)RAVEExtensionManager.INSTANCE.newInstance(string3, layoutAdapter);
        String string4 = string = layoutSpec.layer == null ? null : layoutSpec.layer.$ref;
        if (string == null) {
            this.layerAssignmentAlgorithm = new LongestDistanceToTerminal();
        } else {
            Range range;
            if (layoutAdapter.getSpec().layer != null && (range = layoutAdapter.getFieldRange(layoutAdapter.getSpec().layer.$ref)) != null && range.getMin() < 0.0) {
                throw new EngineException("layer field may not have negative values", ErrorCode.DATA_CONVERSION, layoutAdapter.getSpec().layer.$ref);
            }
            this.layerAssignmentAlgorithm = new AssignLayerFromSpec(layoutAdapter);
        }
        this.cycleRemovalAlgorithm = new DefaultCycleRemovalAlgorithm(layoutAdapter);
        this.crossingReductionAlgorithm = new DefaultDAGCrossingReductionAlgorithm(layoutAdapter);
    }

    @Override
    protected boolean directedAlgorithm() {
        return true;
    }

    @Override
    public boolean respectsTransforms() {
        return false;
    }

    @Override
    protected void layoutNodes(Dim dim) {
        this.prepareLayer();
        Graph graph = new Graph(this.nodes, this.links);
        this.crossingReductionAlgorithm.layout(graph, this.layers);
        List<Object> list = DAGInLayerLinkHandling.insertDummyNodesForLinksInLayers(this.adapter, this.layers, this.nodes, this.links);
        this.nodes = (Node[])list.get(0);
        this.links = (Link[])list.get(1);
        this.layers = this.computeLayerArrays();
    }

    @Override
    protected void setupNodeLayering(Dim dim) {
        this.prepareLayer();
        Graph graph = new Graph(this.nodes, this.links);
        this.crossingReductionAlgorithm.setupLayers(graph, this.layers);
        List<Object> list = DAGInLayerLinkHandling.insertDummyNodesForLinksInLayers(this.adapter, this.layers, this.nodes, this.links);
        this.nodes = (Node[])list.get(0);
        this.links = (Link[])list.get(1);
        this.layers = this.computeLayerArrays();
    }

    private void prepareLayer() {
        Graph graph = new Graph(this.nodes, this.links);
        this.setLinkTargeting();
        this.cycleRemovalAlgorithm.removeCycles(graph);
        this.layerCount = this.layerAssignmentAlgorithm.assignLayers(graph);
        if (this.nodeWrappingRequired()) {
            this.layerCount = new DefaultDAGNodeWrappingAlgorithm(this.adapter).assignRows(graph);
        }
        this.nodes = graph.nodes;
        this.links = graph.links;
        this.insertDummyNodes();
        this.layers = this.computeLayerArrays();
    }

    @Override
    protected boolean isNodeLayerDefined() {
        return this.layerAssignmentAlgorithm instanceof AssignLayerFromSpec;
    }

    private void setLinkTargeting() {
        AttachmentPoint attachmentPoint = new AttachmentPoint(this.adapter, this.adapter.getSpec().attachmentPoint);
        if (!attachmentPoint.isInPointNamed() && !attachmentPoint.isOutPointNamed()) {
            return;
        }
        for (Link link : this.links) {
            int n = link.getRow();
            if (n < 0) continue;
            if (attachmentPoint.isOutPointNamed()) {
                link.setFromPart(attachmentPoint.getOutName(n));
            }
            if (!attachmentPoint.isInPointNamed()) continue;
            link.setToPart(attachmentPoint.getInName(n));
        }
    }

    @Override
    public void prepareForNewRows(int n) {
        super.prepareForNewRows(n);
        this.getPreferredSize(n);
    }

    @Override
    public Dim getPreferredSize(int n) {
        this.isAutosizing = true;
        try {
            if (this.getPrefSize() != null) {
                Dim dim = this.getPrefSize();
                return dim;
            }
            this.setupLayersForSizing(n, new Dim(5000.0, 5000.0));
            this.setPrefSize(this.getPreferredSizeOfDAG());
            Dim dim = this.getPrefSize();
            return dim;
        }
        finally {
            this.isAutosizing = false;
        }
    }

    private Dim getPreferredSizeOfDAG() {
        if (this.layers == null) {
            return new Dim(400.0, 400.0);
        }
        Dim dim = this.getNodesGap();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (Node[] nodeArray : this.layers) {
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = this.getLayerGap(nodeArray, dim.getHeight());
            for (Node node : nodeArray) {
                if (this.getAdapter().isSwapXY()) {
                    d4 += node.getCurrentBounds().getHeight() + dim.getHeight();
                    d5 = Math.max(d5, node.getCurrentBounds().getWidth());
                    continue;
                }
                d4 += node.getCurrentBounds().getWidth() + dim.getWidth();
                d5 = Math.max(d5, node.getCurrentBounds().getHeight());
            }
            if (d == 0.0 && d5 != 0.0) {
                d = d5;
            } else if (d5 == 0.0) {
                d5 = d;
            }
            d2 = Math.max(d2, d4);
            d3 += d5 + d6;
        }
        d2 = Math.max(400.0, d2);
        d3 = this.layers.length == 1 ? Math.max(400.0, d3 + dim.getHeight() / 4.0) : Math.max(400.0, d3 + dim.getHeight() / 2.0);
        if (this.getAdapter().isSwapXY()) {
            return this.getExpandedBounds(new Dim(d3, d2));
        }
        return this.getExpandedBounds(new Dim(d2, d3));
    }

    private Dim getNodesGap() {
        StyleSpec styleSpec = this.adapter.getLinkStyle();
        double d = DAG.getStrokeWidthFromStyle(styleSpec);
        double d2 = 10.0 + 2.0 * d * 4.2;
        Dim dim = new Dim(d2, d2);
        for (Node node : this.nodes) {
            dim.setWidth(Math.max(dim.getWidth(), node.getCurrentBounds().getWidth() / 2.0));
            dim.setHeight(Math.max(dim.getHeight(), node.getCurrentBounds().getHeight() / 2.0));
        }
        if (this.adapter.isSwapXY()) {
            dim = new Dim(dim.getHeight(), dim.getWidth());
        }
        dim.setWidth(Math.min(dim.getWidth(), 100.0));
        dim.setHeight(Math.min(dim.getHeight(), 100.0));
        return dim;
    }

    private double getLayerGap(Node[] nodeArray, double d) {
        double d2 = DAG.getMaxLevel(nodeArray);
        double d3 = d;
        if (d2 > 0.0) {
            StyleSpec styleSpec = this.adapter.getLinkStyle();
            double d4 = DAG.getStrokeWidthFromStyle(styleSpec);
            double d5 = Math.max(8.0, d4 * 4.2);
            d3 += 2.0 * (d2 * d4 * 2.0 + d5);
        }
        return d3;
    }

    public static double getStrokeWidthFromStyle(StyleSpec styleSpec) {
        double d = 1.0;
        if (styleSpec != null && styleSpec.stroke != null) {
            if (BasicFactory.isNumber(styleSpec.stroke.width)) {
                d = ((Number)styleSpec.stroke.width).doubleValue();
            } else if (BasicFactory.isString(styleSpec.stroke.width)) {
                double d2 = 1.0;
                d = UnitConverter.convertLength(styleSpec.stroke.width, d2, 400.0);
            }
        }
        return d;
    }

    private Dim getExpandedBounds(Dim dim) {
        if (this.getAdapter().getSpec().padding == null) {
            return dim;
        }
        Insets insets = Insets.makeForStylePadding(this.getAdapter().getSpec().padding, dim, dim);
        return new Dim(dim.getWidth() + insets.getHorizontal(), dim.getHeight() + insets.getVertical());
    }

    private boolean nodeWrappingRequired() {
        return this.adapter.getSpec().swimLanes != null && this.adapter.getSpec().swimLanes.id != null && this.adapter.getSpec().swimLanes.maxRowValue != null;
    }

    @Override
    protected void placeInExtent(Dim dim) {
        Dim dim2 = dim;
        if (this.adapter.isSwapXY()) {
            dim2 = new Dim(dim.getHeight(), dim.getWidth());
        }
        this.horizontalNodePlacementAlgorithm.layoutNodes(this.layers, dim2);
        DAGInLayerLinkHandling.assignLevelToDummyNodesInSameLayer(this.layers, this.links);
        for (Node node : this.nodes) {
            Object object;
            if (!node.isDummy() || (object = (DAGNodeInfoSameLayer)node.getInfo()) == null) continue;
            ((DAGNodeInfoSameLayer)object).setLevel(((DAGNodeInfoSameLayer)object).getLevel() / 2);
        }
        this.verticalNodePlacementAlgorithm.layoutNodes(this.layers, dim2);
        if (this.adapter.isReflectY()) {
            for (Node node : this.layers) {
                for (Object object : node) {
                    ((Node)object).setY(1.0 - ((Node)object).getY());
                }
            }
        }
        if (this.adapter.isSwapXY()) {
            for (Node node : this.layers) {
                for (Object object : node) {
                    double d = ((Node)object).getX();
                    ((Node)object).setX(((Node)object).getY());
                    ((Node)object).setY(d);
                }
            }
        }
        this.removeDummyNodes(dim);
    }

    private void insertDummyNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.nodes) {
            arrayList.add(node);
        }
        ArrayList arrayList2 = new ArrayList();
        for (Link link : this.links) {
            if (link.getSpan() > 1) {
                this.divideLink(arrayList, arrayList2, link);
                continue;
            }
            arrayList2.add(link);
        }
        this.nodes = arrayList.toArray(new Node[arrayList.size()]);
        this.links = arrayList2.toArray(new Link[arrayList2.size()]);
    }

    private void divideLink(List<Node> list, List<Link> list2, Link link) {
        Node node = this.makeFirstLink(list, list2, link);
        if (link.getFrom().getLayer() > link.getTo().getLayer()) {
            for (int i = link.getFrom().getLayer() - 2; i >= link.getTo().getLayer() + 1; --i) {
                node = this.makeInteriorLink(list, list2, link, node, i);
            }
        } else {
            for (int i = link.getFrom().getLayer() + 2; i <= link.getTo().getLayer() - 1; ++i) {
                node = this.makeInteriorLink(list, list2, link, node, i);
            }
        }
        this.makeFinalLink(list2, link, node);
    }

    private Node makeFirstLink(List<Node> list, List<Link> list2, Link link) {
        Node node = new Node(-list.size());
        node.setOrientation(this.adapter.isSwapXY(), this.adapter.isReflectY());
        if (link.getFrom().getLayer() > link.getTo().getLayer()) {
            node.setLayer(link.getFrom().getLayer() - 1);
        } else {
            node.setLayer(link.getFrom().getLayer() + 1);
        }
        list.add(node);
        Link link2 = new Link(link.getFrom(), node);
        link2.setFromPart(link.getFromPart());
        link2.setReversed(link.isReversed());
        link2.setLinkPruned(link.isLinkPruned());
        list2.add(link2);
        link.getFrom().replaceOutlink(link, link2);
        node.inLink = new Link[]{link2};
        return node;
    }

    private Node makeInteriorLink(List<Node> list, List<Link> list2, Link link, Node node, int n) {
        Node node2 = new Node(-list.size());
        node2.setOrientation(this.adapter.isSwapXY(), this.adapter.isReflectY());
        node2.setLayer(n);
        list.add(node2);
        Link link2 = new Link(node, node2);
        link2.setReversed(link.isReversed());
        link2.setLinkPruned(link.isLinkPruned());
        list2.add(link2);
        node.setOutLink(new Link[]{link2});
        node2.setInLink(new Link[]{link2});
        return node2;
    }

    private void makeFinalLink(List<Link> list, Link link, Node node) {
        Link link2 = new Link(node, link.getTo());
        link2.setToPart(link.getToPart());
        link2.setReversed(link.isReversed());
        link2.setLinkPruned(link.isLinkPruned());
        list.add(link2);
        node.setOutLink(new Link[]{link2});
        link.getTo().replaceInlink(link, link2);
    }

    private void removeDummyNodes(Dim dim) {
        boolean bl;
        Dim dim2 = this.adapter.getElementSize();
        Dim dim3 = new Dim(dim2.getWidth() / dim.getWidth() / 2.0, dim2.getHeight() / dim.getHeight() / 2.0);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        for (Node object : this.nodes) {
            boolean bl2 = bl = !this.isAutosizing && object.isNodePruned();
            if (object == null || object.isDummy() || bl) continue;
            arrayList2.add(object);
        }
        for (Link link : this.links) {
            if (link.isLinkPruned()) continue;
            boolean bl3 = bl = link.getFrom().getLayer() == link.getTo().getLayer();
            if (!link.getFrom().isDummy() && link.getTo().isDummy()) {
                ArrayList<Point> arrayList3 = new ArrayList<Point>();
                Link link2 = link;
                while (link2.getTo().isDummy()) {
                    Object object;
                    Point point = null;
                    Point point2 = null;
                    if (bl) {
                        object = (DAGNodeInfoSameLayer)link2.getTo().getInfo();
                        point = new Point(Double.NaN, ((DAGNodeInfoSameLayer)object).getLevel());
                    } else if (this.adapter.isSwapXY()) {
                        if (this.adapter.isReflectY()) {
                            point = new Point(link2.getTo().getX() - dim3.getWidth(), link2.getTo().getY());
                            point2 = new Point(link2.getTo().getX() + dim3.getWidth(), link2.getTo().getY());
                        } else {
                            point = new Point(link2.getTo().getX() + dim3.getWidth(), link2.getTo().getY());
                            point2 = new Point(link2.getTo().getX() - dim3.getWidth(), link2.getTo().getY());
                        }
                    } else if (this.adapter.isReflectY()) {
                        point = new Point(link2.getTo().getX(), link2.getTo().getY() - dim3.getHeight());
                        point2 = new Point(link2.getTo().getX(), link2.getTo().getY() + dim3.getHeight());
                    } else {
                        point = new Point(link2.getTo().getX(), link2.getTo().getY() + dim3.getHeight());
                        point2 = new Point(link2.getTo().getX(), link2.getTo().getY() - dim3.getHeight());
                    }
                    arrayList3.add(point);
                    if (point2 != null) {
                        arrayList3.add(point2);
                    }
                    link2 = link2.getTo().getOutLink()[0];
                    object = link.getFrom();
                    Node node = link2.getTo();
                    Link link3 = new Link((Node)object, node);
                    if (link.isReversed()) {
                        this.adapter.getSharedLayoutInfo().addRoutingInfo(node.getRow(), ((Node)object).getRow(), this.reverse(arrayList3), null);
                    } else {
                        this.adapter.getSharedLayoutInfo().addRoutingInfo(((Node)object).getRow(), node.getRow(), arrayList3, null);
                    }
                    ((Node)object).replaceOutlink(link, link3);
                    node.replaceInlink(link2, link3);
                    if (((Node)object).isNodePruned() || node.isNodePruned()) continue;
                    arrayList.add(link3);
                }
                continue;
            }
            if (link.getFrom().isDummy() || link.getTo().isDummy()) continue;
            arrayList.add(link);
        }
        this.nodes = arrayList2.toArray(new Node[arrayList2.size()]);
        this.links = arrayList.toArray(new Link[arrayList.size()]);
        this.layers = this.computeLayerArrays();
    }

    private List<Point> reverse(List<Point> list) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (Point point : list) {
            arrayList.add(0, point);
        }
        return arrayList;
    }

    private Node[][] computeLayerArrays() {
        Node[][] nodeArray = new Node[this.layerCount][];
        for (int i = 0; i < this.layerCount; ++i) {
            int n = 0;
            for (Node node : this.nodes) {
                if (node == null || node.getLayer() != i) continue;
                ++n;
            }
            nodeArray[i] = new Node[n];
            n = 0;
            for (Node node : this.nodes) {
                if (node == null || node.getLayer() != i) continue;
                nodeArray[i][n++] = node;
            }
        }
        return nodeArray;
    }

    int getLayerCount() {
        return this.layerCount;
    }

    public static int getMaxLevel(Node[] nodeArray) {
        int n = 0;
        for (Node node : nodeArray) {
            if (node.outLink == null) continue;
            for (Link link : node.outLink) {
                if (link.getTo().getLayer() != link.getFrom().getLayer() || !link.getTo().isDummy()) continue;
                DAGNodeInfoSameLayer dAGNodeInfoSameLayer = (DAGNodeInfoSameLayer)link.getTo().getInfo();
                n = Math.max(n, dAGNodeInfoSameLayer.getLevel());
            }
        }
        return n;
    }
}

