/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAGNodeInfoSameLayer;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.LinkComparator;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.NodeComparator;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
final class DAGInLayerLinkHandling {
    public static final double DUMMY_NODES_X_OFFSET_FACTOR = 0.1;

    DAGInLayerLinkHandling() {
    }

    public static List<Object> insertDummyNodesForLinksInLayers(LayoutAdapter layoutAdapter, Node[][] nodeArray, Node[] nodeArray2, Link[] linkArray) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : nodeArray2) {
            arrayList.add(node);
        }
        Object[] objectArray = new List[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            objectArray[i] = new ArrayList();
        }
        ArrayList<Link> arrayList2 = new ArrayList<Link>();
        for (Link link : linkArray) {
            if (link.getSpan() == 0) {
                int n;
                objectArray[link.getFrom().getLayer()].add(link);
                Node[] nodeArray3 = nodeArray[link.getFrom().getLayer()];
                double d = link.getFrom().getX();
                double d2 = link.getTo().getX();
                boolean bl = true;
                for (n = 0; n < nodeArray3.length; ++n) {
                    Node node = nodeArray3[n];
                    if (!(node.getX() > d && node.getX() < d2) && (!(node.getX() < d) || !(node.getX() > d2))) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    n = 1;
                    if (n != 0) {
                        arrayList2.add(link);
                        continue;
                    }
                    DAGInLayerLinkHandling.divideLinkSameLayer(layoutAdapter, arrayList, arrayList2, link);
                    continue;
                }
                DAGInLayerLinkHandling.divideLinkSameLayer(layoutAdapter, arrayList, arrayList2, link);
                continue;
            }
            arrayList2.add(link);
        }
        ArrayList arrayList3 = new ArrayList();
        arrayList3.add(arrayList.toArray(new Node[arrayList.size()]));
        BasicFactory.sortList(arrayList2, new LinkComparator());
        arrayList3.add(arrayList2.toArray(new Link[arrayList2.size()]));
        return arrayList3;
    }

    private static void divideLinkSameLayer(LayoutAdapter layoutAdapter, List<Node> list, List<Link> list2, Link link) {
        Node node = DAGInLayerLinkHandling.makeFirstLinkSameLayer(layoutAdapter, list, list2, link);
        node = DAGInLayerLinkHandling.makeInteriorLinkSameLayer(layoutAdapter, list, list2, link, node, node.getLayer());
        DAGInLayerLinkHandling.makeFinalLink(list2, link, node);
    }

    private static void makeFinalLink(List<Link> list, Link link, Node node) {
        Link link2 = new Link(node, link.getTo());
        link2.setReversed(link.isReversed());
        list.add(link2);
        node.setOutLink(new Link[]{link2});
        link.getTo().replaceInlink(link, link2);
    }

    private static Node makeFirstLinkSameLayer(LayoutAdapter layoutAdapter, List<Node> list, List<Link> list2, Link link) {
        Node node = new Node(-list.size());
        node.setOrientation(layoutAdapter.isSwapXY(), layoutAdapter.isReflectY());
        node.setLayer(link.getFrom().getLayer());
        DAGNodeInfoSameLayer dAGNodeInfoSameLayer = new DAGNodeInfoSameLayer();
        dAGNodeInfoSameLayer.setOrigFrom(link.getFrom());
        dAGNodeInfoSameLayer.setOrigTo(link.getTo());
        dAGNodeInfoSameLayer.setBelongsTo(link.getFrom());
        node.setInfo(dAGNodeInfoSameLayer);
        node.setX(link.getFrom().getX() + (link.getTo().getX() - link.getFrom().getX()) * 0.1);
        list.add(node);
        Link link2 = new Link(link.getFrom(), node);
        link2.setReversed(link.isReversed());
        list2.add(link2);
        link.getFrom().replaceOutlink(link, link2);
        node.inLink = new Link[]{link2};
        return node;
    }

    private static Node makeInteriorLinkSameLayer(LayoutAdapter layoutAdapter, List<Node> list, List<Link> list2, Link link, Node node, int n) {
        Node node2 = new Node(-list.size());
        node2.setOrientation(layoutAdapter.isSwapXY(), layoutAdapter.isReflectY());
        node2.setLayer(n);
        DAGNodeInfoSameLayer dAGNodeInfoSameLayer = new DAGNodeInfoSameLayer();
        dAGNodeInfoSameLayer.setOrigFrom(link.getFrom());
        dAGNodeInfoSameLayer.setOrigTo(link.getTo());
        dAGNodeInfoSameLayer.setBelongsTo(link.getTo());
        node2.setInfo(dAGNodeInfoSameLayer);
        node2.setX(link.getFrom().getX() + (link.getTo().getX() - link.getFrom().getX()) * 0.9);
        list.add(node2);
        Link link2 = new Link(node, node2);
        link2.setReversed(link.isReversed());
        list2.add(link2);
        node.outLink = new Link[]{link2};
        node2.inLink = new Link[]{link2};
        return node2;
    }

    private static void handleLayer(List<Link> list, List<Node> list2) {
        BasicFactory.sortList(list, new LinkComparator());
        BasicFactory.sortList(list2, new NodeComparator());
        HashMap hashMap = new HashMap();
        for (Link link : list) {
            Node node = link.getFrom();
            DAGNodeInfoSameLayer dAGNodeInfoSameLayer = (DAGNodeInfoSameLayer)node.getInfo();
            Node node2 = link.getTo();
            DAGNodeInfoSameLayer dAGNodeInfoSameLayer2 = (DAGNodeInfoSameLayer)node2.getInfo();
            int n = Math.max(dAGNodeInfoSameLayer.getLevel(), dAGNodeInfoSameLayer2.getLevel());
            List<Node> list3 = DAGInLayerLinkHandling.getInnerNodes(link, list2);
            for (Node node3 : list3) {
                DAGNodeInfoSameLayer dAGNodeInfoSameLayer3 = (DAGNodeInfoSameLayer)node3.getInfo();
                n = Math.max(dAGNodeInfoSameLayer3.getLevel(), n);
            }
            ++n;
            List<Node> list4 = (List)hashMap.get(node2);
            if (list4 == null) {
                list4 = new ArrayList<Node>();
                list4.add(node);
                hashMap.put(node2, list4);
            }
            if (list4.contains(node)) {
                ++n;
            }
            list4.add(node);
            dAGNodeInfoSameLayer.setLevel(n);
            dAGNodeInfoSameLayer2.setLevel(n);
        }
    }

    public static void assignLevelToDummyNodesInSameLayer(Node[][] nodeArray, Link[] linkArray) {
        List[] listArray = new List[nodeArray.length];
        List[] listArray2 = new List[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            listArray[i] = new ArrayList();
            listArray2[i] = new ArrayList();
        }
        for (Link link : linkArray) {
            Node node = link.getFrom();
            int n = node.getLayer();
            Node node2 = link.getTo();
            int n2 = node2.getLayer();
            if (!node.isDummy() || !node2.isDummy() || n != n2) continue;
            listArray[n].add(link);
            if (!listArray2[n].contains(node)) {
                listArray2[n].add(node);
            }
            if (listArray2[n2].contains(node2)) continue;
            listArray2[n2].add(node2);
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            DAGInLayerLinkHandling.handleLayer(listArray[i], listArray2[i]);
        }
    }

    private static List<Node> getInnerNodes(Link link, List<Node> list) {
        Node node = link.getFrom();
        Node node2 = link.getTo();
        if (node.getX() > node2.getX()) {
            Node node3 = node;
            node = node2;
            node2 = node3;
        }
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i).getX() >= node.getX())) continue;
            if (n == -1) {
                n = i - 1;
                continue;
            }
            if (!(list.get(i).getX() >= node2.getX()) && i != list.size()) continue;
            n2 = i;
        }
        if (n > -1 && n2 > -1 && Math.abs(n2 - n) > 0) {
            return DAGInLayerLinkHandling.subList(list, n, n2);
        }
        return new ArrayList<Node>();
    }

    private static List<Node> subList(List<Node> list, int n, int n2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = n; i <= n2; ++i) {
            arrayList.add(list.get(i));
        }
        return arrayList;
    }
}

