/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.CycleRemovalAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.Graph;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import java.util.ArrayList;
import java.util.Iterator;

class DefaultCycleRemovalAlgorithm
implements CycleRemovalAlgorithm {
    private static final Integer DISCOVERED = 1;
    private static final Integer EXPLORED = 2;
    private final LayoutAdapter adapter;

    public DefaultCycleRemovalAlgorithm(LayoutAdapter layoutAdapter) {
        this.adapter = layoutAdapter;
    }

    @Override
    public void removeCycles(Graph graph) {
        for (Node node : graph.nodes) {
            boolean bl = false;
            while (!bl) {
                ArrayList<Node> arrayList = this.findCycle(graph, node);
                if (arrayList == null) {
                    node.setInfo(EXPLORED);
                    bl = true;
                    continue;
                }
                bl = false;
                this.adapter.logInfo("Graph layout needed to break a cycle", "cycle size", arrayList.size());
                this.breakCycle(arrayList);
            }
        }
    }

    private void breakCycle(ArrayList<Node> arrayList) {
        int n = 0;
        double d = this.scoreNodeInCycle(0, arrayList);
        for (int i = 1; i < arrayList.size() - 1; ++i) {
            double d2 = this.scoreNodeInCycle(i, arrayList);
            if (!(d < d2)) continue;
            n = i;
            d = d2;
        }
        Node node = arrayList.get(n);
        Node node2 = arrayList.get(n + 1);
        for (Link link : node.getOutLink()) {
            if (link.getTo() != node2) continue;
            link.reverse();
            return;
        }
    }

    private double scoreNodeInCycle(int n, ArrayList<Node> arrayList) {
        Node node = arrayList.get(n + 1);
        Node node2 = arrayList.get(n);
        if (node2.getRow() < node.getRow()) {
            return Double.NEGATIVE_INFINITY;
        }
        int n2 = 0;
        for (Link link : node.getOutLink()) {
            int n3 = arrayList.indexOf(link.getTo());
            if (n3 >= n || n3 < 0) continue;
            ++n2;
        }
        return (double)(node2.getRow() - node.getRow()) * 1.0E-6 - (double)n2;
    }

    private ArrayList<Node> findCycle(Graph graph, Node node) {
        for (Node object : graph.nodes) {
            if (object.getInfo() == EXPLORED) continue;
            object.setInfo(null);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(node);
        if (this.searchForwardForCycle(node, arrayList)) {
            Node node2 = (Node)arrayList.get(arrayList.size() - 1);
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i) != node2) continue;
                ArrayList<Node> arrayList2 = new ArrayList<Node>();
                int n = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Node node3 = (Node)iterator.next();
                    if (n++ <= i) continue;
                    arrayList2.add(node3);
                }
                return arrayList2;
            }
        }
        node.setInfo(EXPLORED);
        return null;
    }

    private boolean searchForwardForCycle(Node node, ArrayList<Node> arrayList) {
        node.setInfo(DISCOVERED);
        for (Link link : node.getOutLink()) {
            Node node2 = link.getTo();
            arrayList.add(node2);
            if (node2.getInfo() == DISCOVERED) {
                return true;
            }
            if (node2.getInfo() == null && this.searchForwardForCycle(node2, arrayList)) {
                return true;
            }
            arrayList.remove(arrayList.get(arrayList.size() - 1));
        }
        node.setInfo(EXPLORED);
        return false;
    }
}

