/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.Crossings;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAGCrossingReductionAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.Graph;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class DefaultDAGCrossingReductionAlgorithm
implements DAGCrossingReductionAlgorithm {
    private static final double BIAS_FACTOR = 1.0E-6;
    private final LayoutAdapter adapter;
    private Crossings crossings;

    public DefaultDAGCrossingReductionAlgorithm(LayoutAdapter layoutAdapter) {
        this.adapter = layoutAdapter;
    }

    @Override
    public void layout(Graph graph, Node[][] nodeArray) {
        this.setupLayers(graph, nodeArray);
        this.crossings = new Crossings(graph.nodes, graph.links);
        this.doWithinLayerSwaps(graph, nodeArray);
        this.doReflectionInX(graph);
        if (this.adapter.hasListeners()) {
            this.crossings.calculateCounts();
            this.adapter.logDetail("Finished DAG layout", "crossings", this.crossings.total);
        }
    }

    @Override
    public void setupLayers(Graph graph, Node[][] nodeArray) {
        this.assignCoordinates(graph, nodeArray);
        this.foldScale(graph, nodeArray);
        if (nodeArray.length == 1) {
            this.distributeLayer(nodeArray[0]);
        } else {
            for (int i = 0; i < 3; ++i) {
                this.alignDaughters(graph, nodeArray);
                this.alignParents(graph, nodeArray);
            }
            if (DefaultDAGCrossingReductionAlgorithm.isTree(graph)) {
                this.alignDaughters(graph, nodeArray);
            }
        }
    }

    static boolean isTree(Graph graph) {
        for (Node node : graph.nodes) {
            if (node.getInLink().length <= 1) continue;
            return false;
        }
        return true;
    }

    private void doWithinLayerSwaps(Graph graph, Node[][] nodeArray) {
        this.crossings.calculateCounts();
        if (this.crossings.total > 0) {
            int n = 0;
            for (Node[] nodeArray2 : nodeArray) {
                for (int i = 0; i < nodeArray2.length - 1; ++i) {
                    Node node = nodeArray2[i];
                    for (int j = i + 1; j < nodeArray2.length; ++j) {
                        Node node2 = nodeArray2[j];
                        if ((!node.isOrdered() || !node2.isOrdered() || node.getOrder() != node2.getOrder()) && (node.isOrdered() || node2.isOrdered()) || !this.crossings.swapNodes(node, node2)) continue;
                        ++n;
                    }
                }
            }
        }
    }

    private void doReflectionInX(Graph graph) {
        this.crossings.calculateCounts();
        int n = this.crossings.total;
        for (Node node : graph.nodes) {
            node.setX(-node.getX());
        }
        this.crossings.calculateCounts();
        if (this.crossings.total < n) {
            return;
        }
        for (Node node : graph.nodes) {
            node.setX(-node.getX());
        }
    }

    private void alignDaughters(Graph graph, Node[][] nodeArray) {
        int n = nodeArray.length;
        for (int i = n - 2; i >= 0; --i) {
            Node[] nodeArray2;
            for (Node node : nodeArray2 = nodeArray[i]) {
                if (node.inLink.length <= 0) continue;
                double d = 0.0;
                for (Link link : node.inLink) {
                    d += link.getFrom().getPartXY(link.getFromPart()).getX();
                }
                node.setX((d / (double)node.inLink.length + 1.0E-6 * node.getX()) / 1.000001);
            }
            this.distributeLayer(nodeArray2);
        }
    }

    private void alignParents(Graph graph, Node[][] nodeArray) {
        int n = nodeArray.length;
        for (int i = 1; i < n; ++i) {
            Node[] nodeArray2;
            for (Node node : nodeArray2 = nodeArray[i]) {
                if (node.getOutLink().length <= 0) continue;
                double d = 0.0;
                for (Link link : node.getOutLink()) {
                    d += link.getTo().getPartXY(link.getToPart()).getX();
                }
                node.setX((d / (double)node.getOutLink().length + 1.0E-6 * node.getX()) / 1.000001);
            }
            this.distributeLayer(nodeArray2);
        }
    }

    private void assignCoordinates(Graph graph, Node[][] nodeArray) {
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            Node[] nodeArray2 = nodeArray[i];
            for (int j = 0; j < nodeArray2.length; ++j) {
                Node node = nodeArray2[j];
                double d = node.degree();
                for (Link link : node.inLink) {
                    d += 0.1 * (double)link.getFrom().degree();
                }
                for (Link link : node.getOutLink()) {
                    d += 0.1 * (double)link.getTo().degree();
                }
                d = (double)j < (double)nodeArray2.length / 2.0 ? (d += 1.0E-8 * (double)j) : (d += 1.0E-8 * (1.0 + (double)nodeArray2.length / 2.0 - (double)j));
                node.setX(d);
                node.setY(i);
            }
        }
    }

    private void foldScale(Graph graph, Node[][] nodeArray) {
        int n = nodeArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Node[] nodeArray2 = nodeArray[i];
            n2 = Math.max(n2, nodeArray2.length);
        }
        double d = 0.5 * (double)(n2 - 1);
        for (int i = 0; i < n; ++i) {
            double d2 = 0.01 * Math.sqrt(i);
            Node[] nodeArray3 = nodeArray[i];
            int n3 = nodeArray3.length;
            int[] nArray = this.getLayerOrder(nodeArray3);
            int n4 = 0;
            int n5 = n3 - 1;
            for (int j = 0; j < n3; j += 2) {
                Node node;
                Link link;
                Node node2;
                Node node3 = node2 = nodeArray3[nArray[j]];
                if (j < n3 - 1) {
                    node3 = nodeArray3[nArray[j + 1]];
                }
                if (node2.getOutLink().length > 0) {
                    link = node2.getOutLink()[0];
                    if (link.getTo().getX() > d) {
                        node = node2;
                        node2 = node3;
                        node3 = node;
                    }
                } else if (node3.getOutLink().length > 0 && (link = node3.getOutLink()[0]).getTo().getX() < d) {
                    node = node2;
                    node2 = node3;
                    node3 = node;
                }
                node2.setX((double)n4 - d2);
                if (j < n3 - 1) {
                    node3.setX((double)n5 + d2);
                }
                ++n4;
                --n5;
            }
        }
    }

    private void distributeLayer(Node[] nodeArray) {
        int[] nArray = this.getLayerOrder(nodeArray);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            nodeArray[n].setX((double)i - (double)nArray.length / 2.0);
        }
    }

    private int[] getLayerOrder(Node[] nodeArray) {
        double[] dArray;
        block6: {
            int n;
            dArray = new double[nodeArray.length];
            Range range = Range.EMPTY;
            for (n = 0; n < nodeArray.length; ++n) {
                if (nodeArray[n].isOrdered()) {
                    dArray[n] = nodeArray[n].getOrder().doubleValue();
                    range = range.unionValue(dArray[n]);
                    continue;
                }
                dArray[n] = nodeArray[n].getX();
            }
            if (range.isEmpty()) break block6;
            if (range.getRange() == 0.0) {
                for (n = 0; n < nodeArray.length; ++n) {
                    if (!nodeArray[n].isOrdered()) continue;
                    dArray[n] = 0.0;
                }
            } else {
                for (n = 0; n < nodeArray.length; ++n) {
                    if (!nodeArray[n].isOrdered()) continue;
                    dArray[n] = range.toZeroOne(dArray[n]);
                }
            }
        }
        return BasicFactory.makeSortOrder(dArray);
    }
}

