/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAGNodeWrappingAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.Graph;
import com.ibm.vis.engine.internal.grammar.layout.graph.Layer;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DefaultDAGNodeWrappingAlgorithm
implements DAGNodeWrappingAlgorithm {
    private final LayoutAdapter adapter;

    public DefaultDAGNodeWrappingAlgorithm(LayoutAdapter layoutAdapter) {
        this.adapter = layoutAdapter;
    }

    @Override
    public int assignRows(Graph graph) {
        Layer[] layerArray = this.extractLayers(graph);
        return this.wrapNodes(graph, layerArray);
    }

    private Layer[] extractLayers(Graph graph) {
        String string = this.adapter.getSpec().swimLanes.id == null ? null : this.adapter.getSpec().swimLanes.id.$ref;
        String string2 = this.adapter.getSpec().swimLanes.maxRowValue == null ? null : this.adapter.getSpec().swimLanes.maxRowValue.$ref;
        String string3 = this.adapter.getSpec().swimLanes.idealNodeCountValue == null ? null : this.adapter.getSpec().swimLanes.idealNodeCountValue.$ref;
        double[] dArray = this.adapter.getAllFieldValuesAsNumeric(string);
        double[] dArray2 = this.adapter.getAllFieldValuesAsNumeric(string2);
        double[] dArray3 = this.adapter.getAllFieldValuesAsNumeric(string3);
        HashMap hashMap = new HashMap();
        for (Node node : graph.nodes) {
            if (!hashMap.containsKey(node.getLayer())) {
                hashMap.put(node.getLayer(), new ArrayList());
            }
            ((ArrayList)hashMap.get(node.getLayer())).add(node);
        }
        Object[] objectArray = new Layer[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            Layer layer = new Layer((int)dArray[i]);
            if (!Double.isNaN(dArray2[i]) && dArray2[i] > 1.0) {
                layer.maxRowCount = (int)Math.floor(dArray2[i]);
            }
            if (!Double.isNaN(dArray3[i])) {
                layer.idealNodeCount = (int)Math.floor(dArray3[i]);
            }
            layer.nodeList = (List)hashMap.get(layer.id);
            objectArray[i] = layer;
        }
        return objectArray;
    }

    private int wrapNodes(Graph graph, Layer[] layerArray) {
        for (Layer layer : layerArray) {
            if (this.nodeWrappingRequired(layer)) {
                this.assignRowsToNodes(layer);
                continue;
            }
            if (layer.nodeList == null) continue;
            layer.rows = new Node[1][];
            layer.rows[0] = layer.nodeList.toArray(new Node[layer.nodeList.size()]);
        }
        List<Node> list = this.updateLayerOfNodes(layerArray);
        int n = this.getTotalLayerCount(layerArray);
        graph.nodes = list.toArray(new Node[list.size()]);
        graph.reverseLinksIfNeeded();
        return n;
    }

    private boolean nodeWrappingRequired(Layer layer) {
        return layer.nodeList != null && layer.nodeList.size() > 0 && layer.maxRowCount > 1.0 && layer.idealNodeCount < (double)layer.nodeList.size();
    }

    private int getTotalLayerCount(Layer[] layerArray) {
        int n = 0;
        for (Layer layer : layerArray) {
            if (layer.rows != null) {
                n += layer.rows.length;
                continue;
            }
            ++n;
        }
        return n;
    }

    private List<Node> updateLayerOfNodes(Layer[] layerArray) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        for (int i = layerArray.length - 1; i >= 0; --i) {
            Node[][] nodeArray = layerArray[i].rows;
            if (nodeArray == null) continue;
            for (int j = nodeArray.length - 1; j >= 0; --j) {
                for (Node node : nodeArray[j]) {
                    node.setLayer(node.getLayer() + n);
                    arrayList.add(node);
                }
                if (j == 0) continue;
                ++n;
            }
        }
        return arrayList;
    }

    private void assignRowsToNodes(Layer layer) {
        Node[][] nodeArray = this.getRowSkeleton(layer);
        Node[] nodeArray2 = this.arrangeNodesByLinkDirection(layer);
        layer.rows = this.fillNodesIntoRowSlots(nodeArray, nodeArray2);
    }

    private Node[][] fillNodesIntoRowSlots(Node[][] nodeArray, Node[] nodeArray2) {
        int n = 0;
        for (int i = 0; i < nodeArray.length; ++i) {
            for (int j = 0; j < nodeArray[i].length; ++j) {
                nodeArray[i][j] = nodeArray2[n++];
            }
        }
        return nodeArray;
    }

    private Node[] arrangeNodesByLinkDirection(Layer layer) {
        Node[] nodeArray = new Node[layer.nodeList.size()];
        double[] dArray = new double[layer.nodeList.size()];
        int n = 0;
        for (Node node : layer.nodeList) {
            if (node.getOrder() != null) {
                dArray[n++] = node.getOrder().doubleValue();
                continue;
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (Link link : node.inLink) {
                if (link.getFrom().getLayer() > node.getLayer()) {
                    ++n2;
                    continue;
                }
                if (link.getFrom().getLayer() >= node.getLayer()) continue;
                ++n3;
            }
            for (Link link : node.getOutLink()) {
                if (link.getTo().getLayer() > node.getLayer()) {
                    ++n2;
                    continue;
                }
                if (link.getTo().getLayer() >= node.getLayer()) continue;
                ++n3;
            }
            n4 = n3 - n2;
            dArray[n++] = n4;
        }
        Object object = BasicFactory.makeSortOrder(dArray);
        for (int i = 0; i < ((Object)object).length; ++i) {
            nodeArray[i] = layer.nodeList.get((int)object[i]);
        }
        return nodeArray;
    }

    private Node[][] getRowSkeleton(Layer layer) {
        Node[][] nodeArray;
        block3: {
            double d;
            block2: {
                double d2 = 0.0;
                d = 0.0;
                nodeArray = null;
                if (!((double)layer.nodeList.size() / layer.idealNodeCount > layer.maxRowCount)) break block2;
                d2 = (double)layer.nodeList.size() / layer.maxRowCount;
                d = layer.maxRowCount;
                int n = (int)((double)layer.nodeList.size() % d);
                nodeArray = new Node[(int)d][];
                int n2 = 0;
                while ((double)n2 < d) {
                    nodeArray[n2] = n2 < n ? new Node[(int)Math.ceil(d2)] : new Node[(int)Math.floor(d2)];
                    ++n2;
                }
                break block3;
            }
            if (!((double)layer.nodeList.size() / layer.idealNodeCount <= layer.maxRowCount)) break block3;
            d = Math.ceil((double)layer.nodeList.size() / layer.idealNodeCount);
            nodeArray = new Node[(int)d][];
            int n = 0;
            while ((double)n < d) {
                int n3 = (int)((double)layer.nodeList.size() - (double)n * layer.idealNodeCount);
                nodeArray[n] = new Node[(int)Math.min((double)n3, layer.idealNodeCount)];
                ++n;
            }
        }
        return nodeArray;
    }
}

