/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.extension.ExtensionFactory;
import com.ibm.vis.engine.internal.extension.RAVEExtensionManager;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.SwimlaneLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAG;
import com.ibm.vis.engine.internal.grammar.layout.graph.FishboneLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.GridGraphLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.ProcessFlowLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.TreeLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.StressLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.force.ForceLayout;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class DefaultGraphLayouts
implements ExtensionFactory {
    private static boolean registered = false;

    public static synchronized void registerExtensions() {
        if (!registered) {
            registered = true;
            RAVEExtensionManager.INSTANCE.registerDefaultFactory(new DefaultGraphLayouts());
        }
    }

    @Override
    public Object newInstance(String string, Object object) {
        if ("dag".equals(string)) {
            return new DAG((LayoutAdapter)object);
        }
        if ("grid".equals(string)) {
            return new GridGraphLayout((LayoutAdapter)object);
        }
        if ("network".equals(string)) {
            return new StressLayout((LayoutAdapter)object);
        }
        if ("tree".equals(string)) {
            return new TreeLayout((LayoutAdapter)object);
        }
        if ("swimlane".equals(string)) {
            return new SwimlaneLayout((LayoutAdapter)object);
        }
        if ("process".equals(string)) {
            return new ProcessFlowLayout((LayoutAdapter)object);
        }
        if ("fishbone".equals(string)) {
            return new FishboneLayout((LayoutAdapter)object);
        }
        if ("force".equals(string)) {
            return new ForceLayout((LayoutAdapter)object);
        }
        return null;
    }
}

