/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;

public final class Direction {
    private static final double EPSILON = 0.1;
    public static final Direction UNKNOWN = new Direction("?", -1, 0.0, 0.0);
    public static final Direction EAST = new Direction("E", 0, 1.0, 0.0);
    public static final Direction NORTH = new Direction("N", 1, 0.0, -1.0);
    public static final Direction SOUTH = new Direction("S", 2, 0.0, 1.0);
    public static final Direction WEST = new Direction("W", 3, -1.0, 0.0);
    public static final Direction NE = new Direction("NE", -1, 1.0, -1.0);
    public static final Direction NW = new Direction("NW", -1, -1.0, -1.0);
    public static final Direction SE = new Direction("SE", -1, 1.0, 1.0);
    public static final Direction SW = new Direction("SW", -1, -1.0, 1.0);
    public static final Direction[] ALL = new Direction[]{EAST, NORTH, SOUTH, WEST};
    private static final Direction[] right = new Direction[]{SOUTH, EAST, WEST, NORTH};
    private static final Direction[] left = new Direction[]{NORTH, WEST, EAST, SOUTH};
    private static final Direction[] reverse = new Direction[]{WEST, SOUTH, NORTH, EAST};
    private final String name;
    private final int index;
    private final double dx;
    private final double dy;

    private Direction(String string, int n, double d, double d2) {
        this.name = string;
        this.index = n;
        this.dx = d;
        this.dy = d2;
    }

    public final Direction getLeft() {
        return left[this.index];
    }

    public final Direction getRight() {
        return right[this.index];
    }

    public final Direction getReverse() {
        return reverse[this.index];
    }

    public final int getIndex() {
        return this.index;
    }

    public final String toString() {
        return this.name;
    }

    public final boolean isBasic() {
        return this.index >= 0 && this.index <= 3;
    }

    public Point offset(Point point, double d) {
        return new Point(point.getX() + this.dx * d, point.getY() + this.dy * d);
    }

    public Point boundaryPoint(Rect rect) {
        return new Point(rect.getCenterX() + rect.getWidth() * this.dx / 2.0, rect.getCenterY() + rect.getHeight() * this.dy / 2.0);
    }

    public static final Direction getDirectionForVector(double d, double d2) {
        if (d > 1.0) {
            if (d2 < -1.0) {
                return NE;
            }
            if (d2 > 1.0) {
                return SE;
            }
            return EAST;
        }
        if (d < -1.0) {
            if (d2 < -1.0) {
                return NW;
            }
            if (d2 > 1.0) {
                return SW;
            }
            return WEST;
        }
        return d2 < 0.0 ? NORTH : SOUTH;
    }

    public static final Direction fromNumber(Number number) {
        if (number == null) {
            return UNKNOWN;
        }
        if (number.doubleValue() == (double)Direction.EAST.index) {
            return EAST;
        }
        if (number.doubleValue() == (double)Direction.WEST.index) {
            return WEST;
        }
        if (number.doubleValue() == (double)Direction.NORTH.index) {
            return NORTH;
        }
        if (number.doubleValue() == (double)Direction.SOUTH.index) {
            return SOUTH;
        }
        return UNKNOWN;
    }

    public static Direction[] getOrderedDirections(Rect rect, Rect rect2, Number number) {
        Direction direction;
        Direction direction2 = Direction.fromNumber(number);
        if (direction2 != UNKNOWN) {
            return new Direction[]{direction2};
        }
        double d = rect2.getCenterX() - rect.getCenterX();
        double d2 = rect2.getCenterY() - rect.getCenterY();
        Direction direction3 = d > 0.0 ? EAST : WEST;
        Direction direction4 = direction = d2 > 0.0 ? SOUTH : NORTH;
        if (Math.abs(d) > Math.abs(d2)) {
            return new Direction[]{direction3, direction, direction.getReverse(), direction3.getReverse()};
        }
        return new Direction[]{direction, direction3, direction3.getReverse(), direction.getReverse()};
    }
}

