/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.AbstractGraphLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/layoutsLayer")
public class FishboneLayout
extends AbstractGraphLayout {
    private List<Shape> nonElementShapes;
    private List<Node> causeNodesListLeft;
    private List<Node> causeNodesListRight;
    private Node problemNode;
    private double backBoneWidth;
    private double causeEdgeAngle;
    private double defaultCauseGroupGap;
    private double initialLeftRightGap;
    private double defaultSubcauseEdgeLength;
    private Insets layoutPadding;

    public FishboneLayout(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
    }

    @Override
    public boolean isGraph() {
        return false;
    }

    @Override
    protected void layoutNodes(Dim dim) {
        this.causeNodesListLeft = new ArrayList<Node>();
        this.causeNodesListRight = new ArrayList<Node>();
        this.nonElementShapes = new ArrayList<Shape>();
        this.problemNode = this.findProblemNode();
        List<Node> list = this.problemNode.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            if (i % 2 == 0) {
                this.causeNodesListLeft.add(node);
                continue;
            }
            this.causeNodesListRight.add(node);
        }
        this.layoutPadding = Insets.makeForStylePadding(this.adapter.getSpec().padding, new Dim(0.0, 0.0), dim);
        this.backBoneWidth = this.getEdgeWidth(0);
        if (this.adapter.isSwapXY()) {
            this.backBoneWidth = this.backBoneWidth * dim.getWidth() / dim.getHeight();
        }
        this.initializeLayoutGaps(dim);
    }

    private void initializeLayoutGaps(Dim dim) {
        double d = dim.getHeight() - this.problemNode.getNodeHeight(dim.getHeight());
        this.defaultCauseGroupGap = d * 0.03;
        this.initialLeftRightGap = d * 0.03;
        this.defaultSubcauseEdgeLength = 30.0;
        this.causeEdgeAngle = 1.0471975511965976;
        double d2 = dim.getWidth() / 2.0 - this.backBoneWidth - this.getMaxCauseNodeWidth(dim);
        double d3 = d - this.initialLeftRightGap - (this.getMaxCauseGroupHeight(dim) + this.defaultCauseGroupGap) * (double)this.causeNodesListLeft.size();
        this.causeEdgeAngle = MathUtil.r(Math.atan(d2 / d3));
        if (this.causeEdgeAngle > 0.0 && this.causeEdgeAngle < 1.0471975511965976) {
            this.causeEdgeAngle = 1.0471975511965976;
            d3 = this.getVerticalGap(d2, dim);
        } else if (this.causeEdgeAngle < 0.0 || this.causeEdgeAngle > 1.5707963267948966) {
            this.causeEdgeAngle = 1.5707963267948966;
            d3 = 0.0;
            this.defaultCauseGroupGap = 5.0;
        }
        this.defaultSubcauseEdgeLength = 0.0;
        double d4 = this.adapter.isSwapXY() ? dim.getHeight() / dim.getWidth() : dim.getWidth() / dim.getHeight();
        this.defaultSubcauseEdgeLength = ((d - this.initialLeftRightGap - d3) / (double)this.causeNodesListLeft.size() - this.defaultCauseGroupGap - this.getMaxCauseGroupHeight(dim)) * 0.8;
        if (d4 > 1.0) {
            this.defaultSubcauseEdgeLength /= d4;
        }
        if (this.defaultSubcauseEdgeLength < 0.0) {
            this.defaultSubcauseEdgeLength = 0.0;
        }
    }

    @Override
    protected void placeInExtent(Dim dim) {
        double d = this.problemNode.getNodeHeight(dim.getHeight());
        double d2 = dim.getHeight() - 0.5 * d;
        this.placeProblemNode(d2, dim);
        this.placeCauseNodes(this.causeNodesListLeft, d2 -= d, dim, true);
        this.placeCauseNodes(this.causeNodesListRight, d2 - this.initialLeftRightGap, dim, false);
    }

    private void placeProblemNode(double d, Dim dim) {
        this.problemNode.setX(0.5);
        this.problemNode.setY(d / dim.getHeight());
        double d2 = 0.5 * dim.getWidth();
        double d3 = this.problemNode.getNodeHeight(dim.getHeight());
        double d4 = 0.5 * dim.getWidth();
        double d5 = dim.getHeight();
        if (this.layoutPadding != null) {
            d2 += this.layoutPadding.left;
            d4 += this.layoutPadding.left;
            d3 += this.layoutPadding.top;
            d5 += this.layoutPadding.top;
        }
        this.nonElementShapes.add(this.makeLink(d2, d3, d4, d5, this.problemNode.getRow(), 0));
    }

    private void placeCauseNodes(List<Node> list, double d, Dim dim, boolean bl) {
        double d2 = d;
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            double d3 = node.getNodeHeight(dim.getHeight());
            double d4 = node.getNodeWidth(dim.getWidth());
            double d5 = this.getVerticalGap(dim.getWidth() / 2.0 - this.backBoneWidth - d4, dim);
            d2 = i == 0 ? (d2 -= d5 - d3 / 2.0 + this.defaultCauseGroupGap) : (d2 -= d3 / 2.0);
            if (bl) {
                node.setX(d4 / (2.0 * dim.getWidth()));
            } else {
                node.setX(1.0 - d4 / (2.0 * dim.getWidth()));
            }
            node.setY(d2 / dim.getHeight());
            double d6 = bl ? d4 : dim.getWidth() - d4;
            double d7 = dim.getHeight() - d2;
            double d8 = bl ? (dim.getWidth() - this.backBoneWidth) / 2.0 : (dim.getWidth() + this.backBoneWidth) / 2.0;
            double d9 = dim.getHeight() - d2 - d5;
            if (this.layoutPadding != null) {
                d6 += this.layoutPadding.left;
                d8 += this.layoutPadding.left;
                d7 += this.layoutPadding.top;
                d9 += this.layoutPadding.top;
            }
            this.nonElementShapes.add(this.makeLink(d6, d7, d8, d9, node.getRow(), 1));
            this.placeSubCauseNodes(node, d8, d9, dim, bl);
            d2 -= this.calculateCauseGroupHeight(node, dim) + this.defaultCauseGroupGap;
        }
    }

    private void placeSubCauseNodes(Node node, double d, double d2, Dim dim, boolean bl) {
        List<Node> list = node.getChildren();
        double d3 = MathUtil.r(Math.cos(this.causeEdgeAngle));
        double d4 = MathUtil.r(Math.sin(this.causeEdgeAngle));
        double d5 = d;
        double d6 = dim.getHeight() - d2;
        double d7 = dim.getHeight() / dim.getWidth();
        double d8 = list.size();
        double d9 = node.getNodeWidth(dim.getWidth());
        double d10 = this.calculateCauseGroupWidth(node, dim);
        double d11 = d10 - d9;
        double d12 = (dim.getWidth() - this.backBoneWidth) / 2.0;
        double d13 = 0.0;
        boolean bl2 = false;
        double d14 = 0.0;
        double d15 = this.getEdgeWidth(1);
        if (this.adapter.isSwapXY()) {
            d15 *= d7;
        }
        if (d12 - d9 < d11) {
            d13 = (d12 - d10) / (d8 - 1.0);
            bl2 = true;
        } else {
            d13 = (d12 - d10) / (d8 + 1.0);
        }
        int n = 0;
        while ((double)n < d8) {
            double d16;
            Node node2 = list.get(n);
            if (node2.getChildren().size() > 0) {
                throw new EngineException("Cannot create a fishbone graph. More than three level are currently not supported.", ErrorCode.DATA_INVALID, "");
            }
            double d17 = node2.getNodeHeight(dim.getHeight());
            double d18 = node2.getNodeWidth(dim.getWidth());
            double d19 = n == 0 && bl2 ? d18 : d13 + d18;
            double d20 = d16 = bl ? d5 + d18 / 2.0 : (d5 += bl ? -d19 : d19) - d18 / 2.0;
            if (n > 0 && (bl && d16 > d14 || !bl && d16 < d14)) {
                d16 = d14;
            }
            d14 = d16;
            double d21 = bl ? d - d5 - d18 / 2.0 : d5 - d - d18 / 2.0;
            d21 -= this.backBoneWidth / 2.0 * ((double)n / d8);
            if (this.adapter.isSwapXY()) {
                d21 *= d7;
            }
            double d22 = d6 - (d21 * d3 / d4 + this.defaultSubcauseEdgeLength + d17 / 2.0);
            node2.setX((d16 - this.layoutPadding.left) / dim.getWidth());
            node2.setY((d22 + this.layoutPadding.top) / dim.getHeight());
            double d23 = d16;
            double d24 = dim.getHeight() - d22 - d17 / 2.0;
            double d25 = d23;
            double d26 = d24 - this.defaultSubcauseEdgeLength + d15 / 2.0;
            if (d26 - d24 < 0.0) {
                this.nonElementShapes.add(this.makeLink(d23, d24, d25, d26, node2.getRow(), 2));
            }
            ++n;
        }
    }

    private Shape makeLink(double d, double d2, double d3, double d4, int n, int n2) {
        double[] dArray = new double[]{d, d3};
        double[] dArray2 = new double[]{d2, d4};
        char[] cArray = new char[2];
        String string = "level_edge_" + n2;
        StyleSpec styleSpec = null;
        String string2 = n2 > 0 ? "arrow" : null;
        String string3 = n2 == 0 ? "arrow" : null;
        cArray[0] = 77;
        cArray[1] = 76;
        styleSpec = this.adapter.getTargetedStyle(string);
        Shape shape = this.adapter.makeItemFromPath(dArray, dArray2, cArray, false, n);
        Object object = styleSpec == null ? null : styleSpec.symbol;
        String string4 = BasicFactory.isString(object) ? (String)object : null;
        String string5 = styleSpec == null || styleSpec.startArrow == null && styleSpec.endArrow == null ? string3 : styleSpec.startArrow;
        String string6 = styleSpec == null || styleSpec.startArrow == null && styleSpec.endArrow == null ? string2 : styleSpec.endArrow;
        ((PolyShape)shape).setEdgeProperties(false, string4, string5, string6);
        if (styleSpec != null) {
            StyleBuilder.setUnfilled(shape, styleSpec, null);
        } else {
            StyleBuilder.setDefaultFillStyle(shape);
            StyleBuilder.setDefaultStrokeStyle(shape);
        }
        return shape;
    }

    private double getEdgeWidth(int n) {
        String string = "level_edge_" + n;
        StyleSpec styleSpec = this.adapter.getTargetedStyle(string);
        return StyleBuilder.getStrokeWidth(styleSpec);
    }

    private double getMaxCauseNodeWidth(Dim dim) {
        double d = 0.0;
        List<Node> list = this.problemNode.getChildren();
        for (Node node : list) {
            double d2 = node.getNodeWidth(dim.getWidth());
            d = Math.max(d, d2);
        }
        return d;
    }

    private double getMaxCauseGroupWidth(Dim dim) {
        double d = 0.0;
        List<Node> list = this.problemNode.getChildren();
        for (Node node : list) {
            d = Math.max(d, this.calculateCauseGroupWidth(node, dim));
        }
        return d;
    }

    private double getMaxCauseGroupHeight(Dim dim) {
        double d = 0.0;
        List<Node> list = this.problemNode.getChildren();
        for (Node node : list) {
            d = Math.max(d, this.calculateCauseGroupHeight(node, dim));
        }
        return d;
    }

    private double calculateCauseGroupHeight(Node node, Dim dim) {
        double d = node.getNodeHeight(dim.getHeight()) / 2.0;
        List<Node> list = node.getChildren();
        for (Node node2 : list) {
            d = Math.max(d, node2.getNodeHeight(dim.getHeight()));
        }
        return d += node.getNodeHeight(dim.getHeight()) / 2.0 + this.defaultSubcauseEdgeLength;
    }

    private double calculateCauseGroupWidth(Node node, Dim dim) {
        double d = node.getNodeWidth(dim.getWidth());
        List<Node> list = node.getChildren();
        for (Node node2 : list) {
            d += node2.getNodeWidth(dim.getWidth());
        }
        return d;
    }

    private Node findProblemNode() {
        if (this.nodes == null || this.nodes.length == 0) {
            throw new EngineException("Cannot create a fishbone graph. No problem nodes present.", ErrorCode.DATA_INVALID, null);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.nodes) {
            this.checkForCycle(node);
            if (node.inLink == null || node.inLink.length == 0) {
                arrayList.add(node);
                continue;
            }
            if (node.inLink.length <= 1) continue;
            throw new EngineException("Cannot create a fishbone graph. A fishbone graph cannot have a node with more than one parent node.", ErrorCode.DATA_INVALID, "Node " + node.getId());
        }
        if (arrayList.size() > 1) {
            throw new EngineException("Cannot create a fishbone graph. A fishbone graph cannot have more than one problem node.", ErrorCode.DATA_INVALID, "");
        }
        return (Node)arrayList.get(0);
    }

    private double getVerticalGap(double d, Dim dim) {
        double d2 = MathUtil.r(Math.cos(this.causeEdgeAngle));
        double d3 = MathUtil.r(Math.sin(this.causeEdgeAngle));
        double d4 = d * d2 / d3;
        if (this.adapter.isSwapXY()) {
            d4 = d4 * dim.getHeight() / dim.getWidth();
        }
        return d4;
    }

    @Override
    public Dim getPreferredSize(int n) {
        double d = 0.0;
        double d2 = 0.0;
        Dim dim = new Dim(5000.0, 5000.0);
        this.makeElementShapes(n, dim);
        this.defaultSubcauseEdgeLength = 0.0;
        d2 = this.problemNode.getNodeHeight(dim.getHeight()) + 0.0 + (this.getMaxCauseGroupHeight(dim) + this.defaultCauseGroupGap) * (double)this.causeNodesListLeft.size() + this.initialLeftRightGap;
        d = this.getMaxCauseGroupWidth(dim) * 2.0 + this.backBoneWidth;
        if (this.adapter.isSwapXY()) {
            return new Dim(d2, d);
        }
        return new Dim(d, d2);
    }

    @Override
    public List<Shape> makeNonElementShapes(Dim dim) {
        return this.nonElementShapes;
    }

    @Override
    protected void setupNodeLayering(Dim dim) {
    }
}

