/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import java.util.ArrayList;

class Graph {
    public Node[] nodes;
    public Link[] links;

    Graph(Node[] nodeArray, Link[] linkArray) {
        this.nodes = nodeArray;
        this.links = linkArray;
    }

    public void reverseLinksIfNeeded() {
        for (Link link : this.links) {
            if (link.getTo().getLayer() <= link.getFrom().getLayer()) continue;
            link.reverse();
        }
    }

    public void removeUnwantedLinks() {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (int i = 0; i < this.links.length; ++i) {
            Node node = this.links[i].getFrom();
            Node node2 = this.links[i].getTo();
            if (!this.isNodeAvailable(node) || !this.isNodeAvailable(node2)) continue;
            arrayList.add(this.links[i]);
        }
        this.links = arrayList.toArray(new Link[arrayList.size()]);
    }

    private boolean isNodeAvailable(Node node) {
        for (Node node2 : this.nodes) {
            if (node2 != node) continue;
            return true;
        }
        return false;
    }
}

