/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.LiteGraph;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.FieldRefSpec;
import com.ibm.vis.spec.internal.LayoutSpec;
import java.util.HashMap;
import java.util.Map;

public class GraphBuilder {
    private final LayoutAdapter adapter;
    private final LayoutSpec spec;
    private final String linkTypeID;
    private Map<Double, Node> nodeMap;

    public GraphBuilder(LayoutAdapter layoutAdapter) {
        this.adapter = layoutAdapter;
        this.spec = layoutAdapter.getSpec();
        this.ensureValid();
        FieldRefSpec fieldRefSpec = layoutAdapter.getSpec().linkType;
        this.linkTypeID = fieldRefSpec == null ? null : fieldRefSpec.$ref;
    }

    public LiteGraph build(boolean bl) {
        LiteGraph liteGraph = new LiteGraph(null, null);
        this.nodeMap = new HashMap<Double, Node>();
        if (bl) {
            this.readNodes(liteGraph);
        } else {
            this.makeNodes(liteGraph);
        }
        this.makeLinks(liteGraph);
        liteGraph.attachLinksToNodes();
        return liteGraph;
    }

    private void readNodes(LiteGraph liteGraph) {
        HashMap<Double, Shape> hashMap = this.adapter.getElementItems(this.spec.id.$ref);
        for (Double d : hashMap.keySet()) {
            Shape shape = hashMap.get(d);
            if (d == null || shape == null) continue;
            Node node = new Node(shape.getRows()[0]);
            node.setId(d);
            node.setShape(shape);
            Rect rect = shape.getBounds();
            node.setX(rect.getCenterX());
            node.setY(rect.getCenterY());
            this.nodeMap.put(d, node);
            liteGraph.addNode(node);
        }
    }

    private void makeNodes(LiteGraph liteGraph) {
        double[] dArray = new double[]{1.0, 0.0};
        double[] dArray2 = this.adapter.getAllFieldValuesAsNumeric(this.spec.id.$ref);
        for (int i = 0; i < dArray2.length; ++i) {
            if (Double.isNaN(dArray2[i])) continue;
            Node node = new Node(i);
            node.setId(dArray2[i]);
            node.setShape(this.adapter.makeItemAtSimpleCoordinates(dArray, i, true));
            this.nodeMap.put(dArray2[i], node);
            liteGraph.addNode(node);
        }
    }

    private void makeLinks(LiteGraph liteGraph) {
        double[] dArray = this.adapter.getAllFieldValuesAsNumeric(this.spec.from.$ref);
        double[] dArray2 = this.adapter.getAllFieldValuesAsNumeric(this.spec.to.$ref);
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i]) || Double.isNaN(dArray2[i])) continue;
            Node node = this.nodeMap.get(dArray[i]);
            Node node2 = this.nodeMap.get(dArray2[i]);
            if (node == null || node2 == null || node == node2) continue;
            Link link = new Link(node, node2);
            link.setRow(i);
            if (this.linkTypeID != null) {
                link.setGroupType(this.adapter.getFieldNumericValue(this.linkTypeID, i));
            }
            liteGraph.addLink(link);
        }
    }

    private void ensureValid() {
        if (this.spec.id == null) {
            throw new EngineException("positioning.id must be defined", ErrorCode.SPEC_IS_NULL, "positioning.id");
        }
        if (this.spec.from == null) {
            throw new EngineException("positioning.from must be defined", ErrorCode.SPEC_IS_NULL, "positioning.from");
        }
        if (this.spec.to == null) {
            throw new EngineException("positioning.to must be defined", ErrorCode.SPEC_IS_NULL, "positioning.to");
        }
    }
}

