/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.AbstractGraphLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.Crossings;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/graphLayoutsLayer")
public class GridGraphLayout
extends AbstractGraphLayout {
    ArrayList<Point> gridPts;
    protected int extraGrid = 0;

    public GridGraphLayout(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
    }

    int getGridOverlapCount(Node node) {
        int n = 0;
        for (Link link : node.inLink) {
            if (link.getFrom().getX() == link.getTo().getX()) {
                n += (int)Math.floor(Math.abs(link.getFrom().getY() - link.getTo().getY()) - 0.5);
            }
            if (link.getFrom().getY() != link.getTo().getY()) continue;
            n += (int)Math.floor(Math.abs(link.getFrom().getX() - link.getTo().getX()) - 0.5);
        }
        for (Link link : node.getOutLink()) {
            if (link.getFrom().getX() == link.getTo().getX()) {
                n += (int)Math.floor(Math.abs(link.getFrom().getY() - link.getTo().getY()) - 0.5);
            }
            if (link.getFrom().getY() != link.getTo().getY()) continue;
            n += (int)Math.floor(Math.abs(link.getFrom().getX() - link.getTo().getX()) - 0.5);
        }
        return n;
    }

    @Override
    protected void layoutNodes(Dim dim) {
        this.sortNodes();
        Dim dim2 = this.adapter.getElementSize();
        int n = this.getColumnCount(dim2, dim);
        int n2 = (int)Math.ceil((double)this.nodes.length / (double)n);
        if (n2 * n < this.nodes.length) {
            ++n2;
        }
        double d = Math.sqrt(Math.max(n += this.extraGrid, n2 += this.extraGrid));
        this.gridPts = this.makeGridPoints(n, n2);
        this.initialPlacement(d);
        Node[] nodeArray = this.nodes;
        this.nodes = this.makeAugmentedNodes();
        this.simpleSwaps();
        this.nodes = nodeArray;
        this.placeInExtent(dim);
    }

    void sortNodes() {
        double[] dArray = new double[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            dArray[i] = (double)this.nodes[i].degree() - (double)i / 1000000.0;
        }
        int[] nArray = BasicFactory.makeSortOrder(dArray);
        Node[] nodeArray = new Node[this.nodes.length];
        for (int i = 0; i < nArray.length; ++i) {
            nodeArray[nArray.length - 1 - i] = this.nodes[nArray[i]];
        }
        this.nodes = nodeArray;
    }

    private void simpleSwaps() {
        long l = BasicFactory.getSystemTimer();
        int n = this.links.length * (this.links.length - 1) / 2;
        int n2 = (int)Math.round(2000000.0 / (double)n);
        this.doSwaps(n2);
        if (this.adapter.hasListeners()) {
            long l2 = BasicFactory.getSystemTimer() - l;
            this.adapter.logDetail("Time used for swapping", "time (ms)", l2);
        }
    }

    void doSwaps(int n) {
        int n2;
        Crossings crossings = new Crossings(this.nodes, this.links);
        int[] nArray = new int[this.nodes.length];
        for (n2 = 0; n2 < this.nodes.length; ++n2) {
            nArray[n2] = this.getGridOverlapCount(this.nodes[n2]);
        }
        n2 = 0;
        boolean bl = true;
        while (bl && n2 < n) {
            bl = false;
            for (int i = 0; n2 < n && i < this.nodes.length; ++i) {
                if (nArray[i] + crossings.counts[i] <= 0) continue;
                for (int j = 0; j < this.nodes.length; ++j) {
                    if (i == j) continue;
                    ++n2;
                    this.nodes[i].swapWith(this.nodes[j]);
                    int n3 = this.getGridOverlapCount(this.nodes[i]) + this.getGridOverlapCount(this.nodes[j]) - nArray[i] - nArray[j];
                    this.nodes[i].swapWith(this.nodes[j]);
                    if (!crossings.swap(i, j, n3)) continue;
                    bl = true;
                    for (int k = 0; k < this.nodes.length; ++k) {
                        nArray[k] = this.getGridOverlapCount(this.nodes[k]);
                    }
                }
            }
        }
    }

    private Node[] makeAugmentedNodes() {
        int n;
        Node[] nodeArray = new Node[this.gridPts.size() + this.nodes.length];
        for (n = 0; n < this.nodes.length; ++n) {
            nodeArray[n] = this.nodes[n];
        }
        n = this.nodes.length;
        for (Point point : this.gridPts) {
            nodeArray[n] = Node.makeDummyNode(point);
            nodeArray[n].setOrientation(this.adapter.isSwapXY(), this.adapter.isReflectY());
            ++n;
        }
        return nodeArray;
    }

    void initialPlacement(double d) {
        for (Node node : this.nodes) {
            node.setInfo(node.degree());
        }
        for (Node node : this.nodes) {
            if (node.getInfo() == null) continue;
            Point point = this.gridPts.get(0);
            this.placeNode(node, point);
            point.setX(point.getX() - 0.002);
            point.setY(point.getY() - 0.001);
            for (Link link : node.getOutLink()) {
                this.placeOther(d, point, link.getTo());
            }
            for (Link link : node.inLink) {
                this.placeOther(d, point, link.getFrom());
            }
        }
    }

    private void placeOther(double d, Point point, Node node) {
        Point point2;
        if (node.getInfo() != null && (point2 = this.findClosestEmpty(point, d)) != null) {
            this.placeNode(node, point2);
        }
    }

    private int getColumnCount(Dim dim, Dim dim2) {
        double d = dim2.getWidth() / dim.getWidth() / (dim2.getHeight() / dim.getHeight());
        return (int)Math.round(Math.sqrt((double)this.nodes.length * d));
    }

    ArrayList<Point> makeGridPoints(int n, int n2) {
        Point point = new Point(((double)n - 1.0) / 2.0 - 1.0E-5, ((double)n2 - 1.0) / 2.0 - 1.0E-6);
        Point[] pointArray = new Point[n * n2];
        double[] dArray = new double[n * n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Object object = new Point(i, j);
                pointArray[i * n2 + j] = object;
                dArray[i * n2 + j] = ((Point)object).distance(point);
            }
        }
        int[] nArray = BasicFactory.makeSortOrder(dArray);
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int n3 : nArray) {
            arrayList.add(pointArray[n3]);
        }
        return arrayList;
    }

    private Point findClosestEmpty(Point point, double d) {
        Point point2 = null;
        double d2 = d;
        for (Point point3 : this.gridPts) {
            double d3 = point.distance(point3);
            if (!(d3 < d2)) continue;
            d2 = d3;
            point2 = point3;
        }
        return point2;
    }

    private void placeNode(Node node, Point point) {
        node.setX(point.getX());
        node.setY(point.getY());
        this.gridPts.remove(point);
        node.setInfo(null);
    }

    @Override
    protected void setupNodeLayering(Dim dim) {
    }
}

