/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Line;
import com.ibm.vis.geom.Point;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Link {
    public static final Link[] NONE = new Link[0];
    private Node from;
    private Node to;
    private boolean reversed;
    private int row;
    private double weight;
    private boolean linkPruned;
    private Number groupId;
    private Number groupType;
    private String fromPart;
    private String toPart;

    public Link(Node node, Node node2) {
        assert (node != null);
        assert (node2 != null);
        this.from = node;
        this.to = node2;
        this.reversed = false;
        this.linkPruned = false;
        this.row = -1;
        this.fromPart = null;
        this.toPart = null;
        this.groupType = null;
        this.groupId = null;
    }

    public final Node getTo() {
        return this.to;
    }

    public final Node getFrom() {
        return this.from;
    }

    public int getSpan() {
        return Math.abs(this.from.getLayer() - this.to.getLayer());
    }

    public Node getOpposite(Node node) {
        return this.from == node ? this.to : this.from;
    }

    public final boolean isReversed() {
        return this.reversed;
    }

    public final void setReversed(boolean bl) {
        this.reversed = bl;
    }

    void reverse() {
        this.from.setOutLink(this.removeMe(this.from.getOutLink()));
        this.to.inLink = this.removeMe(this.to.inLink);
        Node node = this.from;
        this.from = this.to;
        this.to = node;
        String string = this.fromPart;
        this.fromPart = this.toPart;
        this.toPart = string;
        this.from.setOutLink(this.addMe(this.from.getOutLink()));
        this.to.inLink = this.addMe(this.to.inLink);
        this.reversed = true;
    }

    private Link[] removeMe(Link[] linkArray) {
        Link[] linkArray2 = new Link[linkArray.length - 1];
        int n = 0;
        for (Link link : linkArray) {
            if (link == this) continue;
            linkArray2[n++] = link;
        }
        return linkArray2;
    }

    private Link[] addMe(Link[] linkArray) {
        Link[] linkArray2 = new Link[linkArray.length + 1];
        for (int i = 0; i < linkArray.length; ++i) {
            linkArray2[i] = linkArray[i];
        }
        linkArray2[linkArray.length] = this;
        return linkArray2;
    }

    public final int getRow() {
        return this.row;
    }

    public final void setRow(int n) {
        this.row = n;
    }

    public final void setWeight(double d) {
        this.weight = d;
    }

    public final double getWeight() {
        return this.weight;
    }

    public final double getDistanceFactor() {
        return 1.0 / this.weight;
    }

    public final boolean isLinkPruned() {
        return this.linkPruned;
    }

    public final void setLinkPruned(boolean bl) {
        this.linkPruned = bl;
    }

    public final void setFromPart(String string) {
        this.fromPart = string;
    }

    public final String getFromPart() {
        return this.fromPart;
    }

    public final void setToPart(String string) {
        this.toPart = string;
    }

    public final String getToPart() {
        return this.toPart;
    }

    public boolean isEquivalent(Link link) {
        return this.from.getRow() == link.getFrom().getRow() && this.to.getRow() == link.getTo().getRow();
    }

    public String toString() {
        return "<" + this.from.getRow() + "," + this.to.getRow() + ">";
    }

    final boolean intersects(Link link) {
        Point point = this.from.getPartXY(this.fromPart);
        Point point2 = this.to.getPartXY(this.toPart);
        Point point3 = link.from.getPartXY(link.fromPart);
        Point point4 = link.to.getPartXY(link.toPart);
        return Line.segmentsIntersect(point.getX(), point.getY(), point2.getX(), point2.getY(), point3.getX(), point3.getY(), point4.getX(), point4.getY(), true);
    }

    final double length() {
        return this.from.distance(this.to);
    }

    public final Number getGroupId() {
        return this.groupId;
    }

    public final void setGroupId(Number number) {
        this.groupId = number;
    }

    public final Number getGroupType() {
        return this.groupType;
    }

    public final void setGroupType(Number number) {
        this.groupType = number;
    }

    public final void copyInfoFrom(Link link) {
        this.fromPart = link.fromPart;
        this.toPart = link.toPart;
        this.groupId = link.groupId;
        this.groupType = link.groupType;
        this.linkPruned = link.linkPruned;
        this.reversed = link.reversed;
        this.row = link.row;
        this.weight = link.weight;
    }
}

