/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.TreeLayout;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.exceptions.internal.SpecException;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class LinkGroup {
    public static final double STACK_FACE_GAP = 5.0;
    private static final ArrayList<Double> VALID_LAYOUTS = new ArrayList();
    public static final double NORMAL_LAYOUT = LinkGroup.addValidLayout(BasicFactory.makeLong(0).longValue());
    public static final double STACK_LAYOUT = LinkGroup.addValidLayout(BasicFactory.makeLong(1).longValue());
    public static final double OFFSET_LAYOUT = LinkGroup.addValidLayout(BasicFactory.makeLong(2).longValue());
    public static final double DUMMY_LAYOUT = LinkGroup.addValidLayout(BasicFactory.makeLong(10).longValue());
    private final Number groupId;
    private double groupType = Double.NaN;
    private Node rootNode;
    private final ArrayList<Link> links;

    public LinkGroup(Number number) {
        assert (number != null);
        this.groupId = number;
        this.links = new ArrayList();
    }

    private static final double addValidLayout(double d) {
        VALID_LAYOUTS.add(d);
        return d;
    }

    public Number getGroupId() {
        return this.groupId;
    }

    public Number getGroupType() {
        return this.groupType;
    }

    public boolean addLink(Link link, int n) {
        if (!this.groupId.equals(link.getGroupId())) {
            throw new EngineException("Adding link to an incorrect group. link id: " + n + " with groupId: " + link.getGroupId() + "cannot be added to group with id: " + this.groupId, ErrorCode.DATA_INVALID, null);
        }
        if (this.rootNode == null) {
            this.rootNode = link.getFrom();
        }
        if (Double.isNaN(this.groupType)) {
            this.setGroupType(link.getGroupType());
        }
        if (!this.rootNode.equals(link.getFrom())) {
            throw new SpecException("Links in the same group in a tree layout must have the same FROM node. link id: " + n, ErrorCode.DATA_INVALID, null);
        }
        if (!LinkGroup.isGroupTypeValid(link.getGroupType() == null ? Double.NaN : link.getGroupType().doubleValue())) {
            throw new SpecException("Invalid link group type. link id: " + n + ", link type:" + link.getGroupType(), ErrorCode.DATA_INVALID, null);
        }
        if (!this.isGroupTypeSame(link.getGroupType() == null ? Double.NaN : link.getGroupType().doubleValue())) {
            throw new SpecException("Links in the same group in a tree layout must have the same link group type. link id: " + n, ErrorCode.DATA_INVALID, null);
        }
        return this.links.add(link);
    }

    protected static boolean isGroupTypeValid(double d) {
        return Double.isNaN(d) || VALID_LAYOUTS.contains(d);
    }

    protected void setGroupType(Number number) {
        this.groupType = number == null ? NORMAL_LAYOUT : number.doubleValue();
    }

    protected boolean isGroupTypeSame(double d) {
        if (Double.isNaN(d)) {
            return this.groupType == NORMAL_LAYOUT;
        }
        return this.groupType == d;
    }

    public void validateGroup() {
        if (STACK_LAYOUT == this.groupType) {
            for (Link link : this.links) {
                if (link.getTo().getInfo() == null || ((ArrayList[])link.getTo().getInfo())[0].size() == 0) continue;
                throw new SpecException("Links in a stack group in a tree layout must have the TO nodes as a leaf node", ErrorCode.DATA_INVALID, null);
            }
        }
    }

    public final List<Link> getLinks() {
        return this.links;
    }

    public final Node getRootNode() {
        return this.rootNode;
    }

    public final void clearLinks() {
        this.groupType = Double.NaN;
        this.links.clear();
        this.rootNode = null;
    }

    public Range getAcrossRange(boolean bl) {
        if (this.links == null || this.links.size() == 0) {
            return Range.EMPTY;
        }
        Range range = null;
        for (Link link : this.links) {
            range = this.expandRangeX(link.getFrom(), range, bl);
            range = this.expandRangeX(link.getTo(), range, bl);
        }
        return range;
    }

    public Range getDownRange(boolean bl) {
        if (this.links == null || this.links.size() == 0) {
            return Range.EMPTY;
        }
        Range range = null;
        for (Link link : this.links) {
            range = this.expandRangeY(link.getTo(), range, bl);
        }
        return range;
    }

    protected Range expandRangeX(Node node, Range range, boolean bl) {
        if (!node.equals(this.rootNode)) {
            if (range == null) {
                range = new Range(node.getX() - LinkGroup.getWidth(node, bl) / 2.0, node.getX() + LinkGroup.getWidth(node, bl) / 2.0);
            } else {
                range = range.unionValue(node.getX() - LinkGroup.getWidth(node, bl) / 2.0);
                range = range.unionValue(node.getX() + LinkGroup.getWidth(node, bl) / 2.0);
            }
        }
        return range;
    }

    protected Range expandRangeY(Node node, Range range, boolean bl) {
        if (!node.equals(this.rootNode)) {
            if (range == null) {
                range = new Range(node.getY() - LinkGroup.getHeight(node, bl) / 2.0, node.getY() + LinkGroup.getHeight(node, bl) / 2.0);
            } else {
                range = range.unionValue(node.getY() - LinkGroup.getHeight(node, bl) / 2.0);
                range = range.unionValue(node.getY() + LinkGroup.getHeight(node, bl) / 2.0);
            }
        }
        return range;
    }

    protected static double getWidth(Node node, boolean bl) {
        Shape shape = node.getShape();
        if (shape == null) {
            return 0.0;
        }
        if (bl) {
            return shape.getBounds().getHeight();
        }
        return shape.getBounds().getWidth();
    }

    protected static double getHeight(Node node, boolean bl) {
        Shape shape = node.getShape();
        if (shape == null) {
            return 0.0;
        }
        if (bl) {
            return shape.getBounds().getWidth();
        }
        return shape.getBounds().getHeight();
    }

    public double getStackLayoutMaxLeafWidth(boolean bl) {
        if (STACK_LAYOUT != this.groupType) {
            throw new EngineException("getStackLayoutWidth should only be called for groups with Stack layout", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        if (this.links == null || this.links.size() == 0) {
            return 0.0;
        }
        double d = Double.NEGATIVE_INFINITY;
        for (Link link : this.links) {
            double d2 = LinkGroup.getWidth(link.getTo(), bl);
            if (!(d2 > d)) continue;
            d = d2;
        }
        if (this.isSoleStackedGroup()) {
            double d3 = LinkGroup.getWidth(this.getRootNode(), bl);
            d += d - d3;
            d += 30.0;
        } else {
            d += 15.0;
        }
        return d;
    }

    public boolean isSoleStackedGroup() {
        if (STACK_LAYOUT == this.groupType) {
            if (this.getRootNode().outLink.length == 1) {
                return true;
            }
            Node node = this.getRootNode();
            List<Node> list = TreeLayout.getDummyNodes(this.getRootNode());
            if (list.size() != 0) {
                node = list.get(list.size() - 1);
            }
            for (Link link : node.outLink) {
                if (link.getGroupId() != null && link.getGroupId() == this.getGroupId()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Node getWidestToNode(boolean bl) {
        double d = Double.NEGATIVE_INFINITY;
        Node node = null;
        for (Link link : this.links) {
            double d2 = LinkGroup.getWidth(link.getTo(), bl);
            if (!(d2 > d)) continue;
            d = d2;
            node = link.getTo();
        }
        return node;
    }
}

