/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAGNodeInfoSameLayer;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAGNodePlacementAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.SymmetricNodePlacement;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class MaximumOverlap
implements DAGNodePlacementAlgorithm {
    private final LayoutAdapter adapter;
    private Node[][] layers;
    Dim extent;
    private final Map<Node, Range[]> extents;

    MaximumOverlap(LayoutAdapter layoutAdapter) {
        this.adapter = layoutAdapter;
        this.extents = new HashMap<Node, Range[]>();
    }

    private boolean displacementContains(Node node, double d) {
        return this.extents.get(node)[0].contains(d);
    }

    private void setMaxDisplacement(Node node, Range range) {
        Range[] rangeArray = this.extents.get(node);
        if (rangeArray == null) {
            rangeArray = new Range[2];
            this.extents.put(node, rangeArray);
        }
        rangeArray[0] = range;
    }

    private void setLandingExtent(Node node, Range range) {
        Range[] rangeArray = this.extents.get(node);
        if (rangeArray == null) {
            rangeArray = new Range[2];
            this.extents.put(node, rangeArray);
        }
        rangeArray[1] = range;
    }

    private Range getMaxDisplacement(Node node) {
        return this.extents.get(node)[0];
    }

    private Range getLandingExtent(Node node) {
        return this.extents.get(node)[1];
    }

    @Override
    public void layoutNodes(Node[][] nodeArray, Dim dim) {
        new SymmetricNodePlacement(this.adapter).layoutNodes(nodeArray, dim);
        this.layers = nodeArray;
        this.extent = dim;
        this.alignNodeWithChildren(dim);
        this.alignNodeWithParent(dim);
    }

    void alignNodeWithChildren(Dim dim) {
        for (int i = 0; i < 3; ++i) {
            int n;
            for (n = 1; n < this.layers.length; ++n) {
                this.sweepNodes(dim, n);
            }
            for (n = this.layers.length - 1; n > 0; --n) {
                this.sweepNodes(dim, n);
            }
        }
    }

    private void alignNodeWithParent(Dim dim) {
        for (int i = 0; i < 3; ++i) {
            int n;
            for (n = 0; n < this.layers.length; ++n) {
                this.sweepChildren(dim, n);
            }
            for (n = this.layers.length - 1; n >= 0; --n) {
                this.sweepChildren(dim, n);
            }
        }
    }

    void sweepChildren(Dim dim, int n) {
        int n2;
        Node[] nodeArray = this.layers[n];
        int[] nArray = this.getLayerOrder(nodeArray);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.alignChildren(dim, nodeArray, nArray, n2);
        }
        for (n2 = nArray.length - 1; n2 >= 0; --n2) {
            this.alignChildren(dim, nodeArray, nArray, n2);
        }
    }

    private void alignChildren(Dim dim, Node[] nodeArray, int[] nArray, int n) {
        Node node = nodeArray[nArray[n]];
        Node node2 = n > 0 ? nodeArray[nArray[n - 1]] : null;
        Node node3 = n < nArray.length - 1 ? nodeArray[nArray[n + 1]] : null;
        this.computeMaxDisplacement(node, node2, node3);
        if (node.isDummy()) {
            this.alignDummyNodeWithParent(node);
        } else if (node.getOutLink().length == 0) {
            Node[] nodeArray2 = this.getParentsInOrder(node);
            int n2 = this.execute(node, nodeArray2);
            if (node.inLink.length == 1 || n2 == 1) {
                Node node4 = this.findOverlappingNode(node, nodeArray2);
                node4 = node4 != null ? node4 : node.inLink[0].getFrom();
                this.alignVerticallyWithNode(node, node4);
            }
        }
    }

    void alignDummyNodeWithParent(Node node) {
        Node node2 = node.inLink[0].getFrom();
        if (node.getInfo() instanceof DAGNodeInfoSameLayer) {
            DAGNodeInfoSameLayer dAGNodeInfoSameLayer = (DAGNodeInfoSameLayer)node.getInfo();
            dAGNodeInfoSameLayer.updateBelongsToNodeX(node);
        } else if (node2.getX() != node.getX()) {
            if (node2.isDummy()) {
                if (this.displacementContains(node, node2.getX())) {
                    node.setX(node2.getX());
                }
            } else {
                Range range = this.getLandingExtent(node2);
                if (this.displacementContains(node, range.getMin())) {
                    node.setX(range.getMin());
                }
                if (this.displacementContains(node, range.getMax())) {
                    node.setX(range.getMax());
                }
                if (this.displacementContains(node, node2.getX())) {
                    node.setX(node2.getX());
                }
            }
        }
    }

    private void sweepNodes(Dim dim, int n) {
        int n2;
        Node[] nodeArray = this.layers[n];
        int[] nArray = this.getLayerOrder(nodeArray);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.alignNode(dim, nodeArray, nArray, n2);
        }
        for (n2 = nArray.length - 1; n2 >= 0; --n2) {
            this.alignNode(dim, nodeArray, nArray, n2);
        }
    }

    private void alignNode(Dim dim, Node[] nodeArray, int[] nArray, int n) {
        Node node = nodeArray[nArray[n]];
        Node node2 = n > 0 ? nodeArray[nArray[n - 1]] : null;
        Node node3 = n < nArray.length - 1 ? nodeArray[nArray[n + 1]] : null;
        this.computeMaxDisplacement(node, node2, node3);
        if (!this.overlapsAllChildren(node)) {
            this.displaceNode(node);
        } else if (node.getOutLink().length == 1) {
            this.alignVerticallyWithNode(node, node.getOutLink()[0].getTo());
        }
    }

    public boolean overlapsNode(Node node, Node node2) {
        this.computeLandingExtent(node2);
        this.computeLandingExtent(node);
        return this.getLandingExtent(node).contains(this.getLandingExtent(node2).getMin()) || this.getLandingExtent(node).contains(this.getLandingExtent(node2).getMax());
    }

    boolean overlapsAllChildren(Node node) {
        Link[] linkArray;
        for (Link link : linkArray = node.getOutLink()) {
            Node node2 = link.getTo();
            if (this.overlapsNode(node, node2)) continue;
            return false;
        }
        return true;
    }

    private void computeLandingExtent(Node node) {
        double d = this.getNodeWidth(node);
        double d2 = node.getX() - 0.4 * d;
        double d3 = node.getX() + 0.4 * d;
        this.setLandingExtent(node, new Range(d2, d3));
    }

    private void displaceNode(Node node) {
        Node[] nodeArray = this.getChildrenInOrder(node);
        int n = this.execute(node, nodeArray);
        if (node.getOutLink().length == 1 || n == 1) {
            Node node2 = this.findOverlappingNode(node, nodeArray);
            node2 = node2 != null ? node2 : node.getOutLink()[0].getTo();
            this.alignVerticallyWithNode(node, node2);
        }
    }

    int execute(Node node, Node[] nodeArray) {
        int n = this.calculateOverlapCount(node, nodeArray);
        double d = this.getNodeWidth(node);
        double d2 = d * this.extent.getWidth() < 10.0 ? 10.0 : d * this.extent.getWidth();
        double d3 = 0.1 * d2 / this.extent.getWidth();
        double d4 = node.getX();
        node.setX(this.getMaxDisplacement(node).getMin() + d / 2.0);
        int n2 = 0;
        while (node.getX() + d / 2.0 <= this.getMaxDisplacement(node).getMax()) {
            n2 = this.calculateOverlapCount(node, nodeArray);
            if (n2 > n) {
                d4 = node.getX();
                n = n2;
            }
            node.setX(node.getX() + d3);
        }
        node.setX(d4);
        return n;
    }

    private Node findOverlappingNode(Node node, Node[] nodeArray) {
        for (Node node2 : nodeArray) {
            if (!this.overlapsNode(node, node2)) continue;
            return node2;
        }
        return null;
    }

    private void computeMaxDisplacement(Node node, Node node2, Node node3) {
        double d = this.getNodeWidth(node2);
        double d2 = this.getNodeWidth(node3);
        double d3 = 0.1 * d;
        double d4 = 0.1 * d2;
        double d5 = node2 != null ? node2.getX() + d / 2.0 + d3 : 0.0;
        double d6 = node3 != null ? node3.getX() - d2 / 2.0 - d4 : 1.0;
        this.setMaxDisplacement(node, new Range(d5, d6));
    }

    private double getNodeWidth(Node node) {
        if (node == null) {
            return 0.0;
        }
        if (!node.isDummy()) {
            return node.getNodeWidth(this.extent.getWidth()) / this.extent.getWidth();
        }
        return 10.0 / this.extent.getWidth();
    }

    private void alignVerticallyWithNode(Node node, Node node2) {
        double d = this.getNodeWidth(node);
        double d2 = this.getNodeWidth(node2);
        if (!node.isDummy() && !node2.isDummy()) {
            if (d >= d2) {
                if (this.displacementContains(node, node2.getX() - d2 / 2.0) && this.displacementContains(node, node2.getX() + d2 / 2.0) && this.displacementContains(node, node2.getX() + d / 2.0)) {
                    node.setX(node2.getX());
                }
            } else if (this.displacementContains(node, node2.getX() - d / 2.0) && this.displacementContains(node, node2.getX() + d / 2.0)) {
                node.setX(node2.getX());
            }
        } else if (!node.isDummy() && node2.isDummy()) {
            if (this.displacementContains(node, node2.getX() - d / 2.0) && this.displacementContains(node, node2.getX() + d / 2.0)) {
                node.setX(node2.getX());
            }
        } else if (node.isDummy() && !node2.isDummy()) {
            if (this.displacementContains(node, node2.getX())) {
                node.setX(node2.getX());
            }
        } else if (node.isDummy() && node2.isDummy() && this.displacementContains(node, node2.getX())) {
            node.setX(node2.getX());
        }
    }

    private int calculateOverlapCount(Node node, Node[] nodeArray) {
        int n = 0;
        for (Node node2 : nodeArray) {
            if (!this.overlapsNode(node, node2)) continue;
            ++n;
        }
        return n;
    }

    private Node[] getChildrenInOrder(Node node) {
        Link[] linkArray = node.getOutLink();
        Node[] nodeArray = new Node[linkArray.length];
        for (int i = 0; i < linkArray.length; ++i) {
            nodeArray[i] = linkArray[i].getTo();
        }
        int[] nArray = this.getLayerOrder(nodeArray);
        Node[] nodeArray2 = new Node[nodeArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nodeArray2[i] = nodeArray[nArray[i]];
        }
        return nodeArray2;
    }

    private Node[] getParentsInOrder(Node node) {
        Link[] linkArray = node.inLink;
        Node[] nodeArray = new Node[linkArray.length];
        for (int i = 0; i < linkArray.length; ++i) {
            nodeArray[i] = linkArray[i].getFrom();
        }
        int[] nArray = this.getLayerOrder(nodeArray);
        Node[] nodeArray2 = new Node[nodeArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nodeArray2[i] = nodeArray[nArray[i]];
        }
        return nodeArray2;
    }

    int[] getLayerOrder(Node[] nodeArray) {
        double[] dArray = new double[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            dArray[i] = nodeArray[i].getX();
        }
        return BasicFactory.makeSortOrder(dArray);
    }
}

