/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.SymmetricNodePlacement;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class NaturalNodePlacement
extends SymmetricNodePlacement {
    private static final double MIN_MOVE = 1.0E-8;
    private static final double MIN_GAP = 0.01;
    private Node[][] layers;
    private List<Node> all;

    NaturalNodePlacement(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
    }

    @Override
    public void layoutNodes(Node[][] nodeArray, Dim dim) {
        this.layers = this.sort(nodeArray);
        this.all = new ArrayList<Node>();
        Node[][] nodeArray2 = this.layers;
        int n = nodeArray2.length;
        for (int i = 0; i < n; ++i) {
            Node[] nodeArray3;
            for (Node node : nodeArray3 = nodeArray2[i]) {
                this.all.add(node);
            }
        }
        super.layoutNodes(this.layers, dim);
        for (int i = 0; i < this.layers.length; ++i) {
            n = 0;
            for (Node[] nodeArray4 : this.layers) {
                n += this.improveLocations(nodeArray4, true);
                n += this.improveLocations(nodeArray4, false);
            }
            this.placeInExtent();
            if (n == 0) break;
        }
    }

    private Node[][] sort(Node[][] nodeArray) {
        Node[][] nodeArray2 = new Node[nodeArray.length][];
        for (int i = 0; i < nodeArray2.length; ++i) {
            int[] nArray = this.getLayerOrder(nodeArray[i]);
            nodeArray2[i] = new Node[nArray.length];
            for (int j = 0; j < nArray.length; ++j) {
                nodeArray2[i][j] = nodeArray[i][nArray[j]];
            }
        }
        return nodeArray2;
    }

    public int improveLocations(Node[] nodeArray, boolean bl) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < nodeArray.length && (n2 = this.improveLocationsForLayer(nodeArray, bl)) != 0; ++i) {
            n += n2;
        }
        return n;
    }

    public int improveLocationsForLayer(Node[] nodeArray, boolean bl) {
        double[] dArray = this.makeNodeDesiredMoves(nodeArray, bl);
        double[] dArray2 = new double[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            dArray2[i] = -Math.abs(dArray[i]);
        }
        int[] nArray = BasicFactory.makeSortOrder(dArray2);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (dArray[n2] > 1.0E-8) {
                if (!this.move(n2, n2 + 1, dArray[n2], nodeArray)) continue;
                ++n;
                continue;
            }
            if (!(dArray[n2] < -1.0E-8) || !this.move(n2, n2 - 1, dArray[n2], nodeArray)) continue;
            ++n;
        }
        return n;
    }

    private boolean move(int n, int n2, double d, Node[] nodeArray) {
        Node node = nodeArray[n];
        double d2 = 1.0;
        if (n2 >= 0 && n2 < nodeArray.length) {
            Node node2 = nodeArray[n2];
            d2 = Math.abs(node2.getX() - node.getX()) - (node.getWidth() / 2.0 + node2.getWidth() / 2.0) - 0.01;
        }
        if (d2 <= 0.0) {
            return false;
        }
        double d3 = Math.min(d, d2);
        d3 = Math.max(-d2, d3);
        node.setX(node.getX() + d3);
        return true;
    }

    private double[] makeNodeDesiredMoves(Node[] nodeArray, boolean bl) {
        double[] dArray = new double[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            Link[] linkArray = bl ? nodeArray[i].getInLink() : nodeArray[i].getOutLink();
            double d = nodeArray[i].getX();
            double d2 = 0.0;
            double d3 = 0.0;
            for (Link link : linkArray) {
                Node node = link.getOpposite(nodeArray[i]);
                double d4 = node.isDummy() ? 0.01 : 1.0;
                d2 += d4 * node.getX();
                d3 += d4;
            }
            dArray[i] = d3 == 0.0 ? 0.0 : d2 / d3 - d;
        }
        return dArray;
    }

    protected void placeInExtent() {
        Range range = Range.EMPTY;
        Range range2 = Range.EMPTY;
        for (Node node : this.all) {
            double d = node.getWidth() / 2.0;
            double d2 = node.getHeight() / 2.0;
            if (this.adapter.isSwapXY()) {
                double d3 = d;
                d = d2;
                d2 = d3;
            }
            range = range.unionValue(node.getX() - d);
            range = range.unionValue(node.getX() + d);
            range2 = range2.unionValue(node.getY() - d2);
            range2 = range2.unionValue(node.getY() + d2);
        }
        for (Node node : this.all) {
            node.setX(range.toZeroOne(node.getX()));
            node.setY(range2.toZeroOne(node.getY()));
        }
    }
}

