/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Node {
    private final int row;
    private final Point position;
    private boolean lockPosition;
    private double specifiedX;
    private double specifiedY;
    private boolean specPosition;
    private double width;
    private double height;
    protected double realWidth;
    protected double realHeight;
    private Shape shape;
    private boolean relativePartCoordinates;
    private boolean swapXY;
    private boolean reflectY;
    private Object info;
    private Number id;
    private int layer;
    private Number order;
    private int weight;
    private boolean nodePruned;
    private Node parent;
    protected Link[] outLink;
    protected Link[] inLink;
    protected Node[] neighbors;
    protected Link[] links;
    public int increment;

    public Node(int n) {
        this.row = n;
        this.order = null;
        this.specPosition = false;
        this.lockPosition = false;
        this.nodePruned = false;
        this.swapXY = false;
        this.reflectY = false;
        this.relativePartCoordinates = true;
        this.position = new Point(0.0, 0.0);
    }

    public static Node makeDummyNode(Point point) {
        Node node = new Node(-1);
        node.setX(point.getX());
        node.setY(point.getY());
        node.setOutLink(new Link[0]);
        node.inLink = node.getOutLink();
        return node;
    }

    public final int getRow() {
        return this.row;
    }

    public final boolean isDummy() {
        return this.row < 0;
    }

    public final String toString() {
        return "[" + this.row + "]";
    }

    public final Point getPosition() {
        return this.position;
    }

    public final double getX() {
        return this.position.getX();
    }

    public final void setX(double d) {
        if (!this.lockPosition) {
            this.position.setX(d);
        }
    }

    public final double getY() {
        return this.position.getY();
    }

    public final void setY(double d) {
        if (!this.lockPosition) {
            this.position.setY(d);
        }
    }

    public final void moveTo(double d, double d2) {
        this.position.setX(d);
        this.position.setY(d2);
    }

    public void moveBy(double d, double d2) {
        this.position.setX(this.position.getX() + d);
        this.position.setY(this.position.getY() + d2);
    }

    void swapWith(Node node) {
        double d = this.getX();
        double d2 = this.getY();
        this.setX(node.getX());
        this.setY(node.getY());
        node.setX(d);
        node.setY(d2);
    }

    final double distance(Node node) {
        return Math.sqrt((node.getX() - this.getX()) * (node.getX() - this.getX()) + (node.getY() - this.getY()) * (node.getY() - this.getY()));
    }

    public void specifyPosition(double d, double d2) {
        this.specifiedX = d;
        this.specifiedY = d2;
        this.specPosition = true;
        this.lockPosition = false;
    }

    public boolean positionSpecified() {
        return this.specPosition;
    }

    public void moveToSpecifiedPosition() {
        this.lockPosition = false;
        this.setX(this.specifiedX);
        this.setY(this.specifiedY);
        this.lockPosition = true;
    }

    public final double getWidth() {
        return this.width;
    }

    public final void setWidth(double d) {
        this.width = d;
    }

    public final double getHeight() {
        return this.height;
    }

    public final void setHeight(double d) {
        this.height = d;
    }

    public double getNodeWidth(double d) {
        if (this.swapXY) {
            return this.getHeight() * d;
        }
        return this.getWidth() * d;
    }

    public double getNodeHeight(double d) {
        if (this.swapXY) {
            return this.getWidth() * d;
        }
        return this.getHeight() * d;
    }

    public final Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        Rect rect = shape.getBounds();
        this.realWidth = rect.getWidth();
        this.realHeight = rect.getHeight();
    }

    public final Rect getCurrentBounds() {
        return new Rect(this.position.getX() - this.realWidth / 2.0, this.position.getY() - this.realHeight / 2.0, this.realWidth, this.realHeight);
    }

    public final void setPartRelativeCoordinates(boolean bl) {
        this.relativePartCoordinates = bl;
    }

    public final Point getPartXY(String string) {
        if (string == null) {
            return this.position;
        }
        if (this.shape == null) {
            throw new EngineException("Part coordinates used in layout before shape is set, contact the RAVE team", ErrorCode.ENGINE_UNSUPPORTED_OPERATION, null);
        }
        Shape shape = this.shape.getPartByName(string);
        if (shape == null) {
            throw new SpecException("Part '" + string + "' not found in node shape", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        Rect rect = this.shape.getBounds();
        Point point = shape.getCenter();
        double d = point.getX() - rect.getCenterX();
        double d2 = -(point.getY() - rect.getCenterY());
        if (this.relativePartCoordinates) {
            if (rect.getWidth() > 0.0) {
                d /= rect.getWidth();
            }
            if (rect.getHeight() > 0.0) {
                d2 /= rect.getHeight();
            }
            d *= 0.25;
            d2 *= 0.25;
        }
        if (this.swapXY) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        if (this.reflectY) {
            d2 = -d2;
        }
        return new Point(this.position.getX() + d, this.position.getY() + d2);
    }

    public final void setOrientation(boolean bl, boolean bl2) {
        this.swapXY = bl;
        this.reflectY = bl2;
    }

    public final boolean isSwapXY() {
        return this.swapXY;
    }

    public final boolean isReflectY() {
        return this.reflectY;
    }

    public final Object getInfo() {
        return this.info;
    }

    public final void setInfo(Object object) {
        this.info = object;
    }

    public final Number getId() {
        return this.id;
    }

    public final void setId(Number number) {
        this.id = number;
    }

    public final Node getParent() {
        return this.parent;
    }

    public final void setParent(Node node) {
        this.parent = node;
    }

    public final int getWeight() {
        return this.weight;
    }

    public final void setWeight(int n) {
        this.weight = n;
    }

    public final Number getOrder() {
        return this.order;
    }

    public final void setOrder(Number number) {
        this.order = number;
    }

    public boolean isOrdered() {
        if (this.order != null) {
            return !Double.isNaN(this.order.doubleValue());
        }
        return false;
    }

    public final int getLayer() {
        return this.layer;
    }

    public final void setLayer(int n) {
        this.layer = n;
    }

    public boolean isNodePruned() {
        return this.nodePruned;
    }

    public void setNodePruned(boolean bl) {
        this.nodePruned = bl;
    }

    public final Link[] getOutLink() {
        return this.outLink;
    }

    public final void setOutLink(Link[] linkArray) {
        this.outLink = linkArray;
        this.neighbors = null;
        this.links = null;
    }

    public final Link[] getInLink() {
        return this.inLink;
    }

    public final void setInLink(Link[] linkArray) {
        this.inLink = linkArray;
        this.neighbors = null;
        this.links = null;
    }

    public final int degree() {
        return this.inLink.length + this.outLink.length;
    }

    public Node[] getNeighbors() {
        if (this.neighbors == null) {
            int n;
            this.neighbors = new Node[this.degree()];
            for (n = 0; n < this.inLink.length; ++n) {
                this.neighbors[n] = this.inLink[n].getFrom();
            }
            for (n = 0; n < this.outLink.length; ++n) {
                this.neighbors[n + this.inLink.length] = this.outLink[n].getTo();
            }
        }
        return this.neighbors;
    }

    public Link[] getLinks() {
        if (this.links == null) {
            int n;
            this.links = new Link[this.degree()];
            for (n = 0; n < this.inLink.length; ++n) {
                this.links[n] = this.inLink[n];
            }
            for (n = 0; n < this.outLink.length; ++n) {
                this.links[n + this.inLink.length] = this.outLink[n];
            }
        }
        return this.links;
    }

    public void replaceOutlink(Link link, Link link2) {
        for (int i = 0; i < this.getOutLink().length; ++i) {
            if (this.getOutLink()[i] != link) continue;
            this.getOutLink()[i] = link2;
            this.neighbors = null;
            this.links = null;
            return;
        }
    }

    public void replaceInlink(Link link, Link link2) {
        for (int i = 0; i < this.inLink.length; ++i) {
            if (this.inLink[i] != link) continue;
            this.inLink[i] = link2;
            this.neighbors = null;
            this.links = null;
            return;
        }
    }

    public double orthogonalDistance(Node node) {
        return Math.abs(this.position.getX() - node.position.getX()) + Math.abs(this.position.getY() - node.position.getY());
    }

    public List<Node> getChildren() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Link[] linkArray = this.getOutLink();
        if (linkArray != null) {
            for (Link link : linkArray) {
                arrayList.add(link.getTo());
            }
        }
        return arrayList;
    }
}

