/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.grammar.layout.Layout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.Direction;
import com.ibm.vis.engine.internal.grammar.layout.graph.GraphBuilder;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.ComponentSplitting;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.LiteGraph;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.LevelsSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/graphLayoutsLayer")
public class ProcessFlowLayout
extends Layout {
    private final String xID;
    private final String yID;
    private ArrayList<Shape> shapes;
    private Dim size;
    private Dim spacing;

    public ProcessFlowLayout(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
        LevelsSpec[] levelsSpecArray = layoutAdapter.getSpec().levels;
        this.xID = levelsSpecArray != null && levelsSpecArray.length > 1 ? levelsSpecArray[0].field.$ref : null;
        this.yID = levelsSpecArray != null && levelsSpecArray.length > 0 ? levelsSpecArray[1].field.$ref : null;
    }

    @Override
    public Dim getPreferredSize(int n) {
        this.makeElementShapes(n, new Dim(600.0, 600.0));
        return this.size;
    }

    @Override
    public boolean needsAestheticsPreApplied() {
        return true;
    }

    @Override
    public void prepareForNewRows(int n) {
        this.shapes = null;
    }

    @Override
    public List<Shape> makeElementShapes(int n, Dim dim) {
        if (this.shapes == null) {
            LiteGraph liteGraph = new GraphBuilder(this.adapter).build(false);
            ComponentSplitting componentSplitting = ComponentSplitting.fromLiteGraph(liteGraph);
            double d = 0.0;
            for (LiteGraph liteGraph2 : componentSplitting.getComponents()) {
                this.layout(liteGraph2);
                double d2 = 0.0;
                for (Node node : liteGraph2.getNodes()) {
                    node.getShape().affine(1.0, d, 1.0, 0.0, false);
                    d2 = Math.max(d2, node.getShape().getBounds().getX2());
                }
                d = d2 + this.spacing.getWidth();
            }
            this.makeShapes(liteGraph.getNodes());
        }
        return this.shapes;
    }

    private void makeShapes(List<Node> list) {
        this.shapes = new ArrayList();
        Geom geom = null;
        for (Node node : list) {
            Shape shape = node.getShape();
            this.shapes.add(shape);
            if (geom == null) {
                geom = shape.getBounds().copy();
                continue;
            }
            ((Rect)geom).extendToRect(shape.getBounds());
        }
        double d = Math.min(this.spacing.getWidth(), this.spacing.getHeight());
        geom = (Rect)geom.expand(d);
        this.adapter.getSharedLayoutInfo().setMinimalNodeSeparation(d);
        for (Shape shape : this.shapes) {
            shape.affine(1.0, -((Rect)geom).getX(), 1.0, -((Rect)geom).getY(), false);
        }
        this.size = new Dim(((Rect)geom).getWidth(), ((Rect)geom).getHeight());
    }

    private void layout(LiteGraph liteGraph) {
        LiteGraph liteGraph2 = this.makeMaximalSubgraph(liteGraph);
        this.spacing = this.getGoodSpacing(liteGraph.getNodes());
        this.placeOnGrid(liteGraph2.getNodes());
        this.distribute(liteGraph2, this.spacing.getWidth(), false);
        this.distribute(liteGraph2, this.spacing.getHeight(), true);
    }

    /*
     * WARNING - void declaration
     */
    private void distribute(LiteGraph liteGraph, double d, boolean bl) {
        HashMap hashMap = new HashMap();
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        for (Node node : liteGraph.getNodes()) {
            void list;
            int n = (int)(bl ? node.getY() : node.getX());
            List list2 = (List)hashMap.get(n);
            if (list2 == null) {
                ArrayList arrayList = new ArrayList();
                hashMap.put(n, arrayList);
                intPrimitiveArrayList.add(n);
            }
            list.add(node);
        }
        Object arrayList = intPrimitiveArrayList.toArray(new int[intPrimitiveArrayList.size()]);
        BasicFactory.sortArray((int[])arrayList);
        double d2 = 0.0;
        for (Object object : arrayList) {
            List list = (List)hashMap.get((int)object);
            double d3 = this.getSize(list, bl);
            for (Node node : list) {
                double d4;
                Shape shape = node.getShape();
                Rect rect = shape.getBounds();
                if (bl) {
                    d4 = d2 - rect.getY() + (double)Math.round((d3 - rect.getHeight()) / 2.0);
                    shape.affine(1.0, 0.0, 1.0, d4, false);
                    continue;
                }
                d4 = d2 - rect.getX() + (double)Math.round((d3 - rect.getWidth()) / 2.0);
                shape.affine(1.0, d4, 1.0, 0.0, false);
            }
            d2 += d3 + d;
        }
    }

    private double getSize(List<Node> list, boolean bl) {
        double d = 0.0;
        for (Node node : list) {
            Rect rect = node.getShape().getBounds();
            d = Math.max(d, bl ? rect.getHeight() : rect.getWidth());
        }
        return Math.round(d);
    }

    private Dim getGoodSpacing(List<Node> list) {
        Object object;
        int n;
        double[] dArray = new double[list.size()];
        double[] dArray2 = new double[list.size()];
        for (n = 0; n < list.size(); ++n) {
            object = list.get(n).getShape().getBounds();
            dArray[n] = ((Rect)object).getWidth();
            dArray2[n] = ((Rect)object).getHeight();
        }
        BasicFactory.sortArray(dArray);
        BasicFactory.sortArray(dArray2);
        n = (int)Math.floor(list.size() / 4);
        object = new Dim(Math.max(30.0, dArray[n] * 2.0 / 3.0), Math.max(30.0, dArray2[n] * 2.0 / 3.0));
        if (this.adapter.getStyle() == null || this.adapter.getStyle().padding == null) {
            return object;
        }
        Insets insets = this.adapter.getPadding(ShapeFactory2.CreateRect(0.0, 0.0, ((Dim)object).getWidth(), ((Dim)object).getHeight()), (Dim)object);
        return new Dim(insets.getHorizontal() / 2.0, insets.getVertical() / 2.0);
    }

    private LiteGraph makeMaximalSubgraph(LiteGraph liteGraph) {
        LiteGraph liteGraph2 = new LiteGraph(null, null);
        for (Node object : liteGraph.getNodes()) {
            Node node = new Node(object.getRow());
            liteGraph2.addNode(node);
            object.setInfo(node);
            node.setParent(object);
            node.setShape(object.getShape());
            ArrayList<Node> arrayList = new ArrayList<Node>();
            arrayList.add(node);
            node.setInfo(arrayList);
        }
        for (int i = 0; i < 4; ++i) {
            for (Link link : liteGraph.getLinks()) {
                if (this.getPass(link.getGroupType()) != i) continue;
                this.checkLinkForMerge(link, liteGraph2);
            }
        }
        liteGraph2.attachLinksToNodes();
        return liteGraph2;
    }

    private void checkLinkForMerge(Link link, LiteGraph liteGraph) {
        ArrayList arrayList;
        Node node = (Node)link.getFrom().getInfo();
        Node node2 = (Node)link.getTo().getInfo();
        ArrayList arrayList2 = (ArrayList)node.getInfo();
        if (arrayList2 != (arrayList = (ArrayList)node2.getInfo())) {
            Link link2 = new Link(node, node2);
            link2.copyInfoFrom(link);
            liteGraph.addLink(link2);
            arrayList2.addAll(arrayList);
            for (Node node3 : arrayList) {
                node3.setInfo(arrayList2);
            }
        }
    }

    private int getPass(Number number) {
        if (number == null) {
            return 3;
        }
        if (number.doubleValue() == (double)Direction.WEST.getIndex()) {
            return 2;
        }
        if (number.doubleValue() == (double)Direction.NORTH.getIndex() || number.doubleValue() == (double)Direction.SOUTH.getIndex()) {
            return 1;
        }
        if (number.doubleValue() == (double)Direction.EAST.getIndex()) {
            return 0;
        }
        return 3;
    }

    private int placeOnGrid(List<Node> list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        this.placeOnGridRecursively(list.get(0), null, 0, 0, hashSet);
        double d = 0.0;
        double d2 = 0.0;
        for (Node node : list) {
            d = Math.min(d, node.getX());
            d2 = Math.min(d2, node.getY());
        }
        double d3 = 0.0;
        double d4 = 0.0;
        for (Node node : list) {
            node.setX(node.getX() - d);
            node.setY(node.getY() - d2);
            d3 = Math.max(d3, node.getX());
            d4 = Math.max(d4, node.getY());
        }
        return (int)Math.round(d3) + 1;
    }

    private int modifyForSetGridValue(int n, String string, int n2) {
        if (string == null) {
            return n;
        }
        double d = this.adapter.getFieldNumericValue(string, n2);
        if (Double.isNaN(d)) {
            return n;
        }
        return (int)Math.round(d);
    }

    private void placeOnGridRecursively(Node node, Node node2, int n, int n2, Set<Integer> set) {
        int n3;
        int n4;
        double d;
        int n5 = node.getRow();
        int n6 = (n = this.modifyForSetGridValue(n, this.xID, n5)) + 100 * (n2 = this.modifyForSetGridValue(n2, this.yID, n5));
        if (set.contains(n6)) {
            for (int i = 1; i < 100; ++i) {
                int n7 = n > 0 ? -1 : 1;
                n6 = n + 100 * (n2 + i * n7);
                if (!set.contains(n6)) {
                    n2 += i * n7;
                    break;
                }
                n6 = n + 100 * (n2 - i * n7);
                if (set.contains(n6)) continue;
                n2 -= i * n7;
                break;
            }
        }
        set.add(n6);
        node.moveTo(n, n2);
        if (node.getParent() != null) {
            node.getParent().moveTo(n, n2);
        }
        for (Link link : node.getInLink()) {
            if (link.getFrom() == node2) continue;
            d = this.getDirection(link.getGroupType());
            n4 = (int)Math.round(Math.cos(Math.PI + d));
            n3 = (int)Math.round(Math.sin(Math.PI + d));
            this.placeOnGridRecursively(link.getFrom(), node, n + n4, n2 + n3, set);
        }
        for (Link link : node.getOutLink()) {
            if (link.getTo() == node2) continue;
            d = this.getDirection(link.getGroupType());
            n4 = (int)Math.round(Math.cos(d));
            n3 = (int)Math.round(Math.sin(d));
            this.placeOnGridRecursively(link.getTo(), node, n + n4, n2 + n3, set);
        }
    }

    private double getDirection(Number number) {
        if (number != null) {
            int n = (int)Math.round(number.doubleValue());
            if (n == Direction.EAST.getIndex()) {
                return 0.0;
            }
            if (n == Direction.NORTH.getIndex()) {
                return -1.5707963267948966;
            }
            if (n == Direction.SOUTH.getIndex()) {
                return 1.5707963267948966;
            }
            if (n == Direction.WEST.getIndex()) {
                return Math.PI;
            }
        }
        return 0.0;
    }
}

