/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAG;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAGNodePlacementAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class SpreadLayersToEdge
implements DAGNodePlacementAlgorithm {
    private final LayoutAdapter adapter;

    SpreadLayersToEdge(LayoutAdapter layoutAdapter) {
        this.adapter = layoutAdapter;
    }

    @Override
    public void layoutNodes(Node[][] nodeArray, Dim dim) {
        int n = nodeArray.length;
        if (n == 0) {
            return;
        }
        Range[] rangeArray = new Range[n];
        int[] nArray = new int[n];
        HashMap<Number, Integer> hashMap = new HashMap<Number, Integer>();
        if (n == 1) {
            nArray[0] = DAG.getMaxLevel(nodeArray[0]);
            rangeArray[0] = new Range(0.0, 1.0);
            SpreadLayersToEdge.setLayerY(nodeArray[0], 0.5, hashMap);
        } else {
            double d = this.adapter.isSwapXY() ? dim.getWidth() : dim.getHeight();
            double[] dArray = new double[n];
            double d2 = SpreadLayersToEdge.computeNodeHeights(nodeArray, dArray, d);
            double d3 = (d - d2) / (double)(n - 1);
            double d4 = 0.0;
            for (int i = 0; i < n; ++i) {
                double d5 = dArray[i];
                SpreadLayersToEdge.setLayerY(nodeArray[i], (d4 += d5 / 2.0) / d, hashMap);
                nArray[i] = DAG.getMaxLevel(nodeArray[i]);
                rangeArray[i] = i == 0 ? new Range(0.0, d4 / d) : (i < nodeArray.length - 1 ? new Range(rangeArray[i - 1].getMax(), (d4 += d5 / 2.0) / d) : new Range(rangeArray[i - 1].getMax(), 1.0));
                d4 += d3;
            }
        }
        this.adapter.getSharedLayoutInfo().setLayerInfo(rangeArray, nArray, hashMap);
    }

    private static void setLayerY(Node[] nodeArray, double d, HashMap<Number, Integer> hashMap) {
        for (Node node : nodeArray) {
            node.setY(d);
            hashMap.put(node.getId(), node.getLayer());
        }
    }

    private static double computeNodeHeights(Node[][] nodeArray, double[] dArray, double d) {
        int n = nodeArray.length;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d3 = 0.0;
            for (Node node : nodeArray[i]) {
                d3 = Math.max(d3, node.getNodeHeight(d));
            }
            dArray[i] = d3;
            d2 += d3;
        }
        return d2;
    }
}

