/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.DAGNodePlacementAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class SymmetricNodePlacement
implements DAGNodePlacementAlgorithm {
    protected LayoutAdapter adapter;

    SymmetricNodePlacement(LayoutAdapter layoutAdapter) {
        this.adapter = layoutAdapter;
    }

    @Override
    public void layoutNodes(Node[][] nodeArray, Dim dim) {
        double d = this.computeHorizontalNodeGap(dim, nodeArray);
        double d2 = this.computeVerticalLayerGap(dim, nodeArray);
        this.adapter.getSharedLayoutInfo().setSelfLinkRadius(Math.min(d, d2) / 2.0);
        for (Node[] nodeArray2 : nodeArray) {
            int[] nArray = this.getLayerOrder(nodeArray2);
            double d3 = this.computeLayerWidth(dim, nodeArray2) + d * (double)(nodeArray2.length - 1);
            double d4 = (dim.getWidth() - d3) / 2.0;
            for (int n : nArray) {
                Node node = nodeArray2[n];
                double d5 = node.getNodeWidth(dim.getWidth());
                node.setX((d4 + d5 / 2.0) / dim.getWidth());
                d4 += d + d5;
            }
        }
    }

    private double computeVerticalLayerGap(Dim dim, Node[][] nodeArray) {
        double d = 0.0;
        for (Node[] nodeArray2 : nodeArray) {
            d += this.computeMaxNodeHeight(dim, nodeArray2);
        }
        return (dim.getHeight() - d) / (double)(nodeArray.length - 1);
    }

    private double computeMaxNodeHeight(Dim dim, Node[] nodeArray) {
        double d = 0.0;
        for (Node node : nodeArray) {
            d = Math.max(d, node.getNodeHeight(dim.getHeight()));
        }
        return d;
    }

    private double computeHorizontalNodeGap(Dim dim, Node[][] nodeArray) {
        double d = 0.0;
        int n = 0;
        for (Node[] nodeArray2 : nodeArray) {
            d = Math.max(d, this.computeLayerWidth(dim, nodeArray2));
            n = Math.max(n, nodeArray2.length);
        }
        if (n == 1) {
            return (dim.getWidth() - d) / 2.0;
        }
        return (dim.getWidth() - d) / (double)(n - 1);
    }

    private double computeLayerWidth(Dim dim, Node[] nodeArray) {
        double d = 0.0;
        for (Node node : nodeArray) {
            d += node.getNodeWidth(dim.getWidth());
        }
        return d;
    }

    protected int[] getLayerOrder(Node[] nodeArray) {
        double[] dArray = new double[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            dArray[i] = nodeArray[i].getX();
        }
        return BasicFactory.makeSortOrder(dArray);
    }
}

