/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.MutableRange;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.SharedLayoutInfo;
import com.ibm.vis.engine.internal.grammar.layout.graph.AbstractGraphLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.LinkGroup;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.LayoutSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/graphLayoutsLayer")
public class TreeLayout
extends AbstractGraphLayout {
    private static final Dim EXTENT_FOR_PREF_SIZE = new Dim(5000.0, 5000.0);
    protected static final Dim EXTENT_FOR_CALCULATING_GAPS = new Dim(800.0, 800.0);
    private final boolean isHorizontalLayout;
    private List<Double> maxHeightByLevel;
    private final String orientation;
    private int numLevels;
    private final double leafNodeGap;
    private final double levelGap;
    private final String linkGroupField;
    private final String linkTypeField;
    private List<LinkGroup> groups;
    private final HashMap<Node, Double> nodeFaceAlignment;

    public TreeLayout(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
        LayoutSpec layoutSpec = layoutAdapter.getSpec();
        this.linkGroupField = layoutSpec.linkGroup == null ? null : layoutSpec.linkGroup.$ref;
        this.linkTypeField = layoutSpec.linkType == null ? null : layoutSpec.linkType.$ref;
        this.orientation = layoutSpec.orientation;
        this.isHorizontalLayout = "left-to-right".equals(layoutSpec.orientation) || "right-to-left".equals(layoutSpec.orientation);
        this.leafNodeGap = TreeLayout.computeLeafNodeGap(layoutAdapter.getStyle());
        this.levelGap = TreeLayout.computeLevelGap(layoutAdapter.getStyle());
        this.groups = null;
        this.nodeFaceAlignment = new HashMap();
    }

    @Override
    protected void makeNodesAndLinks(int n) {
        this.groups = new ArrayList<LinkGroup>();
        super.makeNodesAndLinks(n);
    }

    protected void validateGroups() {
        for (LinkGroup linkGroup : this.groups) {
            linkGroup.validateGroup();
        }
    }

    @Override
    protected Link createLink(int n, double[] dArray, double[] dArray2, HashMap<Number, Node> hashMap, ArrayList<Link> arrayList) {
        Link link = super.createLink(n, dArray, dArray2, hashMap, arrayList);
        if (link != null && this.linkGroupField != null) {
            this.createGroupForLink(n, link);
        }
        return link;
    }

    private void createGroupForLink(int n, Link link) {
        double d;
        double d2 = this.adapter.getFieldNumericValue(this.linkGroupField, n);
        double d3 = d = this.linkTypeField == null ? Double.NaN : this.adapter.getFieldNumericValue(this.linkTypeField, n);
        if (!Double.isNaN(d2)) {
            link.setGroupId(d2);
            link.setGroupType(d);
            LinkGroup linkGroup = this.getLinkGroup(d2);
            linkGroup.addLink(link, n);
        }
    }

    @Override
    protected void reorderLinks(ArrayList<Link> arrayList) {
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        if (this.groups != null) {
            double d;
            this.validateGroups();
            this.setIncrementLevelToRootNode();
            for (LinkGroup linkGroup : this.groups) {
                d = Double.NaN;
                if (linkGroup.getGroupType() != null) {
                    d = linkGroup.getGroupType().doubleValue();
                }
                if (LinkGroup.STACK_LAYOUT != d) continue;
                this.convertLeafListToTree(linkGroup.getRootNode(), linkGroup.getLinks(), arrayList);
            }
            for (LinkGroup linkGroup : this.groups) {
                d = Double.NaN;
                if (linkGroup.getGroupType() != null) {
                    d = linkGroup.getGroupType().doubleValue();
                }
                if (LinkGroup.NORMAL_LAYOUT == d) {
                    this.reorderGroupedLinks(linkGroup.getRootNode(), linkGroup.getLinks());
                    continue;
                }
                if (LinkGroup.OFFSET_LAYOUT != d) continue;
                this.reorderAndMoveGroupedLinks(linkGroup.getRootNode(), linkGroup.getLinks(), this.isOddOffsetGroupForNode(linkGroup));
                if (arrayList2.contains(linkGroup.getRootNode())) continue;
                this.insertDummyNodes(linkGroup);
                arrayList2.add(linkGroup.getRootNode());
            }
        }
    }

    private void insertDummyNodes(LinkGroup linkGroup) {
        ArrayList[] arrayListArray;
        Link link;
        Node node = linkGroup.getRootNode();
        if (node == null) {
            return;
        }
        ArrayList arrayList = ((ArrayList[])node.getInfo())[0];
        ArrayList<Link> arrayList2 = new ArrayList<Link>();
        for (Link link2 : arrayList) {
            double d = Double.NaN;
            if (link2.getGroupType() != null) {
                d = link2.getGroupType().doubleValue();
            }
            if (LinkGroup.OFFSET_LAYOUT == d) continue;
            arrayList2.add(link2);
        }
        Node[] nodeArray = null;
        if (arrayList2.size() == 0) {
            node.increment = 1;
        }
        int n = 0;
        if (node.getId() != null) {
            n = node.getId().intValue();
        }
        int n2 = node.increment;
        nodeArray = new Node[n2];
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        for (int i = 0; i < n2; ++i) {
            ArrayList arrayList3;
            Node node5 = new Node(-n - 1 - i);
            if (i == 0) {
                node2 = node5;
                link = new Link(node, node2);
                arrayListArray = ((ArrayList[])node.getInfo())[0];
                arrayList3 = new ArrayList();
                for (Link link3 : arrayListArray) {
                    double d = Double.NaN;
                    if (link3.getGroupType() != null) {
                        d = link3.getGroupType().doubleValue();
                    }
                    if (LinkGroup.OFFSET_LAYOUT != d) continue;
                    arrayList3.add(link3);
                }
                arrayList3.add(link);
                ((ArrayList[])node.getInfo())[0] = arrayList3;
                ArrayList[] arrayListArray2 = new ArrayList[]{new ArrayList(), new ArrayList()};
                arrayListArray2[1].add(link);
                node2.setInfo(arrayListArray2);
                node4 = node2;
            } else {
                link = new Link(node4, node5);
                arrayListArray = new ArrayList[]{new ArrayList(), new ArrayList()};
                arrayListArray[1].add(link);
                node5.setInfo(arrayListArray);
                arrayList3 = ((ArrayList[])node4.getInfo())[0];
                arrayList3.add(link);
                node4 = node5;
            }
            node3 = node5;
            nodeArray[i] = node5;
        }
        ArrayList arrayList4 = ((ArrayList[])node3.getInfo())[0];
        for (int i = 0; i < arrayList2.size(); ++i) {
            link = (Link)arrayList2.get(i);
            arrayListArray = new Link(node3, ((Link)arrayList2.get(i)).getTo());
            arrayListArray.setGroupId(link.getGroupId());
            arrayListArray.setGroupType(link.getGroupType());
            arrayList4.add(arrayListArray);
        }
        this.addDummyNodes(nodeArray);
    }

    protected void convertLeafListToTree(Node node, List<Link> list, ArrayList<Link> arrayList) {
        Object object2;
        ArrayList<Link> arrayList2 = new ArrayList<Link>();
        Link link = list.get(0);
        for (Object object2 : ((ArrayList[])node.getInfo())[0]) {
            if (!link.equals(object2) && list.contains(object2)) continue;
            arrayList2.add((Link)object2);
        }
        ((ArrayList[])node.getInfo())[0] = arrayList2;
        Object object3 = null;
        object2 = null;
        for (int i = 1; i < list.size(); ++i) {
            object3 = list.get(i - 1).getTo();
            object2 = list.get(i).getTo();
            if (((ArrayList[])((Node)object2).getInfo())[1].size() > 1) {
                throw new EngineException("Cannot create a tree. A tree cannot have a node with more than one parent node.", ErrorCode.DATA_INVALID, "Node " + ((Node)object2).getId());
            }
            Link link2 = new Link((Node)object3, (Node)object2);
            link2.copyInfoFrom(list.get(i));
            ArrayList<Link> arrayList3 = new ArrayList<Link>();
            arrayList3.add(link2);
            ((ArrayList[])((Node)object3).getInfo())[0] = arrayList3;
            ArrayList<Link> arrayList4 = new ArrayList<Link>();
            arrayList4.add(link2);
            ((ArrayList[])((Node)object2).getInfo())[1] = arrayList4;
            arrayList.add(link2);
            arrayList.remove(list.get(i));
        }
    }

    protected void reorderGroupedLinks(Node node, List<Link> list) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        boolean bl = true;
        for (Link link : ((ArrayList[])node.getInfo())[0]) {
            if (!list.contains(link)) {
                arrayList.add(link);
                continue;
            }
            if (!bl) continue;
            arrayList.addAll(list);
            bl = false;
        }
        ((ArrayList[])node.getInfo())[0] = arrayList;
    }

    protected boolean isOddOffsetGroupForNode(LinkGroup linkGroup) {
        int n = 1;
        for (LinkGroup linkGroup2 : this.groups) {
            if (linkGroup2.equals(linkGroup)) break;
            double d = Double.NaN;
            if (linkGroup2.getGroupType() != null) {
                d = linkGroup2.getGroupType().doubleValue();
            }
            if (LinkGroup.OFFSET_LAYOUT != d || !linkGroup2.getRootNode().equals(linkGroup.getRootNode())) continue;
            ++n;
        }
        return n % 2 != 0;
    }

    protected void reorderAndMoveGroupedLinks(Node node, List<Link> list, boolean bl) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : ((ArrayList[])node.getInfo())[0]) {
            if (list.contains(link)) continue;
            arrayList.add(link);
        }
        if (bl) {
            arrayList.addAll(0, list);
        } else {
            arrayList.addAll(list);
        }
        ((ArrayList[])node.getInfo())[0] = arrayList;
    }

    protected LinkGroup getLinkGroup(Number number) {
        LinkGroup linkGroup = null;
        for (LinkGroup linkGroup2 : this.groups) {
            if (!linkGroup2.getGroupId().equals(number)) continue;
            linkGroup = linkGroup2;
            break;
        }
        if (linkGroup == null) {
            linkGroup = new LinkGroup(number);
            this.groups.add(linkGroup);
        }
        return linkGroup;
    }

    @Override
    protected void layoutNodes(Dim dim) {
        List<Node> list = this.prepTree();
        this.placeTree(list);
        this.alignStackedGroups();
    }

    private void alignStackedGroups() {
        for (LinkGroup linkGroup : this.groups) {
            double d = Double.NaN;
            if (linkGroup.getGroupType() != null) {
                d = linkGroup.getGroupType().doubleValue();
            }
            if (LinkGroup.STACK_LAYOUT != d) continue;
            double d2 = linkGroup.getStackLayoutMaxLeafWidth(this.isHorizontalLayout);
            double d3 = this.getWidth(linkGroup.getRootNode());
            for (Link link : linkGroup.getLinks()) {
                Node node = link.getTo();
                double d4 = this.getWidth(node);
                double d5 = 0.0;
                d5 = linkGroup.isSoleStackedGroup() ? (d4 - d3) / 2.0 + 15.0 : (d4 - d2) / 2.0 + 15.0;
                this.nodeFaceAlignment.put(node, d5);
            }
        }
    }

    @Override
    protected void placeInExtent(Dim dim) {
        if (this.groups != null) {
            this.createInteriorPointsForGroups(dim);
        }
        this.refitInteriorPoints(dim);
        this.removeDummyNodes();
        this.removePrunedNodes();
    }

    private void removeDummyNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (this.nodes != null) {
            for (Node node : this.nodes) {
                if (node == null || node.isDummy()) continue;
                arrayList.add(node);
            }
            this.nodes = arrayList.toArray(new Node[arrayList.size()]);
        }
    }

    protected void refitInteriorPoints(Dim dim) {
        Range range = this.getAcrossRange(this.nodes);
        Range range2 = this.getDownRange(this.nodes);
        this.refitNodes(this.nodes, range, range2);
        SharedLayoutInfo sharedLayoutInfo = this.adapter.getSharedLayoutInfo();
        for (Link link : this.links) {
            Point[] pointArray = sharedLayoutInfo.getRoutingInfo(link.getFrom().getRow(), link.getTo().getRow());
            ArrayList<Point> arrayList = new ArrayList<Point>();
            for (Point point : pointArray) {
                double d = range.toZeroOne(point.getX());
                double d2 = range2.toZeroOne(point.getY());
                arrayList.add(new Point(d, d2));
            }
            sharedLayoutInfo.addRoutingInfo(link.getFrom().getRow(), link.getTo().getRow(), arrayList, null);
        }
    }

    protected List<Node> prepTree() {
        List<Node> list = this.findRoots();
        this.computeAndStoreMaxHeightByLevels(list);
        this.numLevels = this.maxHeightByLevel.size();
        return list;
    }

    protected void setIncrementLevelToRootNode() {
        if (this.groups != null) {
            ArrayList arrayList;
            block0: for (LinkGroup linkGroup : this.groups) {
                double d = Double.NaN;
                if (linkGroup.getGroupType() != null) {
                    d = linkGroup.getGroupType().doubleValue();
                }
                if (LinkGroup.OFFSET_LAYOUT != d) continue;
                Node node = linkGroup.getRootNode();
                arrayList = linkGroup.getLinks();
                if (arrayList == null) continue;
                int n = this.getMaxoffsetTreeHeight(node, arrayList);
                Object object = ((ArrayList[])node.getInfo())[0];
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Link link = (Link)iterator.next();
                    double d2 = Double.NaN;
                    if (link.getGroupType() != null) {
                        d2 = link.getGroupType().doubleValue();
                    }
                    if (LinkGroup.OFFSET_LAYOUT == d2 || node.increment >= n) continue;
                    node.increment = n;
                    continue block0;
                }
            }
            for (Node node : this.nodes) {
                if (!this.isOffsetRoot(node)) continue;
                int n = 0;
                arrayList = ((ArrayList[])node.getInfo())[0];
                for (Object object : arrayList) {
                    n = Math.max(n, ((Link)object).getTo().increment);
                }
                node.increment += n;
            }
        }
    }

    private int getMaxoffsetTreeHeight(Node node, List<Link> list) {
        if (node == null) {
            return 0;
        }
        int n = 0;
        if (list != null && list.size() > 0) {
            for (Link link : list) {
                n = Math.max(n, this.getHeightForTree(link.getTo()));
            }
        }
        return n;
    }

    private int getHeightForTree(Node node) {
        int n = 0;
        if (node != null) {
            ++n;
            int n2 = 0;
            List<Node> list = TreeLayout.getChildrenFromNodeInfo(node);
            for (Node node2 : list) {
                if (TreeLayout.isStacked(node, node2)) {
                    n2 = Math.max(n2, this.getStackedGroupHeight(node));
                    continue;
                }
                n2 = Math.max(n2, this.getHeightForTree(node2));
            }
            n += n2;
        }
        return n;
    }

    private int getStackedGroupHeight(Node node) {
        for (LinkGroup linkGroup : this.groups) {
            Node node2;
            double d = Double.NaN;
            if (linkGroup.getGroupType() != null) {
                d = linkGroup.getGroupType().doubleValue();
            }
            if (LinkGroup.STACK_LAYOUT != d || (node2 = linkGroup.getRootNode()) != node) continue;
            return linkGroup.getLinks().size();
        }
        return 0;
    }

    private static boolean isStacked(Node node, Node node2) {
        ArrayList arrayList = ((ArrayList[])node.getInfo())[0];
        if (arrayList != null) {
            for (Link link : arrayList) {
                double d = Double.NaN;
                if (link.getGroupType() != null) {
                    d = link.getGroupType().doubleValue();
                }
                if (link.getTo() != node2 || LinkGroup.STACK_LAYOUT != d) continue;
                return true;
            }
        }
        return false;
    }

    private List<Node> findRoots() {
        if (this.nodes == null || this.nodes.length == 0) {
            throw new EngineException("Cannot create a tree. No root nodes present.", ErrorCode.DATA_INVALID, null);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.nodes) {
            this.checkForCycle(node);
            if (node.inLink == null || node.inLink.length == 0) {
                arrayList.add(node);
                continue;
            }
            if (node.inLink.length <= 1) continue;
            throw new EngineException("Cannot create a tree. A tree cannot have a node with more than one parent node.", ErrorCode.DATA_INVALID, null);
        }
        for (Node node : this.nodes) {
            node.setInfo(null);
        }
        return arrayList;
    }

    protected void computeAndStoreMaxHeightByLevels(List<Node> list) {
        this.maxHeightByLevel = new ArrayList<Double>();
        this.setMaxHeightALevel(list, 0);
    }

    private void setMaxHeightALevel(List<Node> list, int n) {
        double d = Double.NEGATIVE_INFINITY;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : list) {
            double d2;
            Link[] linkArray = node.getOutLink();
            if (linkArray != null) {
                for (Link link : linkArray) {
                    arrayList.add(link.getTo());
                }
            }
            if (!((d2 = this.getHeight(node)) > d)) continue;
            d = d2;
        }
        this.maxHeightByLevel.add(n, d);
        if (arrayList.size() > 0) {
            this.setMaxHeightALevel(arrayList, n + 1);
        }
    }

    private double getHeightAtLevel(int n) {
        int n2 = n;
        double d = 0.0;
        --n2;
        while (n2 >= 0) {
            d += this.getMaximumNodeHeight(n2);
            d += this.getLevelGap();
            --n2;
        }
        return d;
    }

    protected void placeTree(List<Node> list) {
        this.setStackGroupNodeInfo();
        this.placeSiblings(list, 0, 0.0, TreeLayout.makePrimitiveDoubleArray(this.numLevels));
    }

    private void setStackGroupNodeInfo() {
        if (this.groups != null) {
            for (LinkGroup linkGroup : this.groups) {
                double d = Double.NaN;
                if (linkGroup.getGroupType() != null) {
                    d = linkGroup.getGroupType().doubleValue();
                }
                if (LinkGroup.STACK_LAYOUT != d) continue;
                Double d2 = linkGroup.getStackLayoutMaxLeafWidth(this.isHorizontalLayout);
                for (Link link : linkGroup.getLinks()) {
                    link.getTo().setInfo(d2);
                }
            }
        }
    }

    private void placeSiblings(List<Node> list, int n, double d, double[] dArray) {
        double d2 = d;
        Node node = null;
        for (Node node2 : list) {
            List<Node> list2 = TreeLayout.getChildren(node2);
            double d3 = this.getHeightAtLevel(n);
            double d4 = this.getStackAdjustedWidth(node2);
            if (node2.isNodePruned()) {
                if (node2.outLink != null && node2.outLink.length > 0) {
                    for (Link link : node2.outLink) {
                        link.setLinkPruned(true);
                    }
                }
                if (node2.inLink != null && node2.inLink.length > 0) {
                    for (Link link : node2.inLink) {
                        link.setLinkPruned(true);
                    }
                }
            }
            if (list2.size() > 0) {
                TreeLayout.placeNode(d2 += d4 / 2.0, d3, node2);
                this.placeSiblings(list2, n + 1, dArray[n + 1], dArray);
                Node node3 = TreeLayout.containsDummyNode(list2);
                if (node3 != null) {
                    double d5 = node3.getX() - node2.getX();
                    if (d5 > 0.0) {
                        TreeLayout.moveNode(node2, d5, 0.0);
                        d2 += d5;
                    } else {
                        this.moveNodes(list2, -d5, 0.0, dArray, n + 1);
                    }
                } else {
                    Range range = TreeLayout.getHorizontalRange(list2);
                    if (range.getMax() - d2 > range.getRange() / 2.0) {
                        double d6 = range.getMax() - d2 - range.getRange() / 2.0;
                        TreeLayout.moveNode(node2, d6, 0.0);
                        d2 += d6;
                    } else {
                        double d7 = d2 - range.getMin() - range.getRange() / 2.0;
                        this.moveNodes(list2, d7, 0.0, dArray, n + 1);
                    }
                }
                if (node != null && TreeLayout.getChildren(node).size() == 0 && this.isOffsetRoot(node2)) {
                    double d8 = this.getShiftValueForOffsetGroupSibling(node, node2, true);
                    TreeLayout.moveNode(node2, d8, 0.0);
                    this.moveNodes(list2, d8, 0.0, dArray, n + 1);
                    d2 += d8;
                }
                d2 += this.getLeafNodeGap();
                d2 += d4 / 2.0;
            } else {
                TreeLayout.placeNode(d2 += d4 / 2.0, d3, node2);
                if (node != null && TreeLayout.getChildren(node).size() > 0 && this.isOffsetRoot(node)) {
                    double d9 = this.getShiftValueForOffsetGroupSibling(node, node2, false);
                    TreeLayout.moveNode(node2, d9, 0.0);
                    d2 += d9;
                }
                d2 += d4 / 2.0;
                d2 += this.getLeafNodeGap();
            }
            node = node2;
        }
        dArray[n] = d2;
    }

    private double getShiftValueForOffsetGroupSibling(Node node, Node node2, boolean bl) {
        double d = 0.0;
        if (bl) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Link[] linkArray = node2.getOutLink();
            boolean bl2 = true;
            Number number = linkArray[0].getGroupId();
            for (Link link : linkArray) {
                if (link.getTo().isDummy()) {
                    bl2 = false;
                    continue;
                }
                if (!bl2 || link.getGroupId() == null || number == null || number.intValue() != link.getGroupId().intValue()) continue;
                arrayList.add(link.getTo());
            }
            Range range = TreeLayout.getHorizontalRange(arrayList);
            if (range != Range.ZERO && node.getX() + this.getWidth(node) / 2.0 >= range.getMin() + range.getRange() / 2.0) {
                d = node.getX() - (range.getMin() + range.getRange() / 2.0) + this.getWidth(node) / 2.0 + this.getLeafNodeGap();
            }
        } else {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Link[] linkArray = node.getOutLink();
            boolean bl3 = false;
            Number number = linkArray[linkArray.length - 1].getGroupId();
            for (Link link : linkArray) {
                if (link.getTo().isDummy()) {
                    bl3 = true;
                    continue;
                }
                if (!bl3 || link.getGroupId() == null || number == null || number.intValue() != link.getGroupId().intValue()) continue;
                arrayList.add(link.getTo());
            }
            Range range = TreeLayout.getHorizontalRange(arrayList);
            if (range != Range.ZERO && node.getX() - this.getWidth(node) / 2.0 <= range.getMin() + range.getRange() / 2.0) {
                d = range.getMin() + range.getRange() / 2.0 - node.getX() - this.getWidth(node) / 2.0;
            }
        }
        return d;
    }

    private boolean isOffsetRoot(Node node) {
        if (this.groups != null) {
            for (LinkGroup linkGroup : this.groups) {
                double d = Double.NaN;
                if (linkGroup.getGroupType() != null) {
                    d = linkGroup.getGroupType().doubleValue();
                }
                if (LinkGroup.OFFSET_LAYOUT != d || linkGroup.getRootNode() != node) continue;
                return true;
            }
        }
        return false;
    }

    private static Node containsDummyNode(List<Node> list) {
        for (Node node : list) {
            if (!node.isDummy()) continue;
            return node;
        }
        return null;
    }

    private void removePrunedNodes() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (this.nodes != null) {
            for (Node object : this.nodes) {
                if (object == null || object.isNodePruned()) continue;
                arrayList2.add(object);
            }
            this.nodes = arrayList2.toArray(new Node[arrayList2.size()]);
        }
        if (this.links != null) {
            for (Link link : this.links) {
                if (link.isLinkPruned()) continue;
                if (link.getFrom().isNodePruned() || link.getTo().isNodePruned()) {
                    link.setLinkPruned(true);
                    continue;
                }
                arrayList.add(link);
            }
            this.links = arrayList.toArray(new Link[arrayList.size()]);
        }
    }

    private void moveNodes(List<Node> list, double d, double d2, double[] dArray, int n) {
        double d3;
        double d4;
        Object object = list.iterator();
        while (object.hasNext()) {
            Node node = object.next();
            TreeLayout.moveNode(node, d, d2);
            List<Node> list2 = TreeLayout.getChildren(node);
            this.moveNodes(list2, d, d2, dArray, n + 1);
        }
        if (list.size() > 0 && (d4 = ((Node)(object = list.get(list.size() - 1))).getX() + this.getStackAdjustedWidth((Node)object) / 2.0 + this.getLeafNodeGap()) > (d3 = dArray[n])) {
            dArray[n] = d4;
        }
    }

    private static void moveNode(Node node, double d, double d2) {
        node.moveBy(d, d2);
    }

    private static void placeNode(double d, double d2, Node node) {
        node.moveTo(d, d2);
    }

    private static Range getHorizontalRange(List<Node> list) {
        if (list == null || list.size() == 0) {
            return Range.ZERO;
        }
        return new Range(list.get(0).getX(), list.get(list.size() - 1).getX());
    }

    protected double getLeafNodeGap() {
        return this.leafNodeGap;
    }

    protected static double computeLeafNodeGap(StyleSpec styleSpec) {
        if (styleSpec != null) {
            Insets insets = Insets.makeForStyle(styleSpec, EXTENT_FOR_CALCULATING_GAPS);
            return insets.getHorizontal();
        }
        return 0.0;
    }

    protected double getLevelGap() {
        return this.levelGap;
    }

    protected static double computeLevelGap(StyleSpec styleSpec) {
        if (styleSpec != null) {
            Insets insets = Insets.makeForStyle(styleSpec, EXTENT_FOR_CALCULATING_GAPS);
            return insets.getVertical();
        }
        return 0.0;
    }

    protected double getStackAdjustedWidth(Node node) {
        if (node.getInfo() != null && BasicFactory.isNumber(node.getInfo())) {
            return ((Number)node.getInfo()).doubleValue();
        }
        return this.getWidth(node);
    }

    private double getWidth(Node node) {
        if (node.isDummy()) {
            Dim dim = this.adapter.getElementSize();
            if (this.isHorizontal()) {
                return dim.getHeight();
            }
            return dim.getWidth();
        }
        Shape shape = node.getShape();
        if (shape == null) {
            return 0.0;
        }
        if (this.isHorizontal()) {
            return shape.getBounds().getHeight();
        }
        return shape.getBounds().getWidth();
    }

    private double getHeight(Node node) {
        Shape shape = node.getShape();
        if (shape == null) {
            return 0.0;
        }
        if (this.isHorizontal()) {
            return shape.getBounds().getWidth();
        }
        return shape.getBounds().getHeight();
    }

    @Override
    public Dim getPreferredSize(int n) {
        if (this.getPrefSize() == null) {
            this.makeNodesAndLinks(n);
            this.setShapesToNodes(EXTENT_FOR_PREF_SIZE);
            List<Node> list = this.prepTree();
            this.placeTree(list);
            double d = this.getPreferredAcrossRange(this.nodes).getRange();
            double d2 = this.getPreferredDownRange(this.nodes).getRange();
            Dim dim = new Dim(d, d2);
            if (this.isHorizontal()) {
                dim = new Dim(dim.getHeight(), dim.getWidth());
            }
            this.setPrefSize(dim);
        }
        return this.getPrefSize();
    }

    private Range getPreferredAcrossRange(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return Range.EMPTY;
        }
        Range range = null;
        for (Node node : nodeArray) {
            double d;
            double d2 = d = node.getShape() != null ? node.getShape().getBounds().getWidth() : 0.0;
            if (range == null) {
                range = new MutableRange(0.0, node.getX() + this.getStackAdjustedWidth(node) / 2.0 + d);
                continue;
            }
            range.unionValue(node.getX() + this.getStackAdjustedWidth(node) / 2.0 + d);
        }
        return range;
    }

    private Range getPreferredDownRange(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return Range.EMPTY;
        }
        Range range = null;
        for (Node node : nodeArray) {
            double d;
            double d2 = d = node.getShape() != null ? node.getShape().getBounds().getHeight() : 0.0;
            if (range == null) {
                range = new MutableRange(0.0, node.getY() + this.getHeight(node) / 2.0 + d);
                continue;
            }
            range.unionValue(node.getY() + this.getHeight(node) / 2.0 + d);
        }
        double d = this.getMaximumNodeHeight(this.numLevels - 1) / 2.0;
        return new Range(range.getMin(), range.getMax() + d);
    }

    protected static double[] makePrimitiveDoubleArray(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 0.0;
        }
        return dArray;
    }

    private static List<Node> getChildren(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Link[] linkArray = node.getOutLink();
        if (linkArray != null) {
            for (Link link : linkArray) {
                arrayList.add(link.getTo());
            }
        }
        return arrayList;
    }

    private static List<Node> getChildrenFromNodeInfo(Node node) {
        ArrayList arrayList;
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        if (node.getInfo() != null && (arrayList = ((ArrayList[])node.getInfo())[0]) != null) {
            for (Link link : arrayList) {
                arrayList2.add(link.getTo());
            }
        }
        return arrayList2;
    }

    @Override
    protected void refitNodes(Node[] nodeArray, Range range, Range range2) {
        if (nodeArray == null || range == null || range2 == null) {
            return;
        }
        for (Node node : nodeArray) {
            node.setX(range.toZeroOne(node.getX()));
            node.setY(range2.toZeroOne(node.getY()));
        }
    }

    protected boolean isNodePositioned(Node node) {
        return node != null && node.positionSpecified();
    }

    @Override
    protected void applyBoundedAffineTransform(Shape shape, double d, double d2, double d3, double d4, Rect rect, Node node) {
        if (this.isNodePositioned(node) || this.isMirror()) {
            d4 = 1.0 - d4;
        }
        double d5 = 0.0;
        if (node != null && this.nodeFaceAlignment.containsKey(node)) {
            d5 = this.nodeFaceAlignment.get(node);
        }
        if (this.isHorizontal()) {
            double d6;
            shape.affine(d, -shape.getBounds().getX(), d3, -shape.getBounds().getY(), false);
            double d7 = d6 = this.isNodePositioned(node) ? rect.getX() + d2 * rect.getWidth() : rect.getX() + d4 * rect.getWidth();
            if (this.isNodePositioned(node)) {
                d6 -= shape.getBounds().getWidth() / 2.0;
            } else if (this.isMirror()) {
                d6 -= shape.getBounds().getWidth();
            }
            double d8 = this.isNodePositioned(node) ? rect.getY() + d4 * rect.getHeight() - shape.getBounds().getHeight() / 2.0 + d5 : rect.getY() + d2 * rect.getHeight() - shape.getBounds().getHeight() / 2.0 + d5;
            shape.affine(d, d6, d3, d8, false);
        } else {
            double d9 = rect.getX() + d2 * rect.getWidth() + d5;
            double d10 = rect.getY() + d4 * rect.getHeight() - shape.getBounds().getY();
            if (this.isNodePositioned(node)) {
                d10 -= shape.getBounds().getHeight() / 2.0;
            } else if (this.isMirror()) {
                d10 -= shape.getBounds().getHeight();
            }
            shape.affine(d, d9, d3, d10, false);
        }
    }

    @Override
    public boolean respectsTransforms() {
        return false;
    }

    @Override
    protected Range getAcrossRange(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return Range.EMPTY;
        }
        Range range = null;
        for (Node node : nodeArray) {
            if (range == null) {
                range = new MutableRange(0.0, node.getX() + this.getStackAdjustedWidth(node) / 2.0);
                continue;
            }
            range.unionValue(node.getX() + this.getStackAdjustedWidth(node) / 2.0);
        }
        return range;
    }

    @Override
    protected Range getDownRange(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return Range.EMPTY;
        }
        Range range = null;
        for (Node node : nodeArray) {
            if (range == null) {
                range = new MutableRange(0.0, node.getY() + this.getHeight(node) / 2.0);
                continue;
            }
            range.unionValue(node.getY() + this.getHeight(node) / 2.0);
        }
        double d = this.getMaximumNodeHeight(this.numLevels - 1) / 2.0;
        return new Range(range.getMin(), range.getMax() + d);
    }

    protected boolean isMirror() {
        return "right-to-left".equals(this.orientation) || "bottom-to-top".equals(this.orientation);
    }

    protected boolean isHorizontal() {
        return this.isHorizontalLayout;
    }

    protected double getMaximumNodeHeight(int n) {
        if (n > this.maxHeightByLevel.size()) {
            return 0.0;
        }
        Double d = this.maxHeightByLevel.get(n);
        return d;
    }

    @Override
    protected void restoreLinkData() {
        if (this.groups != null) {
            for (LinkGroup linkGroup : this.groups) {
                double d = Double.NaN;
                if (linkGroup == null) continue;
                if (linkGroup.getGroupType() != null) {
                    d = linkGroup.getGroupType().doubleValue();
                }
                if (LinkGroup.STACK_LAYOUT != d) continue;
                Node node = linkGroup.getRootNode();
                Node node2 = null;
                List<Node> list = TreeLayout.getDummyNodes(node);
                if (list.size() > 0) {
                    node = node2 = list.get(list.size() - 1);
                }
                if (node == null) {
                    return;
                }
                List<Link> list2 = linkGroup.getLinks();
                Link[] linkArray = TreeLayout.containsDummyNode(TreeLayout.getChildren(node)) != null ? new Link[list2.size() + node.outLink.length] : new Link[list2.size() + node.outLink.length - 1];
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                for (n = 0; !(n >= node.outLink.length || node.outLink[n].getGroupId() != null && node.outLink[n].getGroupId().equals(linkGroup.getGroupId())); ++n) {
                    linkArray[n] = node.outLink[n];
                }
                n2 = 0;
                n3 = n;
                while (n2 < list2.size()) {
                    Link link = new Link(node, list2.get(n2).getTo());
                    link.copyInfoFrom(list2.get(n2));
                    link.setGroupId(linkGroup.getGroupId());
                    link.setGroupType(LinkGroup.STACK_LAYOUT);
                    list2.get(n2).getTo().setInLink(new Link[]{link});
                    list2.get(n2).getTo().setOutLink(new Link[0]);
                    linkArray[n3] = link;
                    for (int i = 0; i < this.links.length; ++i) {
                        if (this.links[i].getRow() != list2.get(n2).getRow()) continue;
                        this.links[i] = list2.get(n2);
                        break;
                    }
                    ++n2;
                    ++n3;
                }
                n2 = n + 1;
                while (n2 < node.outLink.length) {
                    linkArray[n3] = node.outLink[n2];
                    ++n2;
                    ++n3;
                }
                node.setOutLink(linkArray);
            }
        }
    }

    protected void createInteriorPointsForGroups(Dim dim) {
        Point[] pointArray = null;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (LinkGroup linkGroup : this.groups) {
            double d = Double.NaN;
            if (linkGroup == null) continue;
            if (linkGroup.getGroupType() != null) {
                d = linkGroup.getGroupType().doubleValue();
            }
            if (LinkGroup.OFFSET_LAYOUT != d || !TreeLayout.hasDummyLeafNode(linkGroup.getRootNode().getOutLink()) || arrayList.contains(linkGroup.getRootNode())) continue;
            this.createInteriorPointsForDummyNodes(linkGroup);
            arrayList.add(linkGroup.getRootNode());
        }
        for (LinkGroup linkGroup : this.groups) {
            if (linkGroup == null) continue;
            List<Link> list = null;
            list = linkGroup.getLinks();
            boolean bl = linkGroup.isSoleStackedGroup();
            for (int i = 0; i < list.size(); ++i) {
                Link link = list.get(i);
                Node node = link.getFrom();
                Node node2 = link.getTo();
                Point[] pointArray2 = this.adapter.getSharedLayoutInfo().getRoutingInfo(node.getRow(), node2.getRow());
                if (bl) {
                    pointArray2 = this.translateExistingInteriorPoints(pointArray2, linkGroup, dim);
                }
                ArrayList<Point> arrayList2 = new ArrayList<Point>();
                for (int j = 0; j < pointArray2.length; ++j) {
                    arrayList2.add(pointArray2[j]);
                }
                pointArray = this.computeInteriorPoints(link, linkGroup, arrayList2, dim);
                if (pointArray[0] != null) {
                    arrayList2.add(pointArray[0]);
                }
                if (pointArray[1] != null) {
                    arrayList2.add(pointArray[1]);
                }
                this.adapter.getSharedLayoutInfo().addRoutingInfo(node.getRow(), node2.getRow(), arrayList2, linkGroup.getGroupType());
                this.adapter.getSharedLayoutInfo().addSpecialStackGroupInfo(node.getRow(), node2.getRow(), bl);
            }
        }
    }

    private Point[] translateExistingInteriorPoints(Point[] pointArray, LinkGroup linkGroup, Dim dim) {
        double d = 10.0 - this.getWidth(linkGroup.getRootNode()) / 2.0;
        d = this.adapter.isSwapXY() ? d * this.getAcrossRange(this.nodes).getRange() / dim.getHeight() : d * this.getAcrossRange(this.nodes).getRange() / dim.getWidth();
        double d2 = linkGroup.getRootNode().getX() + d;
        for (int i = 0; i < pointArray.length; ++i) {
            pointArray[i].setX(d2);
        }
        return pointArray;
    }

    protected Point[] computeInteriorPoints(Link link, LinkGroup linkGroup, List<Point> list, Dim dim) {
        Number number = linkGroup.getGroupType();
        Point[] pointArray = new Point[2];
        Range range = this.getDownRange(this.nodes);
        double d = link.getFrom().getY() + link.getFrom().getNodeHeight(range.getRange());
        if (list != null && list.size() > 0) {
            d = this.swapYAsNeeded(range, list.get(0).getY());
        }
        double d2 = Double.NaN;
        if (number != null) {
            d2 = number.doubleValue();
        }
        if (LinkGroup.NORMAL_LAYOUT == d2 || LinkGroup.OFFSET_LAYOUT == d2) {
            Range range2 = linkGroup.getAcrossRange(this.isHorizontalLayout);
            double d3 = 0.0;
            double d4 = 0.0;
            d3 = range2.getMin() + range2.getRange() * 0.5;
            d4 = d + 0.625 * (link.getTo().getY() - d);
            d4 = this.swapYAsNeeded(range, d4);
            pointArray[0] = new Point(d3, d4);
            pointArray[1] = null;
        } else if (LinkGroup.STACK_LAYOUT == d2) {
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            Range range3 = linkGroup.getAcrossRange(this.isHorizontalLayout);
            if (linkGroup.isSoleStackedGroup()) {
                double d9 = 10.0 - this.getWidth(linkGroup.getRootNode()) / 2.0;
                d9 = this.adapter.isSwapXY() ? d9 * this.getAcrossRange(this.nodes).getRange() / dim.getHeight() : d9 * this.getAcrossRange(this.nodes).getRange() / dim.getWidth();
                d5 = linkGroup.getRootNode().getX() + d9;
            } else {
                d5 = range3.getMin() - 5.0;
            }
            d7 = d5;
            d6 = linkGroup.getLinks().get(0).getTo().getY();
            d8 = link.getTo().getY();
            d8 += link.getTo().getNodeHeight(range.getRange()) * 0.5;
            d6 = this.swapYAsNeeded(range, d6);
            d8 = this.swapYAsNeeded(range, d8);
            pointArray[0] = new Point(d5, d6);
            pointArray[1] = new Point(d7, d8);
        }
        return pointArray;
    }

    private double swapYAsNeeded(Range range, double d) {
        double d2 = d;
        if (this.adapter.isSwapXY()) {
            if (this.adapter.isReflectY()) {
                d2 = range.getMax() - d;
            }
        } else if (!this.adapter.isReflectY()) {
            d2 = range.getMax() - d;
        }
        return d2;
    }

    void createInteriorPointsForDummyNodes(LinkGroup linkGroup) {
        Node node = linkGroup.getRootNode();
        List<Node> list = TreeLayout.getDummyNodes(node);
        Node node2 = list.get(list.size() - 1);
        List<Node> list2 = TreeLayout.getChildren(node2);
        double d = 0.0;
        double d2 = 0.0;
        Range range = this.getDownRange(this.nodes);
        d = node.getX();
        Node node3 = node;
        Double d3 = null;
        for (Node node4 : list2) {
            Point point;
            Node node5;
            ArrayList<Point> arrayList;
            double d4 = Double.NaN;
            if (node4.getInLink()[0].getGroupType() != null) {
                d4 = node4.getInLink()[0].getGroupType().doubleValue();
            }
            if (d3 != null && LinkGroup.STACK_LAYOUT == d4) {
                arrayList = new ArrayList();
                node5 = node4;
                d2 = d3;
                point = new Point(d, d2);
                arrayList.add(point);
                this.adapter.getSharedLayoutInfo().addRoutingInfo(node3.getRow(), node5.getRow(), arrayList, null);
                continue;
            }
            arrayList = new ArrayList<Point>();
            node5 = node4;
            d2 = node2.getY() + 0.625 * (node5.getY() - node2.getY());
            d2 = this.swapYAsNeeded(range, d2);
            point = new Point(d, d2);
            arrayList.add(point);
            Number number = node4.getInLink()[0].getGroupType();
            if (number == null) {
                this.adapter.getSharedLayoutInfo().addRoutingInfo(node3.getRow(), node5.getRow(), arrayList, LinkGroup.DUMMY_LAYOUT);
            } else {
                this.adapter.getSharedLayoutInfo().addRoutingInfo(node3.getRow(), node5.getRow(), arrayList, number);
            }
            if (d3 != null || LinkGroup.STACK_LAYOUT != d4) continue;
            d3 = d2;
        }
    }

    public static List<Node> getDummyNodes(Node node) {
        Node node2;
        Link[] linkArray = node.getOutLink();
        Link link = null;
        for (int i = 0; i < linkArray.length; ++i) {
            node2 = linkArray[i].getTo();
            if (!node2.isDummy()) continue;
            link = linkArray[i];
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        while (link != null && link.getTo().isDummy()) {
            node2 = link.getTo();
            arrayList.add(node2);
            if (node2.getOutLink().length <= 0) break;
            link = node2.getOutLink()[0];
        }
        return arrayList;
    }

    private static boolean hasDummyLeafNode(Link[] linkArray) {
        for (int i = 0; i < linkArray.length; ++i) {
            if (!linkArray[i].getTo().isDummy()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setupNodeLayering(Dim dim) {
    }
}

