/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress;

import com.ibm.vis.engine.internal.grammar.layout.BubbleLayout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.AbstractGraphLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.LiteGraph;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ComponentSplitting {
    final Node[] nodes;
    final LiteGraph[] components;

    public static ComponentSplitting fromLayout(AbstractGraphLayout abstractGraphLayout) {
        return new ComponentSplitting(abstractGraphLayout.getNodes(), abstractGraphLayout.getLinks());
    }

    public static ComponentSplitting fromLiteGraph(LiteGraph liteGraph) {
        Node[] nodeArray = liteGraph.getNodes().toArray(new Node[liteGraph.getNodes().size()]);
        Link[] linkArray = liteGraph.getLinks().toArray(new Link[liteGraph.getLinks().size()]);
        return new ComponentSplitting(nodeArray, linkArray);
    }

    ComponentSplitting(Node[] nodeArray, Link[] linkArray) {
        int n;
        this.nodes = nodeArray;
        int n2 = this.markNodesWithComponent();
        this.components = new LiteGraph[n2];
        for (int i = 0; i < n2; ++i) {
            this.components[i] = new LiteGraph(null, null);
        }
        for (Node object : nodeArray) {
            n = (Integer)object.getInfo();
            this.components[n].addNode(object);
        }
        for (Link link : linkArray) {
            n = (Integer)link.getFrom().getInfo();
            this.components[n].addLink(link);
        }
    }

    public final LiteGraph[] getComponents() {
        return this.components;
    }

    public void combine(LayoutAdapter layoutAdapter, Dim dim, double d) {
        if (this.components.length < 2) {
            return;
        }
        Shape[] shapeArray = new Shape[this.components.length];
        double[] dArray = new double[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            shapeArray[i] = this.getSpanningCircle(this.components[i], dim);
            dArray[i] = ((Circle)shapeArray[i].getGeom()).getR() + d / 2.0;
        }
        BubbleLayout bubbleLayout = new BubbleLayout(layoutAdapter, true);
        Point[] pointArray = bubbleLayout.placeSimpleCircles(dArray, dim);
        for (int i = 0; i < this.components.length; ++i) {
            double d2 = pointArray[i].getX() - shapeArray[i].getX();
            double d3 = pointArray[i].getY() - shapeArray[i].getY();
            for (Node node : this.components[i].getNodes()) {
                node.moveBy(d2, d3);
            }
        }
    }

    public Shape getSpanningCircle(LiteGraph liteGraph, Dim dim) {
        double d = 0.0;
        double d2 = 0.0;
        for (Node node : liteGraph.getNodes()) {
            d += node.getCurrentBounds().getCenterX();
            d2 += node.getCurrentBounds().getCenterY();
        }
        Point point = new Point(d / (double)liteGraph.getNodesCount(), d2 / (double)liteGraph.getNodesCount());
        double d3 = this.getFurthest(point, liteGraph.getNodes(), dim);
        return ShapeFactory2.CreateCircle(point.getX(), point.getY(), d3);
    }

    public double getFurthest(Point point, List<Node> list, Dim dim) {
        double d = 0.0;
        for (Node node : list) {
            Point point2 = new Point(node.getX(), node.getY());
            Rect rect = node.getCurrentBounds();
            double d2 = point.distance(point2) + Math.sqrt(Math.pow(rect.getWidth(), 2.0) + Math.pow(rect.getHeight(), 2.0)) / 2.0;
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private int markNodesWithComponent() {
        for (Node node : this.nodes) {
            node.setInfo(null);
        }
        int n = 0;
        for (Node node : this.nodes) {
            if (node.getInfo() != null) continue;
            this.markConnected(node, n);
            ++n;
        }
        return n;
    }

    private void markConnected(Node node, int n) {
        node.setInfo(n);
        for (Node node2 : node.getNeighbors()) {
            if (node2.getInfo() != null) continue;
            this.markConnected(node2, n);
        }
    }
}

