/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress;

import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GroupedNode
extends Node {
    private final List<Node> children = new ArrayList<Node>();

    public GroupedNode(int n) {
        super(n);
        this.inLink = new Link[0];
        this.outLink = new Link[0];
    }

    public void addChild(Node node) {
        this.children.add(node);
        node.setParent(this);
        Rect rect = node.getCurrentBounds();
        this.realWidth += rect.getWidth();
        this.realHeight += rect.getHeight();
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Node getChild(int n) {
        return this.children.get(n);
    }

    public void addOutEdge(Link link) {
        Link[] linkArray = new Link[this.outLink.length + 1];
        for (int i = 0; i < this.outLink.length; ++i) {
            linkArray[i] = this.outLink[i];
        }
        linkArray[this.outLink.length] = link;
        this.outLink = linkArray;
        this.links = null;
        this.neighbors = null;
    }

    public void addInEdge(Link link) {
        Link[] linkArray = new Link[this.inLink.length + 1];
        for (int i = 0; i < this.inLink.length; ++i) {
            linkArray[i] = this.inLink[i];
        }
        linkArray[this.inLink.length] = link;
        this.inLink = linkArray;
        this.links = null;
        this.neighbors = null;
    }
}

