/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress;

import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class LiteGraph {
    private final List<Node> nodes = new ArrayList<Node>();
    private final List<Link> links = new ArrayList<Link>();

    public LiteGraph(Node[] nodeArray, Link[] linkArray) {
        if (nodeArray != null) {
            for (Node object : nodeArray) {
                this.nodes.add(object);
            }
        }
        if (linkArray != null) {
            for (Link link : linkArray) {
                this.links.add(link);
            }
        }
    }

    public final int getLinksCount() {
        return this.links.size();
    }

    public final int getNodesCount() {
        return this.nodes.size();
    }

    public final List<Link> getLinks() {
        return this.links;
    }

    public final List<Node> getNodes() {
        return this.nodes;
    }

    public final void addNode(Node node) {
        this.nodes.add(node);
    }

    public final void addLink(Link link) {
        this.links.add(link);
    }

    public Link getLinkBetween(Node node, Node node2) {
        for (Link link : node.getLinks()) {
            if (link.getOpposite(node) != node2) continue;
            return link;
        }
        return null;
    }

    public void attachLinksToNodes() {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        for (Node object : this.nodes) {
            hashMap.put(object, new ArrayList());
            hashMap2.put(object, new ArrayList());
        }
        for (Link link : this.links) {
            ((ArrayList)hashMap.get(link.getTo())).add(link);
            ((ArrayList)hashMap2.get(link.getFrom())).add(link);
        }
        for (Node node : this.nodes) {
            ArrayList arrayList = (ArrayList)hashMap.get(node);
            ArrayList arrayList2 = (ArrayList)hashMap2.get(node);
            node.setInLink(arrayList.toArray(new Link[arrayList.size()]));
            node.setOutLink(arrayList2.toArray(new Link[arrayList2.size()]));
        }
    }
}

