/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress;

import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.LiteGraph;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.StressLayout;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class MultiLevelUncoarsener {
    private List<LiteGraph> graphs;
    private StressLayout layout;
    private static final double OFFSET_RADIUS = (double)0.1f;
    private Dim extent;

    public MultiLevelUncoarsener(StressLayout stressLayout, List<LiteGraph> list, Dim dim) {
        this.graphs = list;
        this.layout = stressLayout;
        this.extent = dim;
    }

    public void run() {
        while (this.graphs.size() > 0) {
            LiteGraph liteGraph = this.graphs.get(this.graphs.size() - 1);
            this.graphs.remove(liteGraph);
            StressLayout stressLayout = this.layout.copy(liteGraph.getNodes(), liteGraph.getLinks(), this.graphs.size(), false);
            stressLayout.doLayout(this.extent);
            if (this.graphs.size() <= 0) continue;
            this.projectPositionsToChildren(this.graphs.get(this.graphs.size() - 1));
        }
    }

    private void projectPositionsToChildren(LiteGraph liteGraph) {
        double d = Math.PI * 2 / (double)liteGraph.getNodesCount();
        int n = 0;
        for (Node node : liteGraph.getNodes()) {
            Node node2 = node.getParent();
            if (node2 == null) continue;
            double d2 = node2.getX();
            double d3 = node2.getY();
            int n2 = 1;
            for (Link link : node.getLinks()) {
                Node node3 = link.getOpposite(node);
                Node node4 = node3.getParent();
                d2 += node4.getX();
                d3 += node4.getY();
                ++n2;
            }
            double d4 = (double)n * d;
            n = (n + 37) % liteGraph.getNodesCount();
            node.moveTo((d2 /= (double)n2) + (double)0.1f * Math.cos(d4), (d3 /= (double)n2) + (double)0.1f * Math.sin(d4));
        }
    }
}

