/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress;

import com.ibm.vis.engine.internal.grammar.layout.graph.AbstractGraphLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.GroupedNode;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.LiteGraph;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class MultilevelCoarsener {
    private final List<LiteGraph> graphs;
    private final AbstractGraphLayout model;

    public MultilevelCoarsener(AbstractGraphLayout abstractGraphLayout) {
        this.model = abstractGraphLayout;
        this.graphs = new ArrayList<LiteGraph>();
        this.graphs.add(new LiteGraph(abstractGraphLayout.getNodes(), abstractGraphLayout.getLinks()));
    }

    public List<LiteGraph> run(int n) {
        int n2 = this.peekTopGraph().getNodesCount();
        while (n2 > n) {
            this.coarsen(this.peekTopGraph());
            float f = (float)n2 / (float)this.peekTopGraph().getNodesCount();
            if ((double)f < 1.1) {
                this.graphs.remove(this.graphs.size() - 1);
                break;
            }
            n2 = this.peekTopGraph().getNodesCount();
        }
        return this.graphs;
    }

    private void coarsen(LiteGraph liteGraph) {
        LiteGraph liteGraph2 = this.createNodeMatching(liteGraph);
        this.graphs.add(liteGraph2);
    }

    private final LiteGraph peekTopGraph() {
        return this.graphs.get(this.graphs.size() - 1);
    }

    private void placeInCenterOfChildren(GroupedNode groupedNode) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < groupedNode.getChildCount(); ++i) {
            Rect rect = groupedNode.getChild(i).getCurrentBounds();
            d += rect.getCenterX();
            d2 += rect.getCenterY();
        }
        groupedNode.moveTo(d / (double)groupedNode.getChildCount(), d2 / (double)groupedNode.getChildCount());
    }

    /*
     * WARNING - void declaration
     */
    private LiteGraph createNodeMatching(LiteGraph liteGraph) {
        Object object;
        if (liteGraph.getLinksCount() == 0) {
            return liteGraph;
        }
        HashMap hashMap = new HashMap();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        LiteGraph liteGraph2 = new LiteGraph(null, null);
        for (Node object2 : liteGraph.getNodes()) {
            hashMap.put(object2, null);
            arrayList.add(object2);
        }
        int n = 0;
        while (arrayList.size() > 0) {
            void var7_11;
            Node node = (Node)arrayList.get(arrayList.size() - 1);
            Object var7_12 = null;
            double d = Double.MAX_VALUE;
            for (Link link : node.getLinks()) {
                Node node2 = link.getOpposite(node);
                if (!hashMap.containsKey(node2) || !((double)node2.getWeight() < d)) continue;
                Node node3 = node2;
                d = node2.getWeight();
            }
            object = new GroupedNode(--n);
            ((Node)object).setOrientation(this.model.getAdapter().isSwapXY(), this.model.getAdapter().isReflectY());
            liteGraph2.addNode((Node)object);
            ((GroupedNode)object).addChild(node);
            ((Node)object).setWeight(node.getWeight() + (var7_11 == null ? 0 : var7_11.getWeight()));
            arrayList.remove(node);
            hashMap.remove(node);
            if (var7_11 != null) {
                ((GroupedNode)object).addChild((Node)var7_11);
                arrayList.remove(var7_11);
                hashMap.remove(var7_11);
            }
            this.placeInCenterOfChildren((GroupedNode)object);
        }
        for (Link link : liteGraph.getLinks()) {
            GroupedNode groupedNode;
            GroupedNode groupedNode2 = (GroupedNode)link.getFrom().getParent();
            if (groupedNode2 == (groupedNode = (GroupedNode)link.getTo().getParent())) continue;
            object = liteGraph2.getLinkBetween(groupedNode2, groupedNode);
            if (object == null) {
                Link link2 = new Link(groupedNode2, groupedNode);
                link2.setWeight(link.getWeight());
                groupedNode2.addOutEdge(link2);
                groupedNode.addInEdge(link2);
                liteGraph2.addLink(link2);
                continue;
            }
            ((Link)object).setWeight(((Link)object).getWeight() + link.getWeight());
        }
        return liteGraph2;
    }
}

