/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.ShapeList;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.AbstractGraphLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.Crossings;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.ComponentSplitting;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.LiteGraph;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.MultiLevelUncoarsener;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.MultilevelCoarsener;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.StressMajorizer;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.distance.BFSDistance;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.distance.Dijkstra;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.FullMatrix;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.Matrix;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.util.DepthAssignation;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.util.ExtractTree;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.util.OverlapRemoval;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.LayoutSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/graphLayoutsLayer")
public class StressLayout
extends AbstractGraphLayout {
    private static final int sparseOptimizationAtNodeCount = 150;
    private static final int min_pivots = 20;
    private static final int max_pivots = 100;
    private int close_hop_max = 1;
    private boolean respect_node_size = false;
    private static final boolean allow_sparse_optimization = true;
    private boolean splitComponents = true;
    private boolean multiLevel = false;
    private int max_iterations = 500;
    private Matrix distances;
    private StressMajorizer stressMajorizer;
    private Map<Node, Object> pivotSet;
    protected double preferred_edge_length;

    public StressLayout(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
        LayoutSpec layoutSpec = layoutAdapter.getSpec();
        if (layoutSpec != null) {
            if (layoutSpec.incrementalNetworkLayout != null) {
                this.multiLevel = layoutSpec.incrementalNetworkLayout;
            }
            if (layoutSpec.respectNodeSize != null) {
                this.respect_node_size = layoutSpec.respectNodeSize;
            }
            if (layoutSpec.neighbourDetails != null) {
                this.close_hop_max = layoutSpec.neighbourDetails.intValue();
            }
        }
    }

    public StressLayout copy(List<Node> list, List<Link> list2, int n, boolean bl) {
        StressLayout stressLayout = new StressLayout(this.adapter);
        stressLayout.nodes = list.toArray(new Node[list.size()]);
        stressLayout.links = list2.toArray(new Link[list2.size()]);
        stressLayout.multiLevel = bl;
        stressLayout.splitComponents = false;
        stressLayout.max_iterations = list.size() < 150 ? this.max_iterations : 20;
        stressLayout.preferred_edge_length = this.preferred_edge_length * (double)((float)Math.pow(2.0, n));
        return stressLayout;
    }

    private void info(String string) {
        this.adapter.logInfo("Stress Layout: " + string, null, null);
    }

    private void detail(String string, String string2, Object object) {
        this.adapter.logDetail("Stress Layout: " + string, string2, object);
    }

    @Override
    public void layoutNodes(Dim dim) {
        Object object;
        Object object2;
        this.info("Laying out nodes using Stress Layout Algorithm");
        Dim dim2 = this.adapter.getElementSize();
        this.preferred_edge_length = Math.max(1.0, dim2.getMin());
        this.detail("Choosing link size", "preferred_edge_length", this.preferred_edge_length);
        if (this.splitComponents && ((LiteGraph[])(object2 = ((ComponentSplitting)(object = ComponentSplitting.fromLayout(this))).getComponents())).length > 1) {
            this.detail("Splitting Graph into Components", "# components", ((LiteGraph[])object2).length);
            for (LiteGraph liteGraph : object2) {
                StressLayout stressLayout = this.copy(liteGraph.getNodes(), liteGraph.getLinks(), this.close_hop_max, this.multiLevel);
                stressLayout.layoutNodes(dim);
            }
            ((ComponentSplitting)object).combine(this.adapter, dim, this.preferred_edge_length);
            return;
        }
        this.detail("Graph size", "# nodes", this.getNodesCount());
        this.detail("Graph size", "# edges", this.getLinksCount());
        if (this.getNodesCount() > 8) {
            this.initialPlacementUsingTree();
        } else {
            this.initialPlacementUsingCircle();
        }
        if (this.getNodesCount() < 2) {
            return;
        }
        object = null;
        object2 = null;
        for (Node node : this.nodes) {
            if (object == null) {
                object = new Range(node.getX(), node.getX());
                object2 = new Range(node.getY(), node.getY());
                continue;
            }
            object = ((Range)object).unionValue(node.getX());
            object2 = ((Range)object2).unionValue(node.getY());
        }
        Range range = new Range(0.0, dim.getWidth());
        Range range2 = new Range(0.0, dim.getHeight());
        for (Node node : this.nodes) {
            node.setX(range.fromZeroOne(((Range)object).toZeroOne(node.getX())));
            node.setY(range2.fromZeroOne(((Range)object2).toZeroOne(node.getY())));
        }
        if (this.multiLevel) {
            this.initialize();
            this.doMultiLevelLayout(dim);
        } else {
            this.doLayout(dim);
        }
    }

    @Override
    protected void translateShapes(ShapeList shapeList, Rect rect) {
        boolean bl;
        List<Shape> list = shapeList.getAllShapes();
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl2 = bl = this.getAdapter().getSpec().preserveAspectRatio != false || this.getAdapter().getSpec().size != null;
        if (!bl && this.adapter.getSpec().orientation == null) {
            d = rect.getWidth() > rect.getHeight() * 1.25 ? rect.getWidth() / rect.getHeight() : 1.0;
            d2 = rect.getHeight() > rect.getWidth() * 1.25 ? rect.getHeight() / rect.getWidth() : 1.0;
            d3 = d > 1.0 ? -rect.getWidth() * (d - 1.0) * 0.5 : 0.0;
            d4 = d2 > 1.0 ? -rect.getHeight() * (d2 - 1.0) * 0.5 : 0.0;
        }
        for (Shape shape : list) {
            shape.affine(d, rect.getX() + d3, d2, rect.getY() + d4, true);
        }
    }

    private void initialPlacementUsingTree() {
        ExtractTree extractTree = new ExtractTree(this, false);
        List<Node> list = extractTree.calculate();
        HashMap<Node, Integer> hashMap = new HashMap<Node, Integer>();
        this.recursivePolarPlace(list, extractTree, 1.0, 0.0, Math.PI * 2, hashMap);
    }

    private void initialPlacementUsingCircle() {
        if (this.nodes.length == 1) {
            this.nodes[0].moveTo(0.0, 0.0);
            return;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            double d = (double)i * Math.PI * 2.0 / (double)this.nodes.length;
            this.nodes[i].moveTo(Math.cos(d), Math.sin(d));
        }
        Crossings crossings = new Crossings(this.nodes, this.links);
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < this.nodes.length; ++i) {
                for (int j = 0; j < i; ++j) {
                    if (!crossings.swap(i, j, 0)) continue;
                    bl = true;
                }
            }
        }
    }

    private void recursivePolarPlace(List<Node> list, ExtractTree extractTree, double d, double d2, double d3, Map<Node, Integer> map) {
        if (list == null) {
            return;
        }
        int n = 0;
        for (Node object : list) {
            n += this.getSize(extractTree, object, map);
        }
        int n2 = 0;
        for (Node node : list) {
            double d4 = d2 + (d3 - d2) * (double)n2 / (double)n;
            double d5 = d2 + (d3 - d2) * (double)(n2 += this.getSize(extractTree, node, map)) / (double)n;
            node.moveTo(d * Math.cos((d4 + d5) / 2.0), d * Math.sin((d4 + d5) / 2.0));
            this.recursivePolarPlace(extractTree.getChildren(node), extractTree, d + 1.0, d4, d5, map);
        }
    }

    private int getSize(ExtractTree extractTree, Node node, Map<Node, Integer> map) {
        Integer n = map.get(node);
        if (n == null) {
            int n2 = 1;
            if (node.getInfo() != null) {
                for (Node node2 : extractTree.getChildren(node)) {
                    n2 += this.getSize(extractTree, node2, map);
                }
            }
            map.put(node, n2);
            return n2;
        }
        return n;
    }

    private void initialize() {
        for (Node node : this.getNodes()) {
            node.setWeight(node.degree());
            for (Node node2 : node.getNeighbors()) {
                node.setWeight(node.getWeight() + node2.degree());
            }
        }
    }

    @Override
    protected void placeInExtent(Dim dim) {
        for (Node node : this.nodes) {
            double d = (double)Math.round(node.getX() * 10.0) / 10.0;
            double d2 = (double)Math.round(node.getY() * 10.0) / 10.0;
            node.moveTo(d, d2);
        }
        if (this.respect_node_size && this.sufficientRoom(dim)) {
            this.info("Attempting to remove overlap");
            this.scaleTo(dim);
            OverlapRemoval overlapRemoval = new OverlapRemoval(this.nodes, dim.getWidth() / dim.getHeight(), 1.0);
            overlapRemoval.layout();
        }
        this.scaleTo(new Dim(1.0, 1.0));
    }

    private boolean sufficientRoom(Dim dim) {
        double d = 0.0;
        for (Node node : this.nodes) {
            d += node.getCurrentBounds().area();
        }
        return d / dim.getWidth() / dim.getHeight() < 0.25;
    }

    public void scaleTo(Dim dim) {
        Range[] rangeArray = this.getNodeRanges();
        double d = dim.getWidth() / rangeArray[0].getRange();
        double d2 = dim.getHeight() / rangeArray[1].getRange();
        double d3 = -rangeArray[0].getMin();
        double d4 = -rangeArray[1].getMin();
        double d5 = (dim.getWidth() - d * rangeArray[0].getRange()) / 2.0;
        double d6 = (dim.getHeight() - d2 * rangeArray[1].getRange()) / 2.0;
        for (Node node : this.nodes) {
            double d7 = d * (node.getX() + d3) + d5;
            double d8 = d2 * (node.getY() + d4) + d6;
            node.moveTo(d7, d8);
        }
    }

    private Range[] getNodeRanges() {
        Range[] rangeArray = new Range[]{Range.EMPTY, Range.EMPTY};
        for (Node node : this.nodes) {
            Rect rect = node.getCurrentBounds();
            rangeArray[0] = rangeArray[0].unionValue(rect.getMinX()).unionValue(rect.getMaxX());
            rangeArray[1] = rangeArray[1].unionValue(rect.getMinY()).unionValue(rect.getMaxY());
        }
        return rangeArray;
    }

    protected void doLayout(Dim dim) {
        this.distances = this.computeDistanceMatrix();
        double d = this.computeLinkLength(this.preferred_edge_length);
        if (this.respect_node_size) {
            this.addNodeSizesToDistances(d);
        }
        this.stressMajorizer = new StressMajorizer(this.getNodes(), this.distances, this.max_iterations, d);
        this.stressMajorizer.run();
    }

    private void addNodeSizesToDistances(double d) {
        for (int i = 0; i < this.nodes.length; ++i) {
            double d2 = this.getNodeRadius(this.nodes[i]);
            for (int j = 0; j < i; ++j) {
                double d3 = this.getNodeRadius(this.nodes[j]);
                double d4 = (d2 + d3 + d) / d;
                double d5 = this.distances.get(i, j);
                double d6 = this.distances.get(j, i);
                if (d5 > 0.0) {
                    this.distances.set(i, j, d5 * d4);
                }
                if (!(d6 > 0.0)) continue;
                this.distances.set(j, i, d6 * d4);
            }
        }
    }

    protected void doMultiLevelLayout(Dim dim) {
        MultilevelCoarsener multilevelCoarsener = new MultilevelCoarsener(this);
        List<LiteGraph> list = multilevelCoarsener.run(6);
        this.detail("Using Mult-level layout", "# levels", list.size());
        MultiLevelUncoarsener multiLevelUncoarsener = new MultiLevelUncoarsener(this, list, dim);
        multiLevelUncoarsener.run();
    }

    public Matrix computeDistanceMatrix() {
        if (this.doSparseOptim()) {
            this.info("Distance Matrix -- Using Sparse Optimization");
            FullMatrix fullMatrix = new FullMatrix(this.getNodesCount(), true);
            this.pivotSet = this.createPivots(this.getNumberOfPivots(), fullMatrix);
            this.detail("Created pivots", "# pivots", this.pivotSet.size());
            this.addLocalDistances(this.close_hop_max, fullMatrix);
            return fullMatrix;
        }
        if (this.linksWeighted()) {
            this.info("Distance Matrix -- Using weighted distance");
            return this.makeWeightedMatrix();
        }
        this.info("Distance Matrix -- Using BFS");
        return new BFSDistance(false, this, Integer.MAX_VALUE).compute();
    }

    private boolean doSparseOptim() {
        return this.getNodesCount() >= 150;
    }

    private int getNumberOfPivots() {
        return Math.min(100, Math.max(20, this.getNodesCount() * this.getNodesCount() / this.getLinksCount()));
    }

    private double computeLinkLength(double d) {
        if (this.respect_node_size) {
            double d2 = d;
            for (Link link : this.getLinks()) {
                d2 = Math.max(d + this.getNodeRadius(link.getFrom()) + this.getNodeRadius(link.getTo()), d2);
            }
            return d2;
        }
        return d;
    }

    private double getNodeRadius(Node node) {
        Rect rect = node.getCurrentBounds();
        return Math.max(rect.getWidth(), rect.getHeight()) / 2.0;
    }

    private Map<Node, Object> createPivots(int n, Matrix matrix) {
        HashMap<Node, Object> hashMap = new HashMap<Node, Object>();
        int n2 = this.getNodesCount();
        n = Math.min(n, n2);
        double[] dArray = new double[n2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.MAX_VALUE;
        }
        Node[] nodeArray = this.getNodes();
        int n3 = 0;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            Object object;
            hashMap.put(nodeArray[n3], this);
            if (this.linksWeighted()) {
                this.detail("Creating pivots using Dijkstra's algorithm", null, null);
                object = new Dijkstra(this, nodeArray[n3], false, Double.MAX_VALUE);
                ((Dijkstra)object).execute();
                for (n5 = 0; n5 < n2; ++n5) {
                    double d = ((Dijkstra)object).getDistance(nodeArray[n5]);
                    matrix.set(n3, n5, d);
                    if (!(d < dArray[n5])) continue;
                    dArray[n5] = d;
                }
            } else {
                this.detail("Creating pivots using depth assignment algorithm", null, null);
                object = new DepthAssignation(this, false);
                arrayList.clear();
                arrayList.add(nodeArray[n3]);
                ((DepthAssignation)object).execute(arrayList);
                for (n5 = 0; n5 < n2; ++n5) {
                    n4 = (Integer)nodeArray[n5].getInfo();
                    matrix.set(n3, n5, n4);
                    if (!((double)n4 < dArray[n5])) continue;
                    dArray[n5] = n4;
                }
            }
            double d = 0.0;
            for (n4 = 0; n4 < n2; ++n4) {
                double d2;
                if (hashMap.containsKey(nodeArray[n4]) || !((d2 = dArray[n4]) > d)) continue;
                d = d2;
                n3 = n4;
            }
        }
        return hashMap;
    }

    private void addLocalDistances(int n, Matrix matrix) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n2 = this.getNodesCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            Object object;
            Node node = this.nodes[i];
            if (this.pivotSet.containsKey(node)) continue;
            if (this.linksWeighted()) {
                object = new Dijkstra(this, node, false, n);
                ((Dijkstra)object).execute();
                for (n3 = 0; n3 < n2; ++n3) {
                    double d = ((Dijkstra)object).getDistance(this.nodes[n3]);
                    if (!(d < 2.147483647E9)) continue;
                    matrix.set(i, n3, d);
                }
                continue;
            }
            object = new DepthAssignation(this, false);
            ((DepthAssignation)object).bound = n;
            arrayList.clear();
            arrayList.add(node);
            ((DepthAssignation)object).execute(arrayList);
            for (n3 = 0; n3 < n2; ++n3) {
                Node node2 = this.nodes[n3];
                int n4 = (Integer)node2.getInfo();
                if (n4 >= Integer.MAX_VALUE) continue;
                matrix.set(i, n3, n4);
            }
        }
    }

    @Override
    protected void setupNodeLayering(Dim dim) {
    }

    @Override
    protected Rect getPaddedBounds(Dim dim) {
        Rect rect = super.getPaddedBounds(dim);
        double d = Math.min(rect.getWidth(), rect.getHeight());
        double d2 = (rect.getWidth() - d) / 2.0 + rect.getX();
        double d3 = (rect.getHeight() - d) / 2.0 + rect.getY();
        return new Rect(d2, d3, d, d);
    }

    private Matrix makeWeightedMatrix() {
        int n = this.getNodesCount();
        FullMatrix fullMatrix = new FullMatrix(n, true);
        double d = -2.147483648E9;
        for (Link link : this.getLinks()) {
            d = Math.max(d, link.getDistanceFactor());
        }
        ((Matrix)fullMatrix).fill(d * 2.0);
        int n2 = 0;
        for (Node object : this.getNodes()) {
            ((Matrix)fullMatrix).set(n2, n2, 0.0);
            object.setInfo(n2++);
        }
        for (Link link : this.getLinks()) {
            double d2 = link.getDistanceFactor();
            Node node = link.getFrom();
            Node node2 = link.getTo();
            int n3 = (Integer)node.getInfo();
            int n4 = (Integer)node2.getInfo();
            d2 = Math.min(d2, ((Matrix)fullMatrix).get(n3, n4));
            ((Matrix)fullMatrix).set(n3, n4, d2);
        }
        return fullMatrix;
    }
}

