/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress;

import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.ConjugateGradient;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.FullMatrix;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.Matrix;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.SparseMatrix;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class StressMajorizer {
    private static final double EPSILON = (double)0.1f;
    private final double[][] pos;
    private final FullMatrix dist;
    private final int iterations;
    private final double edgelength;
    private Node[] nodes;
    private final ConjugateGradient solver;

    public StressMajorizer(Node[] nodeArray, Matrix matrix, int n, double d) {
        this.dist = (FullMatrix)matrix;
        this.nodes = nodeArray;
        this.pos = new double[2][];
        this.pos[0] = new double[nodeArray.length];
        this.pos[1] = new double[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            this.pos[0][i] = nodeArray[i].getX();
            this.pos[1][i] = nodeArray[i].getY();
        }
        this.solver = new ConjugateGradient();
        this.iterations = n;
        this.edgelength = d;
    }

    public void run() {
        Matrix matrix = this.getLaplacian();
        this.majorize(matrix);
        matrix = null;
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].moveTo(this.pos[0][i], this.pos[1][i]);
        }
    }

    private Matrix getLaplacian() {
        int n = this.dist.getSize();
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.0;
        }
        SparseMatrix sparseMatrix = new SparseMatrix(n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double d = this.dist.get(i, j);
                if (d > 1.0E7) {
                    d = 1.0E7;
                }
                if (d == 0.0) continue;
                double d2 = -1.0 / (this.edgelength * d * d);
                ((Matrix)sparseMatrix).set(i, j, d2);
                ((Matrix)sparseMatrix).set(j, i, d2);
                dArray[i] = dArray[i] - d2;
                dArray[j] = dArray[j] - d2;
                n2 += 2;
            }
            ((Matrix)sparseMatrix).set(i, i, dArray[i]);
            ++n2;
        }
        return sparseMatrix;
    }

    protected void majorize(Matrix matrix) {
        int n = matrix.getSize();
        double[] dArray = new double[n];
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.iterations; ++i) {
            double d2 = d;
            this.optimizeOneDimension(matrix, dArray, this.pos[0]);
            d = this.optimizeOneDimension(matrix, dArray, this.pos[1]);
            if (Math.abs(d2 - d) < (double)0.1f) break;
        }
        this.normalize(this.pos[0]);
        this.normalize(this.pos[1]);
    }

    private double optimizeOneDimension(Matrix matrix, double[] dArray, double[] dArray2) {
        double d = 0.0;
        int n = matrix.getSize();
        double[] dArray3 = this.pos[0];
        double[] dArray4 = this.pos[1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.0;
        }
        double[] dArray5 = this.dist.getRawData();
        for (int i = 0; i < n; ++i) {
            double d2 = 0.0;
            double d3 = dArray3[i];
            double d4 = dArray4[i];
            int n2 = i * n;
            for (int j = 0; j < n; ++j) {
                double d5;
                if (i == j || !((d5 = dArray5[n2 + j]) > 0.0)) continue;
                double d6 = d3 - dArray3[j];
                double d7 = d4 - dArray4[j];
                double d8 = Math.sqrt(d6 * d6 + d7 * d7);
                double d9 = -1.0 / (d8 * d5);
                d2 -= d9;
                int n3 = i;
                dArray[n3] = dArray[n3] + d9 * dArray2[j];
                d += (d8 - d5) * (d8 - d5) * d9;
            }
            int n4 = i;
            dArray[n4] = dArray[n4] + d2 * dArray2[i];
        }
        this.solver.solve(matrix, dArray2, dArray);
        return d /= (double)n;
    }

    protected void normalize(double[] dArray) {
        int n;
        double d = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d += dArray[n];
        }
        d /= (double)dArray.length;
        n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] - d;
        }
    }
}

