/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress.distance;

import com.ibm.vis.engine.internal.grammar.layout.graph.AbstractGraphLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.FullMatrix;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.Matrix;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.util.DepthAssignation;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class BFSDistance {
    private final AbstractGraphLayout graph;
    private final boolean directed;
    private final int bound;

    public BFSDistance(boolean bl, AbstractGraphLayout abstractGraphLayout, int n) {
        this.directed = bl;
        this.graph = abstractGraphLayout;
        this.bound = n;
    }

    public Matrix compute() {
        Node[] nodeArray = this.graph.getNodes();
        int n = nodeArray.length;
        FullMatrix fullMatrix = new FullMatrix(n, !this.directed);
        ((Matrix)fullMatrix).fill(2.147483647E9);
        for (int i = 0; i < n; ++i) {
            Node node = nodeArray[i];
            DepthAssignation depthAssignation = new DepthAssignation(this.graph, this.directed);
            depthAssignation.bound = this.bound;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            arrayList.add(node);
            depthAssignation.execute(arrayList);
            for (int j = 0; j < n; ++j) {
                ((Matrix)fullMatrix).set(i, j, Math.min(((Matrix)fullMatrix).get(i, j), (double)((Integer)nodeArray[j].getInfo()).intValue()));
            }
        }
        return fullMatrix;
    }
}

