/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress.distance;

import com.ibm.vis.engine.internal.grammar.layout.graph.AbstractGraphLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Dijkstra {
    private final double bound;
    private final Node source;
    private final boolean directed;
    private final Map<Node, Double> distanceMap;
    private final AbstractGraphLayout g;

    public Dijkstra(AbstractGraphLayout abstractGraphLayout, Node node, boolean bl, double d) {
        this.g = abstractGraphLayout;
        this.source = node;
        this.directed = bl;
        this.bound = d;
        this.distanceMap = new HashMap<Node, Double>();
    }

    /*
     * WARNING - void declaration
     */
    public void execute() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node linkArray : this.g.getNodes()) {
            if (linkArray != this.source) {
                this.setDistance(linkArray, 2.147483647E9);
            } else {
                this.setDistance(linkArray, 0.0);
            }
            arrayList.add(linkArray);
        }
        while (arrayList.size() > 0) {
            Node node = this.getSmallest(arrayList);
            double d = this.getDistance(node);
            if (d <= this.bound) {
                void var5_11;
                Object var5_8 = null;
                if (this.directed) {
                    Link[] linkArray = node.getOutLink();
                } else {
                    Link[] linkArray = node.getLinks();
                }
                for (void var9_15 : var5_11) {
                    Node node2 = var9_15.getOpposite(node);
                    if (!(d + var9_15.getDistanceFactor() < this.getDistance(node2))) continue;
                    boolean bl = arrayList.remove(node2);
                    this.setDistance(node2, d + var9_15.getDistanceFactor());
                    if (!bl) continue;
                    arrayList.add(node2);
                }
                arrayList.remove(node);
                continue;
            }
            arrayList.clear();
        }
    }

    private Node getSmallest(List<Node> list) {
        Node node = null;
        double d = 0.0;
        for (Node node2 : list) {
            double d2 = this.getDistance(node2);
            if (node != null && !(d2 < d)) continue;
            node = node2;
            d = d2;
        }
        return node;
    }

    protected void setDistance(Node node, double d) {
        this.distanceMap.put(node, d);
    }

    public double getDistance(Node node) {
        return this.distanceMap.get(node);
    }
}

