/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress.force;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.graph.AbstractGraphLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.force.ForceLayoutQuadTree;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.force.QuadTreeNode;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.force.QuadTreeNodeVisitor;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.force.QuadTreeRootNode;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.SimpleRNG;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/graphLayoutsLayer")
public class ForceLayout
extends AbstractGraphLayout {
    private final int MAX_STEP = 25;
    private final long RAND_SEED = 37L;
    private final double FRICTION = 0.9;
    private final double GRAVITY = 0.1;
    private final double THETA2 = 0.64;
    private final double LINK_DISTANCE = 20.0;
    private final double LINK_STRENGTH = 1.0;
    private final double NODE_CHARGE = -30.0;
    private final double CHARGE_DISTANCE2 = Double.MAX_VALUE;
    private final SimpleRNG RNG = SimpleRNG.getSeededRNG(37L);
    private double alpha = 0.1;
    private double w;
    private double half_w;
    private double h;
    private double half_h;
    private int nodesCount;
    private int linksCount;
    private double[] linkDistances;
    private double[] linkStrengths;
    private double[] nodeCharges;
    private Point[] nodesPreviousPositions;

    public ForceLayout(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
    }

    @Override
    public void layoutNodes(Dim dim) {
        int n;
        this.nodesCount = this.nodes.length;
        this.linksCount = this.links.length;
        this.nodeCharges = new double[this.nodesCount];
        this.linkDistances = new double[this.linksCount];
        this.linkStrengths = new double[this.linksCount];
        this.w = dim.getWidth();
        this.half_w = this.w / 2.0;
        this.h = dim.getHeight();
        this.half_h = this.h / 2.0;
        this.nodesPreviousPositions = new Point[this.nodesCount];
        int n2 = this.nodesCount;
        for (n = 0; n < n2; ++n) {
            this.nodesPreviousPositions[n] = new Point(0.0, 0.0);
        }
        this.initializeNodesPositions();
        this.initializeLinksDistances();
        this.initializeLinksStrengths();
        this.initializeNodesCharges();
        for (n = 0; n < 25 && !this.tick(); ++n) {
        }
    }

    private void initializeNodesCharges() {
        int n = this.nodeCharges.length;
        for (int i = 0; i < n; ++i) {
            this.nodeCharges[i] = -30.0;
        }
    }

    private void initializeLinksStrengths() {
        int n = this.linkStrengths.length;
        for (int i = 0; i < n; ++i) {
            this.linkStrengths[i] = 1.0;
        }
    }

    private void initializeLinksDistances() {
        int n = this.linkDistances.length;
        for (int i = 0; i < n; ++i) {
            this.linkDistances[i] = 20.0;
        }
    }

    private void initializeNodesPositions() {
        for (int i = 0; i < this.nodesCount; ++i) {
            Node node = this.nodes[i];
            double d = 0.0;
            double d2 = 0.0;
            d = (double)this.RNG.random() * this.w;
            d2 = (double)this.RNG.random() * this.h;
            node.setX(d);
            node.setY(d2);
            Point point = this.nodesPreviousPositions[i];
            point.setX(d);
            point.setY(d2);
        }
    }

    @Override
    protected void setupNodeLayering(Dim dim) {
    }

    private void forceAccumulate(QuadTreeNode quadTreeNode) {
        double d = 0.0;
        double d2 = 0.0;
        quadTreeNode.charge = 0.0;
        if (!quadTreeNode.leaf) {
            int n = -1;
            while (++n < 4) {
                QuadTreeNode quadTreeNode2 = quadTreeNode.childQuadNodes[n];
                if (quadTreeNode2 == null) continue;
                this.forceAccumulate(quadTreeNode2);
                quadTreeNode.charge += quadTreeNode2.charge;
                d += quadTreeNode2.charge * quadTreeNode2.cx;
                d2 += quadTreeNode2.charge * quadTreeNode2.cy;
            }
        }
        if (quadTreeNode.node != null) {
            if (!quadTreeNode.leaf) {
                double d3 = quadTreeNode.node.getX();
                double d4 = quadTreeNode.node.getY();
                quadTreeNode.node.setX(d3 += (double)this.RNG.random() - 0.5);
                quadTreeNode.node.setY(d4 += (double)this.RNG.random() - 0.5);
            }
            quadTreeNode.nodeCharge = this.alpha * this.nodeCharges[quadTreeNode.node.getRow()];
            quadTreeNode.charge += quadTreeNode.nodeCharge;
            d += quadTreeNode.nodeCharge * quadTreeNode.node.getX();
            d2 += quadTreeNode.nodeCharge * quadTreeNode.node.getY();
        }
        quadTreeNode.cx = d / quadTreeNode.charge;
        quadTreeNode.cy = d2 / quadTreeNode.charge;
    }

    private boolean tick() {
        double d;
        double d2;
        Node node;
        Object object;
        int n;
        double d3;
        this.alpha *= 0.99;
        if (d3 < 0.005) {
            return true;
        }
        for (n = 0; n < this.linksCount; ++n) {
            double d4;
            double d5;
            object = this.links[n];
            Node node2 = ((Link)object).getFrom();
            node = ((Link)object).getTo();
            d2 = node.getX();
            double d6 = node.getY();
            double d7 = node2.getX();
            double d8 = d2 - d7;
            double d9 = d8 * d8 + (d5 = d6 - (d4 = node2.getY())) * d5;
            if (d9 == 0.0) continue;
            d9 = Math.sqrt(d9);
            d9 = this.alpha * this.linkStrengths[n] * (d9 - this.linkDistances[n]) / d9;
            double d10 = node2.degree();
            double d11 = node.degree() + node2.degree();
            d = d10 / d11;
            node.setX(d2 -= (d8 *= d9) * d);
            node.setY(d6 -= (d5 *= d9) * d);
            d = 1.0 - d;
            node2.setX(d7 += d8 * d);
            node2.setY(d4 += d5 * d);
        }
        d = this.alpha * 0.1;
        if (d != 0.0) {
            n = -1;
            if (d != 0.0) {
                while (++n < this.nodesCount) {
                    object = this.nodes[n];
                    double d12 = ((Node)object).getX();
                    d2 = ((Node)object).getY();
                    d12 += (this.half_w - d12) * d;
                    d2 += (this.half_h - d2) * d;
                    ((Node)object).setX(d12);
                    ((Node)object).setY(d2);
                }
            }
        }
        QuadTreeRootNode quadTreeRootNode = ForceLayoutQuadTree.constructQuadTree(this.nodes);
        this.forceAccumulate(quadTreeRootNode);
        int n2 = -1;
        QuadTreeNodeVisitor quadTreeNodeVisitor = new QuadTreeNodeVisitor();
        while (++n2 < this.nodesCount) {
            node = this.nodes[n2];
            quadTreeNodeVisitor.setData(node, 0.64, Double.MAX_VALUE, this.nodesPreviousPositions[n2]);
            quadTreeRootNode.accept(quadTreeNodeVisitor, quadTreeRootNode.x1_, quadTreeRootNode.y1_, quadTreeRootNode.x2_, quadTreeRootNode.y2_);
        }
        int n3 = -1;
        while (++n3 < this.nodesCount) {
            Node node3 = this.nodes[n3];
            double d13 = node3.getX();
            d2 = node3.getY();
            Point point = this.nodesPreviousPositions[n3];
            double d14 = point.getX();
            double d15 = point.getY();
            point.setX(d13);
            point.setY(d2);
            d13 -= (d14 - d13) * 0.9;
            d2 -= (d15 - d2) * 0.9;
            node3.setX(d13);
            node3.setY(d2);
        }
        return false;
    }
}

