/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress.force;

import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.force.QuadTreeNode;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.force.QuadTreeRootNode;

class ForceLayoutQuadTree {
    ForceLayoutQuadTree() {
    }

    static final QuadTreeRootNode constructQuadTree(Node[] nodeArray) {
        double d;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MIN_VALUE;
        double d5 = Double.MIN_VALUE;
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            Node node = nodeArray[i];
            d = node.getX();
            double d6 = node.getY();
            if (d < d2) {
                d2 = d;
            }
            if (d6 < d3) {
                d3 = d6;
            }
            if (d > d4) {
                d4 = d;
            }
            if (!(d6 > d5)) continue;
            d5 = d6;
        }
        double d7 = d4 - d2;
        d = d4 - d3;
        if (d7 > d) {
            d5 = d3 + d7;
        } else {
            d4 = d2 + d;
        }
        QuadTreeRootNode quadTreeRootNode = new QuadTreeRootNode(d2, d3, d4, d5);
        int n2 = -1;
        while (++n2 < n) {
            Node node = nodeArray[n2];
            ForceLayoutQuadTree.insert(quadTreeRootNode, nodeArray[n2], node.getX(), node.getY(), d2, d3, d4, d5);
        }
        return quadTreeRootNode;
    }

    private static void insert(QuadTreeNode quadTreeNode, Node node, double d, double d2, double d3, double d4, double d5, double d6) {
        if (quadTreeNode.leaf) {
            if (quadTreeNode.node != null) {
                double d7 = quadTreeNode.node.getX();
                double d8 = quadTreeNode.node.getY();
                if (Math.abs(d7 - d) + Math.abs(d8 - d2) < 0.01) {
                    ForceLayoutQuadTree.insertChild(quadTreeNode, node, d, d2, d3, d4, d5, d6);
                } else {
                    Node node2 = quadTreeNode.node;
                    quadTreeNode.node = null;
                    ForceLayoutQuadTree.insertChild(quadTreeNode, node2, d7, d8, d3, d4, d5, d6);
                    ForceLayoutQuadTree.insertChild(quadTreeNode, node, d, d2, d3, d4, d5, d6);
                }
            } else {
                quadTreeNode.node = node;
            }
        } else {
            ForceLayoutQuadTree.insertChild(quadTreeNode, node, d, d2, d3, d4, d5, d6);
        }
    }

    private static void insertChild(QuadTreeNode quadTreeNode, Node node, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d3 + d5) * 0.5;
        double d8 = (d4 + d6) * 0.5;
        int n = d >= d7 ? 1 : 0;
        int n2 = d2 >= d8 ? 1 : 0;
        int n3 = n2 * 2 + n;
        quadTreeNode.leaf = false;
        if (quadTreeNode.childQuadNodes[n3] == null) {
            quadTreeNode.childQuadNodes[n3] = new QuadTreeNode();
        }
        quadTreeNode = quadTreeNode.childQuadNodes[n3];
        if (n == 1) {
            d3 = d7;
        } else {
            d5 = d7;
        }
        if (n2 == 1) {
            d4 = d8;
        } else {
            d6 = d8;
        }
        ForceLayoutQuadTree.insert(quadTreeNode, node, d, d2, d3, d4, d5, d6);
    }
}

