/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress.force;

import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.force.QuadTreeNode;
import com.ibm.vis.geom.Point;

class QuadTreeNodeVisitor {
    private double theta2;
    private double chargeDistance2;
    private Point nodePreviousPosition;
    private Node node;

    QuadTreeNodeVisitor() {
    }

    final void setData(Node node, double d, double d2, Point point) {
        this.node = node;
        this.theta2 = d;
        this.chargeDistance2 = d2;
        this.nodePreviousPosition = point;
    }

    final boolean visit(QuadTreeNode quadTreeNode, double d, double d2, double d3, double d4) {
        if (quadTreeNode.node != this.node) {
            double d5;
            double d6 = d3 - d;
            double d7 = quadTreeNode.cx - this.node.getX();
            double d8 = d7 * d7 + (d5 = quadTreeNode.cy - this.node.getY()) * d5;
            if (d6 * d6 / this.theta2 < d8) {
                if (d8 < this.chargeDistance2) {
                    double d9 = quadTreeNode.charge / d8;
                    this.nodePreviousPosition.setX(this.nodePreviousPosition.getX() - d7 * d9);
                    this.nodePreviousPosition.setY(this.nodePreviousPosition.getY() - d5 * d9);
                }
                return true;
            }
            if (quadTreeNode.node != null && d8 != 0.0 && d8 < this.chargeDistance2) {
                double d10 = quadTreeNode.nodeCharge / d8;
                this.nodePreviousPosition.setX(this.nodePreviousPosition.getX() - d7 * d10);
                this.nodePreviousPosition.setY(this.nodePreviousPosition.getY() - d5 * d10);
            }
        }
        return quadTreeNode.charge == 0.0;
    }
}

