/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix;

import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.Matrix;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ConjugateGradient {
    public int solve(Matrix matrix, double[] dArray, double[] dArray2) {
        int n;
        int n2 = this.solveForStartingPoint(matrix, dArray, dArray2, 200);
        if (n2 != -1) {
            return n2;
        }
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = 1.0;
        }
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = dArray2[n];
        }
        n2 = this.solveForStartingPoint(matrix, dArray, dArray2, 1000);
        if (n2 != -1) {
            return n2;
        }
        throw new RuntimeException("Failed to converge");
    }

    private int solveForStartingPoint(Matrix matrix, double[] dArray, double[] dArray2, int n) {
        int n2 = dArray.length;
        double[] dArray3 = this.makePreconditioningDiagonal(matrix, n2);
        double[] dArray4 = matrix.multiply(dArray, null);
        for (int i = 0; i < n2; ++i) {
            dArray4[i] = dArray2[i] - dArray4[i];
        }
        double[] dArray5 = new double[n2];
        this.diagMultiply(dArray3, dArray4, dArray5);
        double[] dArray6 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray6[i] = dArray5[i];
        }
        double d = this.product(dArray4, dArray5);
        double[] dArray7 = new double[n2];
        for (int i = 1; i < n; ++i) {
            int n3;
            matrix.multiply(dArray6, dArray7);
            double d2 = d / this.product(dArray6, dArray7);
            double d3 = 0.0;
            for (int j = 0; j < n2; ++j) {
                int n4 = j;
                dArray[n4] = dArray[n4] + d2 * dArray6[j];
                int n5 = j;
                dArray4[n5] = dArray4[n5] - d2 * dArray7[j];
                d3 += dArray4[j] * dArray4[j];
            }
            if (d3 < 1.0E-4) {
                return i;
            }
            double d4 = 0.0;
            for (n3 = 0; n3 < n2; ++n3) {
                dArray5[n3] = dArray3[n3] * dArray4[n3];
                d4 += dArray4[n3] * dArray5[n3];
            }
            for (n3 = 0; n3 < n2; ++n3) {
                dArray6[n3] = d4 / d * dArray6[n3] + dArray5[n3];
            }
            d = d4;
        }
        return -1;
    }

    private double[] diagMultiply(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] * dArray2[i];
        }
        return dArray3;
    }

    private double[] makePreconditioningDiagonal(Matrix matrix, int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = matrix.get(i, i);
            if (d < 0.01) {
                d = 0.01;
            }
            dArray[i] = 1.0 / d;
        }
        return dArray;
    }

    private double product(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }
}

