/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix;

import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.Vector;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class FullConstantVector
extends Vector {
    private double[] values;

    FullConstantVector(int n, Map<Integer, Double> map) {
        this.values = new double[n];
        for (Integer n2 : map.keySet()) {
            this.values[n2.intValue()] = map.get(n2);
        }
    }

    @Override
    void set(int n, double d) {
        throw new RuntimeException("Cannot modify a constant vector");
    }

    @Override
    double get(int n) {
        return this.values[n];
    }

    @Override
    double dot(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            d += this.values[i] * dArray[i];
        }
        return d;
    }
}

