/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix;

import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.Matrix;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FullMatrix
extends Matrix {
    private final double[] d;
    private final boolean symmetric;

    public FullMatrix(int n, boolean bl) {
        super(n);
        this.symmetric = bl;
        this.d = new double[n * n];
        for (int i = 0; i < this.d.length; ++i) {
            this.d[i] = 0.0;
        }
    }

    @Override
    public void set(int n, int n2, double d) {
        this.d[n * this.n + n2] = d;
        if (this.symmetric) {
            this.d[n2 * this.n + n] = d;
        }
    }

    @Override
    public final double get(int n, int n2) {
        return this.d[n * this.n + n2];
    }

    @Override
    public void fill(double d) {
        for (int i = 0; i < this.d.length; ++i) {
            this.d[i] = d;
        }
    }

    @Override
    public double[] multiply(double[] dArray, double[] dArray2) {
        assert (dArray.length == this.n);
        if (dArray2 == null) {
            dArray2 = new double[this.n];
        }
        for (int i = 0; i < this.n; ++i) {
            double d = 0.0;
            int n = i * this.n;
            for (int j = 0; j < this.n; ++j) {
                d += this.d[n + j] * dArray[j];
            }
            dArray2[i] = d;
        }
        return dArray2;
    }

    public final double[] getRawData() {
        return this.d;
    }
}

