/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix;

import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.Vector;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class SparseConstantVector
extends Vector {
    private final int[] index;
    private final double[] values;

    SparseConstantVector(Map<Integer, Double> map) {
        this.index = new int[map.size()];
        this.values = new double[this.index.length];
        int n = 0;
        for (Integer n2 : map.keySet()) {
            this.index[n] = n2;
            this.values[n] = map.get(n2);
            ++n;
        }
    }

    @Override
    void set(int n, double d) {
        throw new RuntimeException("Cannot modify a constant vector");
    }

    @Override
    double get(int n) {
        for (int i = 0; i < this.index.length; ++i) {
            if (this.index[i] != n) continue;
            return this.values[i];
        }
        return 0.0;
    }

    @Override
    double dot(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.index.length; ++i) {
            d += this.values[i] * dArray[this.index[i]];
        }
        return d;
    }
}

