/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix;

import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.FullConstantVector;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.Matrix;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.SparseConstantVector;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.SparseMutableVector;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.matrix.Vector;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SparseMatrix
extends Matrix {
    final Vector[] d;
    boolean immutable = false;

    public SparseMatrix(int n) {
        super(n);
        this.d = new Vector[n];
        for (int i = 0; i < n; ++i) {
            this.d[i] = new SparseMutableVector();
        }
    }

    @Override
    public void set(int n, int n2, double d) {
        this.d[n].set(n2, d);
    }

    @Override
    public double get(int n, int n2) {
        return this.d[n].get(n2);
    }

    @Override
    public void fill(double d) {
        throw new RuntimeException("Cannot fill Sparse Matrices");
    }

    @Override
    public double[] multiply(double[] dArray, double[] dArray2) {
        int n;
        if (!this.immutable) {
            for (n = 0; n < this.n; ++n) {
                Map<Integer, Double> map = ((SparseMutableVector)this.d[n]).getMap();
                this.d[n] = (double)map.size() > 0.5 * (double)this.n ? new FullConstantVector(this.n, map) : new SparseConstantVector(map);
            }
            this.immutable = true;
        }
        if (dArray2 == null) {
            dArray2 = new double[this.n];
        }
        for (n = 0; n < this.n; ++n) {
            dArray2[n] = this.d[n].dot(dArray);
        }
        return dArray2;
    }
}

