/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress.util;

import com.ibm.vis.engine.internal.grammar.layout.graph.AbstractGraphLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class BFS {
    protected final AbstractGraphLayout graph;
    protected final Map<Node, Object> visitedItems;
    protected final boolean directed;
    protected int depth = 0;
    public int bound = Integer.MAX_VALUE;

    public BFS(AbstractGraphLayout abstractGraphLayout, boolean bl) {
        this.graph = abstractGraphLayout;
        this.directed = bl;
        this.visitedItems = new HashMap<Node, Object>();
    }

    public void execute(List<Node> list) {
        this.visitedItems.clear();
        this.bfsVisit(list);
        this.visitedItems.clear();
    }

    protected void bfsVisit(List<Node> list) {
        if (list.isEmpty()) {
            return;
        }
        HashMap<Node, Node> hashMap = new HashMap<Node, Node>();
        HashMap<Node, Node> hashMap2 = new HashMap<Node, Node>();
        for (Node object : list) {
            hashMap2.put(object, object);
            this.markNode(object);
        }
        if (this.depth == this.bound) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (Node node : list) {
            Link[] linkArray;
            for (Link link : linkArray = this.directed ? node.getOutLink() : node.getLinks()) {
                Node node2 = link.getOpposite(node);
                if (this.isMarkedNode(node2)) continue;
                this.discoverLink(link, node);
                if (hashMap.containsKey(node2)) continue;
                hashMap.put(node2, node2);
                arrayList.add(node2);
            }
        }
        this.processNextLevel(arrayList);
    }

    protected boolean isMarkedNode(Node node) {
        return this.visitedItems.containsKey(node);
    }

    protected void markNode(Node node) {
        this.visitedItems.put(node, node);
    }

    protected void discoverLink(Link link, Node node) {
    }

    protected void processNextLevel(List<Node> list) {
        ++this.depth;
        this.bfsVisit(list);
    }
}

