/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress.util;

import com.ibm.vis.engine.internal.grammar.layout.graph.AbstractGraphLayout;
import com.ibm.vis.engine.internal.grammar.layout.graph.Link;
import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.util.BFS;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.util.Farthest;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ExtractTree
extends BFS {
    private final Map<Node, List<Node>> children = new HashMap<Node, List<Node>>();

    public ExtractTree(AbstractGraphLayout abstractGraphLayout, boolean bl) {
        super(abstractGraphLayout, bl);
        assert (!bl);
    }

    public List<Node> calculate() {
        this.children.clear();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        HashMap<Node, Object> hashMap = new HashMap<Node, Object>();
        for (Node node : this.graph.getNodes()) {
            if (hashMap.containsKey(node)) continue;
            Node node2 = this.findCenter(node);
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            arrayList2.add(node2);
            this.execute(arrayList2);
            arrayList.add(node2);
            this.markHandled(node2, hashMap);
        }
        return arrayList;
    }

    public List<Node> getChildren(Node node) {
        return this.children.get(node);
    }

    private void markHandled(Node node, Map<Node, Object> map) {
        map.put(node, node);
        for (Node node2 : this.children.get(node)) {
            this.markHandled(node2, map);
        }
    }

    @Override
    protected void markNode(Node node) {
        super.markNode(node);
        this.children.put(node, new ArrayList());
    }

    @Override
    protected void discoverLink(Link link, Node node) {
        super.discoverLink(link, node);
        Node node2 = link.getOpposite(node);
        if (!this.children.containsKey(node2)) {
            List<Node> list = this.children.get(node);
            list.add(node2);
            this.children.put(node2, new ArrayList());
        }
    }

    private Node findCenter(Node node) {
        Farthest farthest = this.findFarthest(node);
        Node node2 = farthest.getResult();
        int n = farthest.getDistance();
        while ((farthest = this.findFarthest(node2)).getDistance() > n) {
            node = node2;
            node2 = farthest.getResult();
            n = farthest.getDistance();
        }
        return this.findFarthest2(node, node2).getResult();
    }

    private Farthest findFarthest(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(node);
        Farthest farthest = new Farthest(this.graph, false);
        farthest.execute(arrayList);
        return farthest;
    }

    private Farthest findFarthest2(Node node, Node node2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(node);
        arrayList.add(node2);
        Farthest farthest = new Farthest(this.graph, false);
        farthest.execute(arrayList);
        return farthest;
    }
}

